/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.execution;

import io.automatiko.engine.api.auth.IdentityProvider;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.IsoFields;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"io.automatiko.logger");

    public static boolean isEqual(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }

    public static boolean isNumber(Object o) {
        return o instanceof Number;
    }

    public static <T> T previousVersion(List<T> versions) {
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        return versions.get(versions.size() - 1);
    }

    public static <T> T variableVersion(List<T> versions, int version) {
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        try {
            return versions.get(version);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static void log(Object value) {
        LOGGER.info(value == null ? "" : value.toString());
    }

    public static void log(String template, Object ... items) {
        LOGGER.info(template, items);
    }

    public static void logWarning(String template, Object ... items) {
        LOGGER.warn(template, items);
    }

    public static void logError(String template, Object ... items) {
        LOGGER.error(template, items);
    }

    public static String todayDate() {
        return LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String todayYearAndMonth() {
        LocalDate now = LocalDate.now();
        return now.getYear() + "-" + now.getMonthValue();
    }

    public static String todayMonth() {
        return LocalDate.now().getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault());
    }

    public static String previousMonth() {
        return LocalDate.now().minusMonths(1L).getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault());
    }

    public static String nextMonth() {
        return LocalDate.now().plusMonths(1L).getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault());
    }

    public static String todayDay() {
        return LocalDate.now().getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault());
    }

    public static String yesterdayDay() {
        return LocalDate.now().minusDays(1L).getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault());
    }

    public static String tomorrowDay() {
        return LocalDate.now().plusDays(1L).getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault());
    }

    public static String todayQuarter() {
        int current = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        String value = null;
        switch (current) {
            case 1: {
                value = "I";
                break;
            }
            case 2: {
                value = "II";
                break;
            }
            case 3: {
                value = "III";
                break;
            }
            case 4: {
                value = "IV";
                break;
            }
        }
        return value;
    }

    public static String previousQuarter() {
        int current = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        String previous = null;
        switch (current) {
            case 1: {
                previous = "IV";
                break;
            }
            case 2: {
                previous = "I";
                break;
            }
            case 3: {
                previous = "II";
                break;
            }
            case 4: {
                previous = "III";
                break;
            }
        }
        return previous;
    }

    public static String nextQuarter() {
        int current = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        String next = null;
        switch (current) {
            case 1: {
                next = "II";
                break;
            }
            case 2: {
                next = "III";
                break;
            }
            case 3: {
                next = "IV";
                break;
            }
            case 4: {
                next = "I";
                break;
            }
        }
        return next;
    }

    public static String identityName() {
        if (IdentityProvider.isSet()) {
            return IdentityProvider.get().getName();
        }
        return null;
    }

    public static String identityName(String whenNotFound) {
        String name = null;
        if (IdentityProvider.isSet()) {
            name = IdentityProvider.get().getName();
        }
        if (name != null) {
            return name;
        }
        return whenNotFound;
    }

    public static Object identityProperty(String name) {
        return BaseFunctions.identityProperty(name, null);
    }

    public static Object identityProperty(String name, String defaultValue) {
        if (IdentityProvider.isSet()) {
            return IdentityProvider.get().properties().getOrDefault(name, defaultValue);
        }
        return defaultValue;
    }

    public static boolean identityHasRole(String role) {
        if (IdentityProvider.isSet()) {
            return IdentityProvider.get().hasRole(role);
        }
        return false;
    }

    public static boolean identityHasAnyRole(String ... roles) {
        if (IdentityProvider.isSet()) {
            return Stream.of(roles).anyMatch(role -> IdentityProvider.get().hasRole(role));
        }
        return false;
    }

    public static boolean identityHasAllRoles(String ... roles) {
        if (IdentityProvider.isSet()) {
            return Stream.of(roles).allMatch(role -> IdentityProvider.get().hasRole(role));
        }
        return false;
    }

    public static String listToCommaDelimitedString(Collection<String> values) {
        if (values == null) {
            return null;
        }
        return values.stream().collect(Collectors.joining(","));
    }
}

