/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.identity;

import io.automatiko.engine.api.auth.IdentityProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StaticIdentityProvider
implements IdentityProvider {
    private String adminRoleName = "admin";
    private String name;
    private List<String> roles;
    private Map<String, Object> properties;

    public StaticIdentityProvider(String name) {
        this(name, Collections.emptyList());
    }

    public StaticIdentityProvider(String name, List<String> roles) {
        this(name, roles, Collections.emptyMap());
    }

    public StaticIdentityProvider(String name, List<String> roles, Map<String, Object> properties) {
        this.name = name;
        this.roles = roles == null ? Collections.emptyList() : roles;
        this.properties = properties;
    }

    public StaticIdentityProvider(String adminRoleName, String name) {
        this(name, Collections.emptyList());
    }

    public StaticIdentityProvider(String adminRoleName, String name, List<String> roles) {
        this(name, roles, Collections.emptyMap());
    }

    public StaticIdentityProvider(String adminRoleName, String name, List<String> roles, Map<String, Object> properties) {
        this.adminRoleName = adminRoleName;
        this.name = name;
        this.roles = roles == null ? Collections.emptyList() : roles;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public void addProperties(Map<String, Object> props) {
        this.properties.putAll(props);
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public boolean isAdmin() {
        return this.hasRole(this.adminRoleName);
    }
}

