/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.io;

import io.automatiko.engine.api.io.Resource;
import io.automatiko.engine.api.io.ResourceConfiguration;
import io.automatiko.engine.api.io.ResourceType;
import io.automatiko.engine.services.io.InternalResource;
import io.automatiko.engine.services.utils.IoUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class BaseResource
implements InternalResource {
    private ResourceType resourceType;
    private String sourcePath;
    private String targetPath;
    private String description;
    private List<String> categories;
    protected byte[] bytes;

    @Override
    public InternalResource setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Override
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public ResourceConfiguration getConfiguration() {
        return null;
    }

    public Resource setConfiguration(ResourceConfiguration conf) {
        return null;
    }

    public InternalResource setSourcePath(String path) {
        this.sourcePath = path;
        return this;
    }

    public InternalResource setTargetPath(String path) {
        this.targetPath = path;
        return this;
    }

    @Override
    public List<String> getCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        return this.categories;
    }

    @Override
    public void setCategories(String categories) {
        List<String> list = this.getCategories();
        list.clear();
        if (categories != null) {
            StringTokenizer tok = new StringTokenizer(categories, ",");
            while (tok.hasMoreTokens()) {
                list.add(tok.nextToken());
            }
        }
    }

    @Override
    public void addCategory(String tag) {
        this.getCategories().add(tag);
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes == null) {
            try {
                this.bytes = IoUtils.readBytesFromInputStream(this.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.bytes;
    }

    public String toString() {
        return this.getSourcePath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource that = (Resource)o;
        return this.sourcePath != null ? this.sourcePath.equals(that.getSourcePath()) : that.getSourcePath() == null;
    }

    public int hashCode() {
        return this.sourcePath != null ? this.sourcePath.hashCode() : 0;
    }
}

