/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.io;

import io.automatiko.engine.api.io.Resource;
import io.automatiko.engine.services.io.BaseResource;
import io.automatiko.engine.services.io.InternalResource;
import io.automatiko.engine.services.utils.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;

public class ByteArrayResource
extends BaseResource
implements InternalResource {
    private String encoding;

    public ByteArrayResource() {
    }

    public ByteArrayResource(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Provided byte array can not be null");
        }
        this.bytes = bytes;
    }

    public ByteArrayResource(byte[] bytes, String encoding) {
        this(bytes);
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream(), IoUtils.UTF8_CHARSET);
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public boolean hasURL() {
        return false;
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException("byte[] cannot be resolved to URL");
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof ByteArrayResource && Arrays.equals(((ByteArrayResource)object).bytes, this.bytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public String toString() {
        return "ByteArrayResource[bytes=" + this.firstNBytesToString(10) + ", encoding=" + this.encoding + "]";
    }

    private String firstNBytesToString(int nrOfBytes) {
        String str = Arrays.toString(Arrays.copyOf(this.bytes, Math.min(this.bytes.length, nrOfBytes)));
        return this.bytes.length > nrOfBytes ? str.substring(0, str.length() - 1) + ", ...]" : str;
    }
}

