/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.io;

import io.automatiko.engine.api.io.Resource;
import io.automatiko.engine.api.io.ResourceType;
import io.automatiko.engine.services.io.BaseResource;
import io.automatiko.engine.services.io.InternalResource;
import io.automatiko.engine.services.utils.IoUtils;
import io.automatiko.engine.services.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public class FileSystemResource
extends BaseResource
implements InternalResource {
    private File file;
    private String encoding;

    public FileSystemResource() {
    }

    public FileSystemResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        this.file = new File(StringUtils.cleanPath(file.getPath()));
        try {
            this.setSourcePath(file.getCanonicalPath());
        }
        catch (IOException e) {
            this.setSourcePath(file.getAbsolutePath());
        }
        this.setResourceType(ResourceType.determineResourceType((String)this.getSourcePath()));
    }

    public FileSystemResource(File file, String encoding) {
        this(file);
        this.encoding = encoding;
    }

    public FileSystemResource(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null");
        }
        this.file = new File(StringUtils.cleanPath(path));
        this.setSourcePath(path);
        this.setResourceType(ResourceType.determineResourceType((String)this.getSourcePath()));
    }

    public FileSystemResource(String path, String encoding) {
        this(path);
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public InputStream getInputStream() throws IOException {
        return this.bytes != null ? new ByteArrayInputStream(this.bytes) : new FileInputStream(this.file);
    }

    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream(), IoUtils.UTF8_CHARSET);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public Collection<Resource> listResources() {
        File[] files = this.file.listFiles();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (File file : files) {
            resources.add(new FileSystemResource(file));
        }
        return resources;
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public boolean hasURL() {
        return true;
    }

    @Override
    public String toString() {
        return "FileResource[file=" + this.file.toString() + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object == this || object instanceof FileSystemResource && this.file.equals(((FileSystemResource)object).file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }
}

