/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.io;

import io.automatiko.engine.api.io.Resource;
import io.automatiko.engine.services.io.BaseResource;
import io.automatiko.engine.services.io.InternalResource;
import io.automatiko.engine.services.utils.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;

public class InputStreamResource
extends BaseResource
implements InternalResource {
    private transient InputStream stream;
    private String encoding;

    public InputStreamResource() {
    }

    public InputStreamResource(InputStream stream) {
        this(stream, null);
    }

    public InputStreamResource(InputStream stream, String encoding) {
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.stream = stream;
        this.encoding = encoding;
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes == null) {
            try {
                this.bytes = IoUtils.readBytesFromInputStream(this.stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.bytes;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getBytes());
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream(), IoUtils.UTF8_CHARSET);
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException("InputStream cannot be resolved to URL");
    }

    @Override
    public boolean hasURL() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }
}

