/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.io;

import io.automatiko.engine.api.io.Resource;
import io.automatiko.engine.api.io.ResourceType;
import io.automatiko.engine.services.io.BaseResource;
import io.automatiko.engine.services.io.InternalResource;
import io.automatiko.engine.services.io.ReaderInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;

public class ReaderResource
extends BaseResource
implements InternalResource {
    private static final long serialVersionUID = -2554750160404141191L;
    private transient Reader reader;
    private String encoding;

    public ReaderResource() {
    }

    public ReaderResource(Reader reader) {
        this(reader, null, null);
    }

    public ReaderResource(Reader reader, ResourceType type) {
        this(reader, null, type);
    }

    public ReaderResource(Reader reader, String encoding) {
        this(reader, encoding, null);
    }

    public ReaderResource(Reader reader, String encoding, ResourceType type) {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null");
        }
        this.encoding = encoding == null && reader instanceof InputStreamReader ? ((InputStreamReader)reader).getEncoding() : encoding;
        this.reader = reader;
        this.setResourceType(type);
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException("reader cannot be resolved to URL");
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.reader.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.encoding != null) {
            return new ReaderInputStream.NonCloseable(this.reader, this.encoding);
        }
        return new ReaderInputStream.NonCloseable(this.reader);
    }

    public Reader getReader() {
        return this.reader;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    @Override
    public boolean hasURL() {
        return false;
    }

    @Override
    public String toString() {
        return "ReaderResource[resource=" + String.valueOf(this.reader) + ",encoding=" + this.encoding + "]";
    }
}

