/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.jobs.impl;

import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.TrustedIdentityProvider;
import io.automatiko.engine.api.jobs.JobDescription;
import io.automatiko.engine.api.jobs.JobsService;
import io.automatiko.engine.api.jobs.ProcessInstanceJobDescription;
import io.automatiko.engine.api.jobs.ProcessJobDescription;
import io.automatiko.engine.api.runtime.process.ProcessRuntime;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.services.time.TimerInstance;
import io.automatiko.engine.services.uow.UnitOfWorkExecutor;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryJobService
implements JobsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryJobService.class);
    private static final String TRIGGER = "timer";
    protected final ScheduledThreadPoolExecutor scheduler;
    protected final ProcessRuntime processRuntime;
    protected final UnitOfWorkManager unitOfWorkManager;
    protected ConcurrentHashMap<String, ScheduledFuture<?>> scheduledJobs = new ConcurrentHashMap();

    public InMemoryJobService(ProcessRuntime processRuntime, UnitOfWorkManager unitOfWorkManager) {
        this(1, processRuntime, unitOfWorkManager);
    }

    public InMemoryJobService(int threadPoolSize, ProcessRuntime processRuntime, UnitOfWorkManager unitOfWorkManager) {
        this.scheduler = new ScheduledThreadPoolExecutor(threadPoolSize);
        this.processRuntime = processRuntime;
        this.unitOfWorkManager = unitOfWorkManager;
    }

    public String scheduleProcessJob(ProcessJobDescription description) {
        LOGGER.debug("ScheduleProcessJob: {}", (Object)description);
        ScheduledFuture<?> future = null;
        future = description.expirationTime().repeatInterval() != null ? this.scheduler.scheduleAtFixedRate(this.repeatableProcessJobByDescription(description), this.calculateDelay((JobDescription)description), description.expirationTime().repeatInterval(), TimeUnit.MILLISECONDS) : this.scheduler.schedule(this.processJobByDescription(description), this.calculateDelay((JobDescription)description), TimeUnit.MILLISECONDS);
        this.scheduledJobs.put(description.id(), future);
        return description.id();
    }

    public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
        ScheduledFuture<?> future = null;
        future = description.expirationTime().repeatInterval() != null ? this.scheduler.scheduleAtFixedRate(new SignalProcessInstanceOnExpiredTimer(description.id(), description.triggerType(), description.processInstanceId(), false, description.expirationTime().repeatLimit(), description), this.calculateDelay((JobDescription)description), description.expirationTime().repeatInterval(), TimeUnit.MILLISECONDS) : this.scheduler.schedule(new SignalProcessInstanceOnExpiredTimer(description.id(), description.triggerType(), description.processInstanceId(), true, description.expirationTime().repeatLimit(), description), this.calculateDelay((JobDescription)description), TimeUnit.MILLISECONDS);
        this.scheduledJobs.put(description.id(), future);
        return description.id();
    }

    public boolean cancelJob(String id) {
        if (this.scheduledJobs.containsKey(id)) {
            LOGGER.debug("Cancel Job: {}", (Object)id);
            return this.scheduledJobs.remove(id).cancel(false);
        }
        return false;
    }

    public ZonedDateTime getScheduledTime(String id) {
        ScheduledFuture<?> scheduled;
        long remainingTime;
        if (this.scheduledJobs.containsKey(id) && (remainingTime = (scheduled = this.scheduledJobs.get(id)).getDelay(TimeUnit.MILLISECONDS)) > 0L) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis() + remainingTime), ZoneId.systemDefault());
        }
        return null;
    }

    protected long calculateDelay(JobDescription description) {
        return this.log(description.expirationTime().get(), Duration.between(ZonedDateTime.now(), description.expirationTime().get()).toMillis());
    }

    protected Runnable processJobByDescription(ProcessJobDescription description) {
        if (description.process() != null) {
            return new StartProcessOnExpiredTimer(description.id(), description.process(), true, -1, description);
        }
        return new LegacyStartProcessOnExpiredTimer(description.id(), description.processId(), true, -1, description);
    }

    protected Runnable repeatableProcessJobByDescription(ProcessJobDescription description) {
        if (description.process() != null) {
            return new StartProcessOnExpiredTimer(description.id(), description.process(), false, description.expirationTime().repeatLimit(), description);
        }
        return new LegacyStartProcessOnExpiredTimer(description.id(), description.processId(), false, description.expirationTime().repeatLimit(), description);
    }

    protected long log(ZonedDateTime dt, long delay) {
        LOGGER.debug("Timer scheduled for date {} will expire in {}", (Object)dt, (Object)delay);
        return delay;
    }

    private class SignalProcessInstanceOnExpiredTimer
    implements Runnable {
        private final String id;
        private boolean removeAtExecution;
        private String processInstanceId;
        private String trigger;
        private Integer limit;
        private ProcessInstanceJobDescription description;

        private SignalProcessInstanceOnExpiredTimer(String id, String trigger, String processInstanceId, boolean removeAtExecution, Integer limit, ProcessInstanceJobDescription description) {
            this.id = id;
            this.processInstanceId = processInstanceId;
            this.trigger = trigger;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
            this.description = description;
        }

        @Override
        public void run() {
            try {
                LOGGER.debug("Job {} started", (Object)this.id);
                IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<timer>"));
                UnitOfWorkExecutor.executeInUnitOfWork(InMemoryJobService.this.unitOfWorkManager, () -> {
                    io.automatiko.engine.api.runtime.process.ProcessInstance pi = InMemoryJobService.this.processRuntime.getProcessInstance(this.processInstanceId);
                    if (pi != null) {
                        String[] ids = this.id.split("_");
                        Integer n = this.limit;
                        this.limit = this.limit - 1;
                        pi.signalEvent(this.trigger, (Object)TimerInstance.with(Long.valueOf(ids[1]), this.id, this.limit));
                        if (this.limit == 0) {
                            Optional.ofNullable(InMemoryJobService.this.scheduledJobs.remove(this.id)).ifPresent(s -> s.cancel(false));
                        }
                    } else {
                        InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                    }
                    return null;
                });
                LOGGER.debug("Job {} completed", (Object)this.id);
            }
            finally {
                ZonedDateTime next = this.description.expirationTime().next();
                if (next != null) {
                    InMemoryJobService.this.scheduleProcessInstanceJob(this.description);
                } else if (this.removeAtExecution) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id);
                }
            }
        }
    }

    private class StartProcessOnExpiredTimer
    implements Runnable {
        private final String id;
        private boolean removeAtExecution;
        private Process process;
        private Integer limit;
        private ProcessJobDescription description;

        private StartProcessOnExpiredTimer(String id, Process<?> process, boolean removeAtExecution, Integer limit, ProcessJobDescription description) {
            this.id = id;
            this.process = process;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
            this.description = description;
        }

        @Override
        public void run() {
            try {
                LOGGER.debug("Job {} started", (Object)this.id);
                IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<timer>"));
                UnitOfWorkExecutor.executeInUnitOfWork(InMemoryJobService.this.unitOfWorkManager, () -> {
                    ProcessInstance pi = this.process.createInstance(this.process.createModel());
                    if (pi != null) {
                        pi.start(InMemoryJobService.TRIGGER, null, null);
                    }
                    return null;
                });
                Integer n = this.limit;
                this.limit = this.limit - 1;
                if (this.limit == 0) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                }
                LOGGER.debug("Job {} completed", (Object)this.id);
            }
            finally {
                ZonedDateTime next = this.description.expirationTime().next();
                if (next != null) {
                    InMemoryJobService.this.scheduleProcessJob(this.description);
                } else if (this.removeAtExecution) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id);
                }
            }
        }
    }

    private class LegacyStartProcessOnExpiredTimer
    implements Runnable {
        private final String id;
        private boolean removeAtExecution;
        private String processId;
        private Integer limit;
        private ProcessJobDescription description;

        private LegacyStartProcessOnExpiredTimer(String id, String processId, boolean removeAtExecution, Integer limit, ProcessJobDescription description) {
            this.id = id;
            this.processId = processId;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
            this.description = description;
        }

        @Override
        public void run() {
            try {
                LOGGER.debug("Job {} started", (Object)this.id);
                IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<timer>"));
                UnitOfWorkExecutor.executeInUnitOfWork(InMemoryJobService.this.unitOfWorkManager, () -> {
                    io.automatiko.engine.api.runtime.process.ProcessInstance pi = InMemoryJobService.this.processRuntime.createProcessInstance(this.processId, null);
                    if (pi != null) {
                        InMemoryJobService.this.processRuntime.startProcessInstance(pi.getId(), InMemoryJobService.TRIGGER, null);
                    }
                    return null;
                });
                Integer n = this.limit;
                this.limit = this.limit - 1;
                if (this.limit == 0) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                }
                LOGGER.debug("Job {} completed", (Object)this.id);
            }
            finally {
                ZonedDateTime next = this.description.expirationTime().next();
                if (next != null) {
                    InMemoryJobService.this.scheduleProcessJob(this.description);
                } else if (this.removeAtExecution) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id);
                }
            }
        }
    }
}

