/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.signal;

import io.automatiko.engine.api.runtime.process.ProcessInstance;
import io.automatiko.engine.api.workflow.signal.SignalManager;
import io.automatiko.engine.api.workflow.signal.SignalManagerHub;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class DefaultSignalManagerHub
implements SignalManagerHub {
    private ConcurrentHashMap<String, Set<SignalManager>> signalManagers = new ConcurrentHashMap();

    public void publish(String type, Object signalData) {
        Set list = this.signalManagers.getOrDefault(type, Collections.emptySet());
        for (SignalManager sm : list) {
            sm.signalEvent(type, signalData);
        }
        if (signalData instanceof ProcessInstance) {
            list = this.signalManagers.getOrDefault(((ProcessInstance)signalData).getProcessId() + this.version((ProcessInstance)signalData), Collections.emptySet());
            for (SignalManager sm : list) {
                sm.signalEvent(type, signalData);
            }
        }
    }

    public void publishTargeting(String id, String type, Object signalData) {
        this.signalManagers.getOrDefault(type, Collections.emptySet()).forEach(e -> e.signalEvent(id, type, signalData));
    }

    public void subscribe(String type, SignalManager signalManager) {
        this.signalManagers.compute(type, (k, v) -> {
            if (v == null) {
                v = new CopyOnWriteArraySet<SignalManager>();
            }
            v.add(signalManager);
            return v;
        });
    }

    public void unsubscribe(String type, SignalManager signalManager) {
        this.signalManagers.computeIfPresent(type, (k, v) -> {
            v.remove(signalManager);
            if (v.isEmpty()) {
                this.signalManagers.remove(type);
            }
            return v;
        });
    }

    protected String version(ProcessInstance pi) {
        String version = pi.getProcess().getVersion();
        if (version != null && !version.trim().isEmpty()) {
            return "_" + version.replaceAll("\\.", "_");
        }
        return "";
    }
}

