/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.signal;

import io.automatiko.engine.api.runtime.process.EventListener;
import io.automatiko.engine.api.runtime.process.ProcessInstance;
import io.automatiko.engine.api.workflow.signal.SignalManager;
import io.automatiko.engine.api.workflow.signal.SignalManagerHub;
import io.automatiko.engine.services.signal.EventListenerResolver;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class LightSignalManager
implements SignalManager {
    private EventListenerResolver instanceResolver;
    private SignalManagerHub signalManagerHub;
    private ConcurrentHashMap<String, Set<EventListener>> listeners = new ConcurrentHashMap();

    public LightSignalManager(EventListenerResolver instanceResolver, SignalManagerHub signalManagerHub) {
        this.instanceResolver = instanceResolver;
        this.signalManagerHub = signalManagerHub;
    }

    public void addEventListener(String type, EventListener eventListener) {
        this.listeners.compute(type, (k, v) -> {
            if (v == null) {
                v = new CopyOnWriteArraySet<EventListener>();
            }
            v.add(eventListener);
            return v;
        });
        this.signalManagerHub.subscribe(type, (SignalManager)this);
    }

    public void removeEventListener(String type, EventListener eventListener) {
        this.listeners.computeIfPresent(type, (k, v) -> {
            v.remove(eventListener);
            if (v.isEmpty()) {
                this.listeners.remove(type);
            }
            return v;
        });
        this.signalManagerHub.unsubscribe(type, (SignalManager)this);
    }

    public void signalEvent(String type, Object event) {
        if (!this.listeners.containsKey(type)) {
            if (event instanceof ProcessInstance && this.listeners.containsKey(((ProcessInstance)event).getProcessId() + this.version((ProcessInstance)event))) {
                this.listeners.getOrDefault(((ProcessInstance)event).getProcessId() + this.version((ProcessInstance)event), Collections.emptySet()).forEach(e -> e.signalEvent(type, event));
                return;
            }
            this.signalManagerHub.publish(type, event);
        }
        this.listeners.getOrDefault(type, Collections.emptySet()).forEach(e -> e.signalEvent(type, event));
    }

    public void signalEvent(String processInstanceId, String type, Object event) {
        this.instanceResolver.find(processInstanceId).ifPresent(signalable -> signalable.signalEvent(type, event));
    }

    public boolean accept(String type, Object event) {
        if (this.listeners.containsKey(type)) {
            return true;
        }
        return event instanceof ProcessInstance && this.listeners.containsKey(((ProcessInstance)event).getProcessId() + this.version((ProcessInstance)event));
    }

    protected Map<String, Set<EventListener>> getListeners() {
        return this.listeners;
    }

    protected String version(ProcessInstance pi) {
        String version = pi.getProcess().getVersion();
        if (version != null && !version.trim().isEmpty()) {
            return "_" + version.replaceAll("\\.", "_");
        }
        return "";
    }

    public void setInstanceResolver(EventListenerResolver instanceResolver) {
        this.instanceResolver = instanceResolver;
    }
}

