/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.uow;

import io.automatiko.engine.api.event.EventBatch;
import io.automatiko.engine.api.event.EventManager;
import io.automatiko.engine.api.uow.TransactionLog;
import io.automatiko.engine.api.uow.UnitOfWork;
import io.automatiko.engine.api.uow.WorkUnit;
import io.automatiko.engine.api.workflow.ConflictingVersionException;
import io.automatiko.engine.api.workflow.ExportedProcessInstance;
import io.automatiko.engine.api.workflow.MutableProcessInstances;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstanceReadMode;
import io.automatiko.engine.api.workflow.ProcessInstances;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectingUnitOfWork
implements UnitOfWork {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CollectingUnitOfWork.class);
    private final String identifier;
    private Set<WorkUnit<?>> collectedWork;
    private boolean done;
    private final EventManager eventManager;
    private Map<String, ProcessInstances<?>> instances = new HashMap();

    public CollectingUnitOfWork(EventManager eventManager) {
        this.eventManager = eventManager;
        this.identifier = UUID.randomUUID().toString();
    }

    public String identifier() {
        return this.identifier;
    }

    public void start() {
        this.checkDone();
        if (this.collectedWork == null) {
            this.collectedWork = new LinkedHashSet();
        }
    }

    public void end() {
        this.checkStarted();
        Collection<WorkUnit<?>> units = this.sorted();
        EventBatch batch = this.eventManager.newBatch();
        batch.append(units);
        for (WorkUnit<?> work : units) {
            LOGGER.debug("Performing work unit {}", work);
            try {
                work.perform();
            }
            catch (ConflictingVersionException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Error during performing work unit {} error message {}", new Object[]{work, e.getMessage(), e});
            }
        }
        this.eventManager.publish(batch);
        this.done();
    }

    public void abort() {
        this.checkStarted();
        for (WorkUnit<?> work : this.sorted()) {
            LOGGER.debug("Aborting work unit {}", work);
            try {
                work.abort();
            }
            catch (Exception e) {
                LOGGER.error("Error during aborting work unit {} error message {}", new Object[]{work, e.getMessage(), e});
            }
        }
        this.done();
    }

    public void intercept(WorkUnit work) {
        this.checkStarted();
        if (work == null) {
            throw new NullPointerException("Work must be non null");
        }
        this.collectedWork.remove(work);
        this.collectedWork.add(work);
    }

    public ProcessInstances<?> managedProcessInstances(Process<?> process, ProcessInstances<?> instances) {
        return this.instances.computeIfAbsent(process.id(), pid -> new ManagedProcessInstances((MutableProcessInstances)instances));
    }

    protected Collection<WorkUnit<?>> sorted() {
        ArrayList sortedCollectedWork = new ArrayList(this.collectedWork);
        sortedCollectedWork.sort((u1, u2) -> u1.priority().compareTo(u2.priority()));
        return sortedCollectedWork;
    }

    protected void checkDone() {
        if (this.done) {
            throw new IllegalStateException("Unit of work is already done (ended or aborted)");
        }
    }

    protected void checkStarted() {
        if (this.collectedWork == null) {
            throw new IllegalStateException("Unit of work is not started");
        }
    }

    protected void done() {
        this.done = true;
        this.collectedWork = null;
        this.instances.clear();
    }

    private class ManagedProcessInstances
    implements MutableProcessInstances {
        private MutableProcessInstances<?> delegate;
        private Map<String, ProcessInstance<?>> local = new HashMap();

        public ManagedProcessInstances(MutableProcessInstances<?> delegate) {
            this.delegate = delegate;
        }

        public TransactionLog transactionLog() {
            return this.delegate.transactionLog();
        }

        public Optional<?> findById(String id, int status, ProcessInstanceReadMode mode) {
            ProcessInstance<?> pi;
            boolean isConnected;
            boolean isConnected2;
            if (this.local.containsKey(id) && (isConnected2 = this.local.get(id).isConnected())) {
                return Optional.of(this.local.get(id));
            }
            if (id.contains(":") && this.local.containsKey(id.split(":")[1]) && (isConnected = (pi = this.local.get(id.split(":")[1])).isConnected())) {
                if (pi.status() == status) {
                    return Optional.of(pi);
                }
                return Optional.empty();
            }
            Optional found = this.delegate.findById(id, status, mode);
            if (found.isPresent()) {
                ProcessInstance pi2 = (ProcessInstance)found.get();
                this.addToCache(id, pi2);
                this.addToCache(pi2.id(), pi2);
            }
            return found;
        }

        public Collection values(ProcessInstanceReadMode mode, int status, int page, int size) {
            return this.delegate.values(mode, status, page, size);
        }

        public Long size() {
            return this.delegate.size();
        }

        public boolean exists(String id) {
            return this.local.containsKey(id) || this.delegate.exists(id);
        }

        public void create(String id, ProcessInstance instance) {
            this.delegate.create(id, instance);
            this.local.put(id, instance);
        }

        public void update(String id, ProcessInstance instance) {
            this.delegate.update(id, instance);
            this.local.put(id, instance);
        }

        public void remove(String id, ProcessInstance instance) {
            this.delegate.remove(id, instance);
            this.local.remove(id);
        }

        public Collection findByIdOrTag(ProcessInstanceReadMode mode, int status, String ... values) {
            Collection collected = this.delegate.findByIdOrTag(mode, status, values);
            if (mode.equals((Object)ProcessInstanceReadMode.MUTABLE)) {
                collected.forEach(pi -> this.addToCache(((ProcessInstance)pi).id(), (ProcessInstance)pi));
            }
            return collected;
        }

        public void release(String id, ProcessInstance pi) {
            this.delegate.release(id, pi);
            this.local.remove(id);
        }

        protected void addToCache(String id, final ProcessInstance<?> pi) {
            this.local.put(id, pi);
            CollectingUnitOfWork.this.intercept(new WorkUnit<ProcessInstance<?>>(){

                public ProcessInstance<?> data() {
                    return pi;
                }

                public void perform() {
                    pi.disconnect();
                }

                public void abort() {
                    pi.disconnect();
                }

                public Integer priority() {
                    return 200;
                }
            });
        }

        public ExportedProcessInstance exportInstance(ProcessInstance instance, boolean abort) {
            return this.delegate.exportInstance(instance, abort);
        }

        public ProcessInstance importInstance(ExportedProcessInstance instance, Process process) {
            return this.delegate.importInstance(instance, process);
        }

        public Collection locateByIdOrTag(int status, String ... values) {
            return this.delegate.locateByIdOrTag(status, values);
        }

        public Collection values(ProcessInstanceReadMode mode, int status, int page, int size, String sortBy, boolean sortAsc) {
            return this.delegate.values(mode, status, page, size, sortBy, sortAsc);
        }

        public Collection findByIdOrTag(ProcessInstanceReadMode mode, int status, String sortBy, boolean sortAsc, String ... values) {
            return this.delegate.findByIdOrTag(mode, status, sortBy, sortAsc, values);
        }
    }
}

