/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.uow;

import io.automatiko.engine.api.event.EventManager;
import io.automatiko.engine.api.uow.UnitOfWork;
import io.automatiko.engine.api.uow.UnitOfWorkFactory;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.services.event.impl.BaseEventManager;
import io.automatiko.engine.services.uow.ManagedUnitOfWork;
import io.automatiko.engine.services.uow.PassThroughUnitOfWork;

public class DefaultUnitOfWorkManager
implements UnitOfWorkManager {
    private static ThreadLocal<UnitOfWork> currentUnitOfWork = new ThreadLocal();
    protected UnitOfWork fallbackUnitOfWork = new PassThroughUnitOfWork();
    protected UnitOfWorkFactory factory;
    protected EventManager eventManager = new BaseEventManager();

    public DefaultUnitOfWorkManager(UnitOfWorkFactory factory) {
        this.factory = factory;
    }

    public DefaultUnitOfWorkManager(UnitOfWork fallbackUnitOfWork, UnitOfWorkFactory factory) {
        this.fallbackUnitOfWork = fallbackUnitOfWork;
        this.factory = factory;
    }

    public UnitOfWork currentUnitOfWork() {
        UnitOfWork unit = currentUnitOfWork.get();
        if (unit == null) {
            return this.fallbackUnitOfWork;
        }
        return unit;
    }

    public UnitOfWork newUnitOfWork() {
        return new ManagedUnitOfWork(this.factory.create(this.eventManager), this::associate, this::dissociate, this::dissociate);
    }

    protected void associate(UnitOfWork unit) {
        currentUnitOfWork.set(unit);
    }

    protected void dissociate(UnitOfWork unit) {
        currentUnitOfWork.set(null);
    }

    public EventManager eventManager() {
        return this.eventManager;
    }

    public static UnitOfWork getUnitOfWork() {
        return currentUnitOfWork.get();
    }

    public static void setUnitOfWork(UnitOfWork unitOfWork) {
        currentUnitOfWork.set(unitOfWork);
    }
}

