/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.uow;

import io.automatiko.engine.api.uow.UnitOfWork;
import io.automatiko.engine.api.uow.WorkUnit;
import java.util.function.Consumer;

public class ManagedUnitOfWork
implements UnitOfWork {
    private UnitOfWork delegate;
    private Consumer<UnitOfWork> onStart;
    private Consumer<UnitOfWork> onEnd;
    private Consumer<UnitOfWork> onAbort;

    public ManagedUnitOfWork(UnitOfWork delegate, Consumer<UnitOfWork> onStart, Consumer<UnitOfWork> onEnd, Consumer<UnitOfWork> onAbort) {
        this.delegate = delegate;
        this.onStart = onStart;
        this.onEnd = onEnd;
        this.onAbort = onAbort;
    }

    public String identifier() {
        return this.delegate.identifier();
    }

    public void start() {
        this.onStart.accept(this.delegate);
        this.delegate.start();
    }

    public void end() {
        try {
            this.delegate.end();
        }
        finally {
            this.onEnd.accept(this.delegate);
        }
    }

    public void abort() {
        try {
            this.delegate.abort();
        }
        finally {
            this.onAbort.accept(this.delegate);
        }
    }

    public void intercept(WorkUnit work) {
        this.delegate.intercept(work);
    }

    public UnitOfWork delegate() {
        return this.delegate;
    }
}

