/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.uow;

import io.automatiko.engine.api.uow.WorkUnit;
import io.automatiko.engine.api.workflow.ProcessInstance;
import java.util.function.Consumer;

public class ProcessInstanceWorkUnit<T>
implements WorkUnit<ProcessInstance<T>> {
    private ProcessInstance<T> data;
    private Consumer<Object> action;
    private Consumer<Object> compensation;

    public ProcessInstanceWorkUnit(ProcessInstance<T> data, Consumer<Object> action) {
        this.data = data;
        this.action = action;
    }

    public ProcessInstanceWorkUnit(ProcessInstance<T> data, Consumer<Object> action, Consumer<Object> compensation) {
        this.data = data;
        this.action = action;
        this.compensation = compensation;
    }

    public ProcessInstance<T> data() {
        return this.data;
    }

    public void perform() {
        this.action.accept(this.data());
    }

    public void abort() {
        if (this.compensation != null) {
            this.compensation.accept(this.data());
        }
    }

    public Integer priority() {
        return 10;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceWorkUnit other = (ProcessInstanceWorkUnit)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }
}

