/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.uow;

import io.automatiko.engine.api.uow.TransactionLog;
import io.automatiko.engine.api.uow.WorkUnit;

public class TransactionLogWorkUnit
implements WorkUnit<TransactionLog> {
    private String transactionId;
    private TransactionLog transactionLog;

    public TransactionLogWorkUnit(String transactionId, TransactionLog transactionLog) {
        this.transactionId = transactionId;
        this.transactionLog = transactionLog;
    }

    public TransactionLog data() {
        return this.transactionLog;
    }

    public void perform() {
        this.cleanup();
    }

    public void abort() {
        this.cleanup();
    }

    public Integer priority() {
        return 9000;
    }

    protected void cleanup() {
        try {
            this.transactionLog.complete(this.transactionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.transactionId == null ? 0 : this.transactionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionLogWorkUnit other = (TransactionLogWorkUnit)obj;
        return !(this.transactionId == null ? other.transactionId != null : !this.transactionId.equals(other.transactionId));
    }
}

