/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.uow;

import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.uow.UnitOfWork;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.workflow.ConflictingVersionException;
import io.automatiko.engine.api.workflow.DefinedProcessErrorException;
import io.automatiko.engine.api.workflow.ProcessInstanceExecutionException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitOfWorkExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitOfWorkExecutor.class);

    public static <T> T executeInUnitOfWork(UnitOfWorkManager uowManager, Supplier<T> supplier) {
        T result = null;
        UnitOfWork uow = uowManager.newUnitOfWork();
        try {
            uow.start();
            result = supplier.get();
            uow.end();
            T t = result;
            return t;
        }
        catch (ProcessInstanceExecutionException e) {
            uow.end();
            throw e;
        }
        catch (DefinedProcessErrorException e) {
            uow.end();
            throw e;
        }
        catch (ConflictingVersionException e) {
            LOGGER.warn("A conflict was identified for current unit of work with message '{}', aborting current unit of work and retrying", (Object)e.getMessage());
            uow.abort();
            T t = UnitOfWorkExecutor.executeInUnitOfWork(uowManager, supplier);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            uow.abort();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            IdentityProvider.set(null);
        }
    }
}

