/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.services.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class IoUtils {
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;

    public static String readFileAsString(File file) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), UTF8_CHARSET));
        try {
            StringBuilder sb = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = reader.readLine();
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return string;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = IoUtils.createBytesBuffer(input);
        long count = 0L;
        int n = 0;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static List<String> recursiveListFile(File folder) {
        return IoUtils.recursiveListFile(folder, "", f -> true);
    }

    public static List<String> recursiveListFile(File folder, String prefix, Predicate<File> filter) {
        ArrayList<String> files = new ArrayList<String>();
        for (File child : IoUtils.safeListFiles(folder)) {
            IoUtils.filesInFolder(files, child, prefix, filter);
        }
        return files;
    }

    private static void filesInFolder(List<String> files, File file, String relativePath, Predicate<File> filter) {
        if (file.isDirectory()) {
            relativePath = (String)relativePath + file.getName() + "/";
            for (File child : IoUtils.safeListFiles(file)) {
                IoUtils.filesInFolder(files, child, (String)relativePath, filter);
            }
        } else if (filter.test(file)) {
            files.add((String)relativePath + file.getName());
        }
    }

    private static File[] safeListFiles(File file) {
        File[] children = file.listFiles();
        if (children != null) {
            return children;
        }
        throw new IllegalArgumentException(String.format("Unable to retrieve contents of directory '%s'.", file.getAbsolutePath()));
    }

    public static byte[] readBytesFromInputStream(InputStream input) throws IOException {
        return IoUtils.readBytesFromInputStream(input, true);
    }

    public static byte[] readBytesFromInputStream(InputStream input, boolean closeInput) throws IOException {
        try {
            byte[] byArray;
            byte[] buffer = IoUtils.createBytesBuffer(input);
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(buffer.length);){
                int n = 0;
                while (-1 != (n = input.read(buffer))) {
                    output.write(buffer, 0, n);
                }
                byArray = output.toByteArray();
            }
            return byArray;
        }
        finally {
            try {
                if (closeInput) {
                    input.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static byte[] createBytesBuffer(InputStream input) throws IOException {
        return new byte[Math.max(input.available(), 8192)];
    }

    public static byte[] readBytes(File f) throws IOException {
        byte[] buf = new byte[1024];
        try (BufferedInputStream bais = new BufferedInputStream(new FileInputStream(f));){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int len;
                while ((len = bais.read(buf)) > 0) {
                    baos.write(buf, 0, len);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static void write(File f, byte[] data) throws IOException {
        int count;
        if (f.exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to sleep");
            }
        }
        IoUtils.writeBytes(f, data);
        for (count = 0; !IoUtils.areByteArraysEqual(data, IoUtils.readBytes(f)) && count < 5; ++count) {
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("This should never happen");
            }
            IoUtils.writeBytes(f, data);
        }
        if (count == 5) {
            throw new IOException("Unable to write to file:" + f.getCanonicalPath());
        }
    }

    public static void writeBytes(File f, byte[] data) throws IOException {
        byte[] buf = new byte[1024];
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
             ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            int len;
            while ((len = bais.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
        }
    }

    public static boolean areByteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        int length = b1.length;
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static String asSystemSpecificPath(String urlPath, int colonIndex) {
        String ic = urlPath.substring(Math.max(0, colonIndex - 2), colonIndex + 1);
        if (ic.matches("\\/[a-zA-Z]:")) {
            return urlPath.substring(colonIndex - 2);
        }
        if (ic.matches("[a-zA-Z]:")) {
            return urlPath.substring(colonIndex - 1);
        }
        return urlPath.substring(colonIndex + 1);
    }

    public static String valueOf(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof InputStream) {
            try {
                return new String(IoUtils.readBytesFromInputStream((InputStream)data), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                return null;
            }
        }
        return data.toString();
    }

    private IoUtils() {
    }
}

