/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.deployment;

import io.automatiko.engine.codegen.ApplicationGenerator;
import io.automatiko.engine.codegen.GeneratedFile;
import io.automatiko.engine.codegen.Generator;
import io.automatiko.engine.codegen.di.CDIDependencyInjectionAnnotator;
import io.automatiko.engine.codegen.di.DependencyInjectionAnnotator;
import io.automatiko.engine.quarkus.deployment.AutomatikoBuildData;
import io.automatiko.engine.quarkus.deployment.AutomatikoCompilerException;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.CompilerFlags;
import io.quarkus.paths.PathCollection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

public abstract class AutomatikoCompilationProvider
implements CompilationProvider {
    private static final Logger log = Logger.getLogger(AutomatikoCompilationProvider.class);
    private static final Set<String> COMPILER_OPTIONS = new HashSet<String>(Arrays.asList("-g", "-parameters"));
    private static final Set<String> IGNORE_NAMESPACES = new HashSet<String>(Collections.singletonList("org.osgi"));
    JavaCompiler compiler;
    StandardJavaFileManager fileManager;
    DiagnosticCollector<JavaFileObject> fileManagerDiagnostics;

    public Set<String> handledSourcePaths() {
        return Collections.singleton("src" + File.separator + "main" + File.separator + "resources");
    }

    protected Set<File> filterFilesToCompile(Set<File> filesToCompile) {
        return filesToCompile;
    }

    public final void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        Set allFiles = AutomatikoBuildData.get().getGenerationContext().collectConnectedFiles(this.filterFilesToCompile(filesToCompile));
        if (allFiles.isEmpty()) {
            return;
        }
        File outputDirectory = AutomatikoBuildData.get().getGenerationContext().getClassesPath();
        try {
            ApplicationGenerator appGen = new ApplicationGenerator(AutomatikoBuildData.get().getConfig().packageName().orElse("io.automatiko.app"), outputDirectory).withDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator()).withGeneratorContext(AutomatikoBuildData.get().getGenerationContext());
            this.addGenerator(appGen, allFiles, context);
            Collection generatedFiles = appGen.generate();
            HashSet<File> generatedSourceFiles = new HashSet<File>();
            for (GeneratedFile file : generatedFiles) {
                Path path = AutomatikoCompilationProvider.pathOf(outputDirectory.getPath(), file.relativePath());
                if (file.getType() == GeneratedFile.Type.APPLICATION || file.getType() == GeneratedFile.Type.APPLICATION_CONFIG) continue;
                Files.write(path, file.contents(), new OpenOption[0]);
                generatedSourceFiles.add(path.toFile());
            }
            this.javaCompile(generatedSourceFiles, context, outputDirectory);
        }
        catch (IOException e) {
            throw new AutomatikoCompilerException(e);
        }
    }

    public Path getSourcePath(Path classFilePath, PathCollection sourcePaths, String classesPath) {
        try {
            return AutomatikoBuildData.get().getGenerationContext().getClassSource(classFilePath);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    protected abstract Generator addGenerator(ApplicationGenerator var1, Set<File> var2, CompilationProvider.Context var3) throws IOException;

    static Path pathOf(String path, String relativePath) {
        Path p = Paths.get(path, relativePath);
        p.getParent().toFile().mkdirs();
        return p;
    }

    private void javaCompile(Set<File> filesToCompile, CompilationProvider.Context context, File outputDirectory) {
        JavaCompiler compiler = this.compiler;
        if (compiler == null) {
            compiler = this.compiler = ToolProvider.getSystemJavaCompiler();
        }
        if (compiler == null) {
            throw new RuntimeException("No system java compiler provided");
        }
        try {
            if (this.fileManager == null) {
                this.fileManagerDiagnostics = new DiagnosticCollector();
                this.fileManager = compiler.getStandardFileManager(this.fileManagerDiagnostics, null, context.getSourceEncoding());
            }
            DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
            this.fileManager.setLocation(StandardLocation.CLASS_PATH, context.getClasspath());
            this.fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(outputDirectory));
            CompilerFlags compilerFlags = new CompilerFlags(COMPILER_OPTIONS, (Collection)context.getCompilerOptions(), context.getReleaseJavaVersion(), context.getSourceJavaVersion(), context.getTargetJvmVersion());
            Iterable<? extends JavaFileObject> sources = this.fileManager.getJavaFileObjectsFromFiles(filesToCompile);
            JavaCompiler.CompilationTask task = compiler.getTask(null, this.fileManager, diagnostics, compilerFlags.toList(), null, sources);
            if (!task.call().booleanValue()) {
                StringBuilder sb = new StringBuilder("\u001b[91mCompilation Failed:");
                for (Diagnostic<JavaFileObject> i : diagnostics.getDiagnostics()) {
                    sb.append("\n");
                    sb.append(i.toString());
                }
                sb.append("\u001b[0m");
                throw new RuntimeException(sb.toString());
            }
            this.logDiagnostics(diagnostics);
            if (!this.fileManagerDiagnostics.getDiagnostics().isEmpty()) {
                this.logDiagnostics(this.fileManagerDiagnostics);
                this.fileManager.close();
                this.fileManagerDiagnostics = null;
                this.fileManager = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot close file manager", e);
        }
    }

    public void close() throws IOException {
        if (this.fileManager != null) {
            this.fileManager.close();
            this.fileManager = null;
            this.fileManagerDiagnostics = null;
        }
    }

    private void logDiagnostics(DiagnosticCollector<JavaFileObject> diagnostics) {
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            Logger.Level level = diagnostic.getKind() == Diagnostic.Kind.ERROR ? Logger.Level.ERROR : Logger.Level.WARN;
            String message = diagnostic.getMessage(null);
            if (level.equals((Object)Logger.Level.WARN) && AutomatikoCompilationProvider.ignoreWarningForNamespace(message)) continue;
            log.logf(level, "%s, line %d in %s", (Object)message, (Object)diagnostic.getLineNumber(), (Object)(diagnostic.getSource() == null ? "[unknown source]" : diagnostic.getSource().getName()));
        }
    }

    private static boolean ignoreWarningForNamespace(String message) {
        for (String ignoreNamespace : IGNORE_NAMESPACES) {
            if (!message.contains(ignoreNamespace)) continue;
            return true;
        }
        return false;
    }

    static class RuntimeUpdatesClassVisitor
    extends ClassVisitor {
        private final PathsCollection sourcePaths;
        private final String classesPath;
        private String sourceFile;

        public RuntimeUpdatesClassVisitor(PathsCollection sourcePaths, String classesPath) {
            super(589824);
            this.sourcePaths = sourcePaths;
            this.classesPath = classesPath;
        }

        public void visitSource(String source, String debug) {
            this.sourceFile = source;
        }

        public Path getSourceFileForClass(Path classFilePath) {
            for (Path sourcesDir : this.sourcePaths) {
                Path classesDir = Paths.get(this.classesPath, new String[0]);
                StringBuilder sourceRelativeDir = new StringBuilder();
                sourceRelativeDir.append(classesDir.relativize(classFilePath.getParent()));
                sourceRelativeDir.append(File.separator);
                sourceRelativeDir.append(this.sourceFile);
                Path sourceFilePath = sourcesDir.resolve(Paths.get(sourceRelativeDir.toString(), new String[0]));
                if (!Files.exists(sourceFilePath, new LinkOption[0])) continue;
                return sourceFilePath;
            }
            return null;
        }
    }
}

