/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.app;

import io.automatiko.app.DecisionModels;
import io.automatiko.app.Processes;
import io.automatiko.engine.api.Config;
import io.automatiko.engine.api.event.EventPublisher;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class Application
implements io.automatiko.engine.api.Application {
    @Inject
    Instance<EventPublisher> eventPublishers;
    @ConfigProperty(name="automatiko.service.url")
    Optional<String> service;
    @Inject
    Config config;
    Processes processes = new Processes(this);
    DecisionModels decisionModels = new DecisionModels();

    public Config config() {
        return this.config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.config().process().unitOfWorkManager();
    }

    @PostConstruct
    public void setup() {
        if (this.config().process() != null) {
            if (this.eventPublishers != null) {
                this.eventPublishers.forEach(eventPublisher -> this.unitOfWorkManager().eventManager().addPublisher(eventPublisher));
            }
            this.unitOfWorkManager().eventManager().setService(this.service.orElse(""));
            this.unitOfWorkManager().eventManager().setAddons(this.config().addons());
        }
        if (this.config().decision() != null) {
            this.decisionModels.init(this);
        }
    }

    public Processes processes() {
        return this.processes;
    }

    public DecisionModels decisionModels() {
        return this.decisionModels;
    }
}

