/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.app;

import io.automatiko.engine.api.Addons;
import io.automatiko.engine.api.Config;
import io.automatiko.engine.api.decision.DecisionConfig;
import io.automatiko.engine.api.decision.DecisionEventListenerConfig;
import io.automatiko.engine.api.event.process.ProcessEventListener;
import io.automatiko.engine.api.jobs.JobsService;
import io.automatiko.engine.api.uow.UnitOfWorkFactory;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.workflow.ProcessConfig;
import io.automatiko.engine.api.workflow.ProcessEventListenerConfig;
import io.automatiko.engine.api.workflow.VariableInitializer;
import io.automatiko.engine.api.workflow.WorkItemHandlerConfig;
import io.automatiko.engine.decision.dmn.config.CachedDecisionEventListenerConfig;
import io.automatiko.engine.decision.dmn.config.StaticDecisionConfig;
import io.automatiko.engine.services.uow.CollectingUnitOfWorkFactory;
import io.automatiko.engine.services.uow.DefaultUnitOfWorkManager;
import io.automatiko.engine.workflow.CachedProcessEventListenerConfig;
import io.automatiko.engine.workflow.DefaultWorkItemHandlerConfig;
import io.automatiko.engine.workflow.StaticProcessConfig;
import io.automatiko.engine.workflow.base.instance.context.variable.DefaultVariableInitializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;

@Singleton
public class ApplicationConfig
implements Config {
    protected ProcessConfig processConfig;
    protected DecisionConfig decisionConfig;
    private WorkItemHandlerConfig defaultWorkItemHandlerConfig = new DefaultWorkItemHandlerConfig();
    private UnitOfWorkManager defaultUnitOfWorkManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
    private JobsService defaultJobsService = null;
    private VariableInitializer defaultVariableInitializer = new DefaultVariableInitializer();
    @Inject
    Instance<WorkItemHandlerConfig> workItemHandlerConfig;
    @Inject
    Instance<UnitOfWorkManager> unitOfWorkManager;
    @Inject
    Instance<JobsService> jobsService;
    @Inject
    Instance<VariableInitializer> variableInitializer;
    @Inject
    Instance<ProcessEventListenerConfig> processEventListenerConfigs;
    @Inject
    Instance<ProcessEventListener> processEventListeners;
    @Inject
    Instance<DecisionEventListenerConfig> decisionEventListenerConfigs;
    @Inject
    Instance<DMNRuntimeEventListener> dmnRuntimeEventListeners;

    public ProcessConfig process() {
        return this.processConfig;
    }

    public DecisionConfig decision() {
        return this.decisionConfig;
    }

    private static <C, L> List<L> merge(Collection<C> collection, Function<C, Collection<L>> function, Collection<L> collection2) {
        return Stream.concat(collection.stream().flatMap(object -> ((Collection)function.apply(object)).stream()), collection2.stream()).collect(Collectors.toList());
    }

    protected WorkItemHandlerConfig extract_workItemHandlerConfig() {
        if (!this.workItemHandlerConfig.isUnsatisfied()) {
            return (WorkItemHandlerConfig)this.workItemHandlerConfig.get();
        }
        return this.defaultWorkItemHandlerConfig;
    }

    protected UnitOfWorkManager extract_unitOfWorkManager() {
        if (!this.unitOfWorkManager.isUnsatisfied()) {
            return (UnitOfWorkManager)this.unitOfWorkManager.get();
        }
        return this.defaultUnitOfWorkManager;
    }

    protected JobsService extract_jobsService() {
        if (!this.jobsService.isUnsatisfied()) {
            return (JobsService)this.jobsService.get();
        }
        return this.defaultJobsService;
    }

    protected VariableInitializer extract_variableInitializer() {
        if (!this.variableInitializer.isUnsatisfied()) {
            return (VariableInitializer)this.variableInitializer.get();
        }
        return this.defaultVariableInitializer;
    }

    private ProcessEventListenerConfig extract_processEventListenerConfig() {
        return this.merge_processEventListenerConfig(StreamSupport.stream(this.processEventListenerConfigs.spliterator(), false).collect(Collectors.toList()), StreamSupport.stream(this.processEventListeners.spliterator(), false).collect(Collectors.toList()));
    }

    private ProcessEventListenerConfig merge_processEventListenerConfig(Collection<ProcessEventListenerConfig> collection, Collection<ProcessEventListener> collection2) {
        return new CachedProcessEventListenerConfig(ApplicationConfig.merge(collection, ProcessEventListenerConfig::listeners, collection2));
    }

    private DecisionEventListenerConfig extract_decisionEventListenerConfig() {
        return this.merge_decisionEventListenerConfig(StreamSupport.stream(this.decisionEventListenerConfigs.spliterator(), false).collect(Collectors.toList()), StreamSupport.stream(this.dmnRuntimeEventListeners.spliterator(), false).collect(Collectors.toList()));
    }

    private DecisionEventListenerConfig merge_decisionEventListenerConfig(Collection<DecisionEventListenerConfig> collection, Collection<DMNRuntimeEventListener> collection2) {
        return new CachedDecisionEventListenerConfig(ApplicationConfig.merge(collection, DecisionEventListenerConfig::listeners, collection2));
    }

    public Addons addons() {
        return new Addons(Arrays.asList(new String[0]));
    }

    @PostConstruct
    public void init() {
        this.processConfig = new StaticProcessConfig(this.extract_workItemHandlerConfig(), this.extract_processEventListenerConfig(), this.extract_unitOfWorkManager(), this.extract_jobsService(), this.extract_variableInitializer());
        this.decisionConfig = new StaticDecisionConfig(this.extract_decisionEventListenerConfig());
    }
}

