/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.ittests;

import io.automatiko.engine.api.Model;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstances;
import io.automatiko.engine.api.workflow.WorkItem;
import io.automatiko.engine.api.workflow.workitem.Policy;
import io.automatiko.engine.quarkus.ittests.Order;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/runProcess")
public class OrdersProcessService {
    @Inject
    @Named(value="orders_1_0")
    Process<? extends Model> orderProcess;
    @Inject
    @Named(value="orderItems")
    Process<? extends Model> orderItemsProcess;

    @GET
    @Produces(value={"text/plain"})
    public String testOrderProcess() {
        Model m = (Model)this.orderProcess.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("approver", "john");
        parameters.put("order", new Order("12345", false, 0.0));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.orderProcess.createInstance(m);
        processInstance.start();
        assert (1 == processInstance.status());
        Model result = (Model)processInstance.variables();
        assert (result.toMap().size() == 2);
        assert (((Order)result.toMap().get("order")).getTotal() > 0.0);
        ProcessInstances orderItemProcesses = this.orderItemsProcess.instances();
        assert (orderItemProcesses.values(1, 10).size() == 1);
        ProcessInstance childProcessInstance = (ProcessInstance)orderItemProcesses.values(1, 10).iterator().next();
        List workItems = childProcessInstance.workItems(new Policy[0]);
        assert (workItems.size() == 1);
        childProcessInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        assert (2 == childProcessInstance.status());
        assert (2 == processInstance.status());
        assert (this.orderProcess.instances().values(1, 10).size() == 0);
        assert (this.orderItemsProcess.instances().values(1, 10).size() == 0);
        return "OK";
    }
}

