/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.ittests;

import io.automatiko.engine.api.Application;
import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.IdentitySupplier;
import io.automatiko.engine.api.auth.SecurityPolicy;
import io.automatiko.engine.api.runtime.process.WorkItemNotFoundException;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessErrors;
import io.automatiko.engine.api.workflow.ProcessImageNotFoundException;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstanceExecutionException;
import io.automatiko.engine.api.workflow.ProcessInstanceNotFoundException;
import io.automatiko.engine.api.workflow.ProcessInstanceReadMode;
import io.automatiko.engine.api.workflow.Tag;
import io.automatiko.engine.api.workflow.WorkItem;
import io.automatiko.engine.api.workflow.workitem.Policy;
import io.automatiko.engine.api.workflow.workitem.Transition;
import io.automatiko.engine.quarkus.ittests.OrderItemsModel;
import io.automatiko.engine.quarkus.ittests.OrderItemsModelInput;
import io.automatiko.engine.quarkus.ittests.OrderItemsModelOutput;
import io.automatiko.engine.quarkus.ittests.OrderItems_4_TaskInput;
import io.automatiko.engine.quarkus.ittests.OrderItems_4_TaskOutput;
import io.automatiko.engine.quarkus.ittests.Orders_1_0Model;
import io.automatiko.engine.quarkus.ittests.Orders_1_0ModelInput;
import io.automatiko.engine.quarkus.ittests.Orders_1_0ModelOutput;
import io.automatiko.engine.services.uow.UnitOfWorkExecutor;
import io.automatiko.engine.workflow.base.instance.TagInstance;
import io.automatiko.engine.workflow.base.instance.impl.humantask.HumanTaskTransition;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;

@org.eclipse.microprofile.openapi.annotations.tags.Tag(name="orders", description="Deals with orders created by customer")
@Path(value="/v1_0/orders")
@ApplicationScoped
public class OrdersResource_1_0 {
    @Inject
    @Named(value="orders_1_0")
    Process<Orders_1_0Model> process;
    @Inject
    Application application;
    @Inject
    IdentitySupplier identitySupplier;
    @Inject
    @Named(value="orderItems")
    Process<OrderItemsModel> subprocess_orderItems;

    @APIResponses(value={@APIResponse(responseCode="400", description="In case request given does not meet expectations", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="409", description="In case an instance already exists with given business key", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="In case an instance cannot be created due to access policy by the caller", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully created instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=Orders_1_0ModelOutput.class))})})
    @Operation(summary="Creates new instance of orders")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Orders_1_0ModelOutput create_orders(@Context HttpHeaders httpHeaders, @QueryParam(value="businessKey") @Parameter(description="Alternative id to be assigned to the instance", required=false) String string, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string2, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list, @Parameter(description="The input model for orders instance") Orders_1_0ModelInput orders_1_0ModelInput) {
        if (orders_1_0ModelInput == null) {
            orders_1_0ModelInput = new Orders_1_0ModelInput();
        }
        Orders_1_0ModelInput orders_1_0ModelInput2 = orders_1_0ModelInput;
        this.identitySupplier.buildIdentityProvider(string2, list);
        return (Orders_1_0ModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance processInstance = this.process.createInstance(string, (Object)this.mapInput(orders_1_0ModelInput2, new Orders_1_0Model()));
            String string2 = httpHeaders.getHeaderString("X-AUTOMATIK-StartFromNode");
            if (string2 != null) {
                processInstance.startFrom(string2);
            } else {
                processInstance.start();
            }
            this.tracing(processInstance);
            return this.getModel((ProcessInstance<Orders_1_0Model>)processInstance);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved list of instances", content={@Content(mediaType="application/json", schema=@Schema(implementation=Orders_1_0ModelOutput.class, type=SchemaType.ARRAY))})})
    @Operation(summary="Retrieves instances of orders")
    @GET
    @Produces(value={"application/json"})
    public List<Orders_1_0ModelOutput> getAll_orders(@Parameter(description="Tags to filter when loading instances", required=false) @QueryParam(value="tags") List<String> list, @Parameter(description="Pagination - page to start on", required=false) @QueryParam(value="page") @DefaultValue(value="1") int n, @Parameter(description="Pagination - number of items to return", required=false) @QueryParam(value="size") @DefaultValue(value="10") int n2, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list2) {
        try {
            this.identitySupplier.buildIdentityProvider(string, list2);
            if (list != null && !list.isEmpty()) {
                List<Orders_1_0ModelOutput> list3 = this.process.instances().findByIdOrTag(ProcessInstanceReadMode.READ_ONLY, (String[])list.toArray(String[]::new)).stream().map(processInstance -> this.mapOutput(new Orders_1_0ModelOutput(), (Orders_1_0Model)processInstance.variables(), processInstance.businessKey())).collect(Collectors.toList());
                return list3;
            }
            List<Orders_1_0ModelOutput> list4 = this.process.instances().values(n, n2).stream().map(processInstance -> this.mapOutput(new Orders_1_0ModelOutput(), (Orders_1_0Model)processInstance.variables(), processInstance.businessKey())).collect(Collectors.toList());
            return list4;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="In case of instance with given id is not accessible to the caller", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=Orders_1_0ModelOutput.class))})})
    @Operation(summary="Retrieves orders instance with given id")
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Orders_1_0ModelOutput get_orders(@PathParam(value="id") @Parameter(description="Unique identifier of the instance", required=true) String string, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string2, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list) {
        try {
            this.identitySupplier.buildIdentityProvider(string2, list);
            Orders_1_0ModelOutput orders_1_0ModelOutput = this.process.instances().findById(string, ProcessInstanceReadMode.READ_ONLY).map(processInstance -> this.mapOutput(new Orders_1_0ModelOutput(), (Orders_1_0Model)processInstance.variables(), processInstance.businessKey())).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            return orders_1_0ModelOutput;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="In case of instance with given id is not accessible to the caller", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved instance's image", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))})})
    @Operation(hidden=true, summary="Retrieves orders instance's image for given id")
    @GET
    @Path(value="/{id}/image")
    @Produces(value={"application/svg+xml"})
    public Response get_instance_image_orders(@Context UriInfo uriInfo, @PathParam(value="id") @Parameter(description="Unique identifier of the instance", required=true) String string, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string2, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list) {
        try {
            this.identitySupplier.buildIdentityProvider(string2, list);
            ProcessInstance processInstance = (ProcessInstance)this.process.instances().findById(string, ProcessInstanceReadMode.READ_ONLY).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            String string3 = processInstance.image(this.extractImageBaseUri(uriInfo.getRequestUri().toString()));
            if (string3 == null) {
                throw new ProcessImageNotFoundException(this.process.id());
            }
            ImageStreamingOutput imageStreamingOutput = new ImageStreamingOutput(string3);
            Response.ResponseBuilder responseBuilder = Response.ok().entity((Object)imageStreamingOutput);
            Response response = responseBuilder.header("Content-Type", (Object)"image/svg+xml").build();
            return response;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    @APIResponses(value={@APIResponse(responseCode="404", description="In case of image does not exist for orders", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved instance's image", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))})})
    @Operation(hidden=true, summary="Retrieves image for orders")
    @GET
    @Path(value="/image")
    @Produces(value={"application/svg+xml"})
    public Response get_image_orders() {
        String string = this.process.image();
        if (string == null) {
            throw new ProcessImageNotFoundException(this.process.id());
        }
        ImageStreamingOutput imageStreamingOutput = new ImageStreamingOutput(string);
        Response.ResponseBuilder responseBuilder = Response.ok().entity((Object)imageStreamingOutput);
        return responseBuilder.header("Content-Type", (Object)"image/svg+xml").build();
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="In case of instance with given id is not accessible to the caller", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully deleted instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=Orders_1_0ModelOutput.class))})})
    @Operation(summary="Deletes orders instance with given id")
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Orders_1_0ModelOutput delete_orders(@PathParam(value="id") @Parameter(description="Unique identifier of the instance", required=true) String string, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string2, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list) {
        this.identitySupplier.buildIdentityProvider(string2, list);
        return (Orders_1_0ModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance processInstance = (ProcessInstance)this.process.instances().findById(string).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            this.tracing(processInstance);
            processInstance.abort();
            return this.getModel((ProcessInstance<Orders_1_0Model>)processInstance);
        });
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="In case of instance with given id is not accessible to the caller", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully updated instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=Orders_1_0ModelOutput.class))})})
    @Operation(summary="Updates data of orders instance with given id")
    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Orders_1_0ModelOutput updateModel_orders(@PathParam(value="id") @Parameter(description="Unique identifier of the instance", required=true) String string, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string2, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list, @Parameter(description="Updates to the data model for orders instance", required=true) Orders_1_0Model orders_1_0Model) {
        this.identitySupplier.buildIdentityProvider(string2, list);
        return (Orders_1_0ModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance processInstance = (ProcessInstance)this.process.instances().findById(string).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            this.tracing(processInstance);
            processInstance.updateVariables((Object)orders_1_0Model);
            return this.mapOutput(new Orders_1_0ModelOutput(), (Orders_1_0Model)processInstance.variables(), processInstance.businessKey());
        });
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="In case of instance with given id is not accessible to the caller", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved task of the instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkItem.Descriptor.class, type=SchemaType.ARRAY))})})
    @Operation(summary="Retrieves tasks currently active in orders instance with given id")
    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public List<WorkItem.Descriptor> getTasks_orders(@PathParam(value="id") @Parameter(description="Unique identifier of the instance", required=true) String string, @Parameter(description="User identifier that the tasks should be fetched for", required=false) @QueryParam(value="user") String string2, @Parameter(description="Groups that the tasks should be fetched for", required=false) @QueryParam(value="group") List<String> list) {
        this.identitySupplier.buildIdentityProvider(string2, list);
        return (List)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(string, ProcessInstanceReadMode.READ_ONLY).map(processInstance -> processInstance.workItems(this.policies(string3, list))).map(list -> list.stream().map(WorkItem::toMap).collect(Collectors.toList())).orElseThrow(() -> new ProcessInstanceNotFoundException(string2)));
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="In case of instance with given id is not accessible to the caller", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved tags of the instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=TagInstance.class, type=SchemaType.ARRAY))})})
    @Operation(summary="Retrieves tags associated with orders instance with given id")
    @GET
    @Path(value="/{id}/tags")
    @Produces(value={"application/json"})
    public Collection<? extends Tag> get_tags_orders(@PathParam(value="id") @Parameter(description="Unique identifier of the instance", required=true) String string, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string2, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list) {
        this.identitySupplier.buildIdentityProvider(string2, list);
        return (Collection)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(string, ProcessInstanceReadMode.READ_ONLY).map(processInstance -> processInstance.tags().get()).orElseThrow(() -> new ProcessInstanceNotFoundException(string2)));
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="In case of instance with given id is not accessible to the caller", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully added TagInstance to the instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=TagInstance.class, type=SchemaType.ARRAY))})})
    @Operation(summary="Adds new TagInstance to orders instance with given id")
    @POST
    @Path(value="/{id}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Collection<? extends Tag> add_tag_orders(@PathParam(value="id") @Parameter(description="Unique identifier of the instance", required=true) String string, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string2, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list, @Parameter(description="TagInstance content that should be associated with the orders instance", required=true) TagInstance tagInstance) {
        this.identitySupplier.buildIdentityProvider(string2, list);
        return (Collection)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance processInstance = (ProcessInstance)this.process.instances().findById(string).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            this.tracing(processInstance);
            processInstance.tags().add(tagInstance.getValue());
            return processInstance.tags().get();
        });
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="In case of instance with given id is not accessible to the caller", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully removed TagInstance from the instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=TagInstance.class, type=SchemaType.ARRAY))})})
    @Operation(summary="Removes TagInstance from orders instance with given id")
    @DELETE
    @Path(value="/{id}/tags/{tagId}")
    @Produces(value={"application/json"})
    public Collection<? extends Tag> get_tag_orders(@PathParam(value="id") @Parameter(description="Unique identifier of the instance", required=true) String string, @Parameter(description="TagInstance to be removed", required=true) @PathParam(value="tagId") String string2, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string3, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list) {
        this.identitySupplier.buildIdentityProvider(string3, list);
        return (Collection)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance processInstance = (ProcessInstance)this.process.instances().findById(string, ProcessInstanceReadMode.READ_ONLY).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            this.tracing(processInstance);
            processInstance.tags().remove(string2);
            return processInstance.tags().get();
        });
    }

    protected Orders_1_0ModelOutput getModel(ProcessInstance<Orders_1_0Model> processInstance) {
        if (processInstance.status() == 5 && processInstance.errors().isPresent()) {
            throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
        }
        return this.mapOutput(new Orders_1_0ModelOutput(), (Orders_1_0Model)processInstance.variables(), processInstance.businessKey());
    }

    protected Policy[] policies(String string, List<String> list) {
        return new Policy[]{SecurityPolicy.of((IdentityProvider)IdentityProvider.get())};
    }

    protected Orders_1_0Model mapInput(Orders_1_0ModelInput orders_1_0ModelInput, Orders_1_0Model orders_1_0Model) {
        orders_1_0Model.fromMap(orders_1_0ModelInput.toMap());
        return orders_1_0Model;
    }

    protected Orders_1_0ModelOutput mapOutput(Orders_1_0ModelOutput orders_1_0ModelOutput, Orders_1_0Model orders_1_0Model, String string) {
        orders_1_0ModelOutput.fromMap(string != null ? string : orders_1_0Model.getId(), orders_1_0Model.toMap());
        return orders_1_0ModelOutput;
    }

    protected String extractImageBaseUri(String string) {
        return string.substring(0, string.indexOf("/image"));
    }

    protected void tracing(ProcessInstance<?> processInstance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved list of instances", content={@Content(mediaType="application/json", schema=@Schema(implementation=OrderItemsModelOutput.class, type=SchemaType.ARRAY))})})
    @Operation(summary="Retrieves instances of orderItems")
    @GET
    @Path(value="{id}/orderItems")
    @Produces(value={"application/json"})
    public List<OrderItemsModelOutput> getAll_orderItems(@PathParam(value="id") String string, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string2, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list) {
        try {
            this.identitySupplier.buildIdentityProvider(string2, list);
            ProcessInstance processInstance = this.process.instances().findById(string, ProcessInstanceReadMode.READ_ONLY).orElse(null);
            if (processInstance != null) {
                List<OrderItemsModelOutput> list2 = processInstance.subprocesses().stream().map(object -> this.mapOutput(new OrderItemsModelOutput(), (OrderItemsModel)((ProcessInstance)object).variables(), ((ProcessInstance)object).businessKey())).collect(Collectors.toList());
                return list2;
            }
            List<OrderItemsModelOutput> list3 = Collections.emptyList();
            return list3;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    @APIResponses(value={@APIResponse(responseCode="404", description="In case of image does not exist for orderItems", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved instance's image", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))})})
    @Operation(hidden=true, summary="Retrieves image for orderItems")
    @GET
    @Path(value="{id}/orderItems/image")
    @Produces(value={"application/svg+xml"})
    public Response get_image_orderItems(@PathParam(value="id") String string) {
        String string2 = this.subprocess_orderItems.image();
        if (string2 == null) {
            throw new ProcessImageNotFoundException(this.process.id());
        }
        ImageStreamingOutput imageStreamingOutput = new ImageStreamingOutput(string2);
        Response.ResponseBuilder responseBuilder = Response.ok().entity((Object)imageStreamingOutput);
        return responseBuilder.header("Content-Type", (Object)"image/svg+xml").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=OrderItemsModelOutput.class))})})
    @Operation(summary="Retrieves orderItems instance with given id")
    @GET
    @Path(value="{id}/orderItems/{id_orderItems}")
    @Produces(value={"application/json"})
    public OrderItemsModelOutput get_orderItems(@PathParam(value="id") String string, @PathParam(value="id_orderItems") String string2, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string3, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list) {
        try {
            this.identitySupplier.buildIdentityProvider(string3, list);
            OrderItemsModelOutput orderItemsModelOutput = this.subprocess_orderItems.instances().findById(string + ":" + string2, ProcessInstanceReadMode.READ_ONLY).map(processInstance -> this.mapOutput(new OrderItemsModelOutput(), (OrderItemsModel)processInstance.variables(), processInstance.businessKey())).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            return orderItemsModelOutput;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))})})
    @Operation(hidden=true, summary="Retrieves orderItems instance's image for given id")
    @GET
    @Path(value="{id}/orderItems/{id_orderItems}/image")
    @Produces(value={"application/json"})
    public Response get_instance_image_orderItems(@Context UriInfo uriInfo, @PathParam(value="id") String string, @PathParam(value="id_orderItems") String string2, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string3, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list) {
        try {
            this.identitySupplier.buildIdentityProvider(string3, list);
            ProcessInstance processInstance = (ProcessInstance)this.subprocess_orderItems.instances().findById(string + ":" + string2, ProcessInstanceReadMode.READ_ONLY).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            String string4 = processInstance.image(this.extractImageBaseUri(uriInfo.getRequestUri().toString()));
            if (string4 == null) {
                throw new ProcessImageNotFoundException(this.subprocess_orderItems.id());
            }
            ImageStreamingOutput imageStreamingOutput = new ImageStreamingOutput(string4);
            Response.ResponseBuilder responseBuilder = Response.ok().entity((Object)imageStreamingOutput);
            Response response = responseBuilder.header("Content-Type", (Object)"image/svg+xml").build();
            return response;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully deleted instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=OrderItemsModelOutput.class))})})
    @Operation(summary="Deletes orderItems instance with given id")
    @DELETE
    @Path(value="{id}/orderItems/{id_orderItems}")
    @Produces(value={"application/json"})
    public OrderItemsModelOutput delete_orderItems(@PathParam(value="id") String string, @PathParam(value="id_orderItems") String string2, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string3, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list) {
        this.identitySupplier.buildIdentityProvider(string3, list);
        return (OrderItemsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance processInstance = (ProcessInstance)this.subprocess_orderItems.instances().findById(string + ":" + string2).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            this.tracing(processInstance);
            processInstance.abort();
            return this.getSubModel_orderItems((ProcessInstance<OrderItemsModel>)processInstance);
        });
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully updated instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=OrderItemsModelOutput.class))})})
    @Operation(summary="Updates data of orderItems instance with given id")
    @POST
    @Path(value="{id}/orderItems/{id_orderItems}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OrderItemsModelOutput updateModel_orderItems(@PathParam(value="id") String string, @PathParam(value="id_orderItems") String string2, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String string3, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> list, OrderItemsModel orderItemsModel) {
        this.identitySupplier.buildIdentityProvider(string3, list);
        return (OrderItemsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance processInstance = (ProcessInstance)this.subprocess_orderItems.instances().findById(string + ":" + string2).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            this.tracing(processInstance);
            processInstance.updateVariables((Object)orderItemsModel);
            return this.mapOutput(new OrderItemsModelOutput(), (OrderItemsModel)processInstance.variables(), processInstance.businessKey());
        });
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved task of the instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkItem.Descriptor.class, type=SchemaType.ARRAY))})})
    @Operation(summary="Retrieves tasks currently active in orderItems instance with given id")
    @GET
    @Path(value="{id}/orderItems/{id_orderItems}/tasks")
    @Produces(value={"application/json"})
    public List<WorkItem.Descriptor> getTasks_orderItems(@PathParam(value="id") String string, @PathParam(value="id_orderItems") String string2, @QueryParam(value="user") String string3, @QueryParam(value="group") List<String> list) {
        this.identitySupplier.buildIdentityProvider(string3, list);
        return (List)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.subprocess_orderItems.instances().findById(string + ":" + string2, ProcessInstanceReadMode.READ_ONLY).map(processInstance -> processInstance.workItems(this.policies(string3, list))).map(list -> list.stream().map(WorkItem::toMap).collect(Collectors.toList())).orElseThrow(() -> new ProcessInstanceNotFoundException(string2)));
    }

    protected OrderItemsModelOutput getSubModel_orderItems(ProcessInstance<OrderItemsModel> processInstance) {
        if (processInstance.status() == 5 && processInstance.errors().isPresent()) {
            throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessErrors)processInstance.errors().get()).failedNodeIds(), ((ProcessErrors)processInstance.errors().get()).errorMessages());
        }
        return this.mapOutput(new OrderItemsModelOutput(), (OrderItemsModel)processInstance.variables(), processInstance.businessKey());
    }

    protected OrderItemsModel mapInput(OrderItemsModelInput orderItemsModelInput, OrderItemsModel orderItemsModel) {
        orderItemsModel.fromMap(orderItemsModelInput.toMap());
        return orderItemsModel;
    }

    protected OrderItemsModelOutput mapOutput(OrderItemsModelOutput orderItemsModelOutput, OrderItemsModel orderItemsModel, String string) {
        orderItemsModelOutput.fromMap(string != null ? string : orderItemsModel.getId(), orderItemsModel.toMap());
        return orderItemsModelOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of task instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully completed instance of Verify_order task with given id", content={@Content(mediaType="application/json", schema=@Schema(implementation=OrderItemsModelOutput.class))})})
    @Operation(summary="Completes Verify_order task instance with given id")
    @POST
    @Path(value="{id}/orderItems/{id_orderItems}/Verify_order/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OrderItemsModelOutput completeTask_Verify_order_0(@PathParam(value="id") String string, @PathParam(value="id_orderItems") String string2, @PathParam(value="workItemId") String string3, @QueryParam(value="phase") @DefaultValue(value="complete") String string4, @QueryParam(value="user") String string5, @QueryParam(value="group") List<String> list, OrderItems_4_TaskOutput orderItems_4_TaskOutput) {
        try {
            this.identitySupplier.buildIdentityProvider(string5, list);
            OrderItemsModelOutput orderItemsModelOutput = (OrderItemsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                Object object = string2.contains(":") ? string2 : string + ":" + string2;
                ProcessInstance processInstance = (ProcessInstance)this.subprocess_orderItems.instances().findById((String)object).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
                this.tracing(processInstance);
                HumanTaskTransition humanTaskTransition = new HumanTaskTransition(string4, orderItems_4_TaskOutput.toMap(), IdentityProvider.get());
                processInstance.transitionWorkItem(string3, (Transition)humanTaskTransition);
                return this.getSubModel_orderItems((ProcessInstance<OrderItemsModel>)processInstance);
            });
            return orderItemsModelOutput;
        }
        catch (WorkItemNotFoundException workItemNotFoundException) {
            OrderItemsModelOutput orderItemsModelOutput = null;
            return orderItemsModelOutput;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of task instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully retrieved instance of Verify_order task with given id", content={@Content(mediaType="application/json", schema=@Schema(implementation=OrderItems_4_TaskInput.class))})})
    @Operation(summary="Retrieves Verify_order task instance with given id")
    @GET
    @Path(value="{id}/orderItems/{id_orderItems}/Verify_order/{workItemId}")
    @Produces(value={"application/json"})
    public OrderItems_4_TaskInput getTask_Verify_order_0(@PathParam(value="id") String string, @PathParam(value="id_orderItems") String string2, @PathParam(value="workItemId") String string3, @QueryParam(value="user") String string4, @QueryParam(value="group") List<String> list) {
        ProcessInstance processInstance;
        try {
            this.identitySupplier.buildIdentityProvider(string4, list);
            Object object = string2.contains(":") ? string2 : string + ":" + string2;
            processInstance = (ProcessInstance)this.subprocess_orderItems.instances().findById((String)object, ProcessInstanceReadMode.READ_ONLY).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
            WorkItem workItem = processInstance.workItem(string3, this.policies(string4, list));
            if (workItem == null) {
                OrderItems_4_TaskInput orderItems_4_TaskInput = null;
                return orderItems_4_TaskInput;
            }
            OrderItems_4_TaskInput orderItems_4_TaskInput = OrderItems_4_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
            return orderItems_4_TaskInput;
        }
        catch (WorkItemNotFoundException workItemNotFoundException) {
            processInstance = null;
            return processInstance;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    @APIResponses(value={@APIResponse(responseCode="500", description="In case of processing errors", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="In case of task instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Successfully aborted instance of Verify_order task with given id", content={@Content(mediaType="application/json", schema=@Schema(implementation=OrderItemsModelOutput.class))})})
    @Operation(summary="Aborts Verify_order task instance with given id")
    @DELETE
    @Path(value="{id}/orderItems/{id_orderItems}/Verify_order/{workItemId}")
    @Produces(value={"application/json"})
    public OrderItemsModelOutput abortTask_Verify_order_0(@PathParam(value="id") String string, @PathParam(value="id_orderItems") String string2, @PathParam(value="workItemId") String string3, @QueryParam(value="phase") @DefaultValue(value="abort") String string4, @QueryParam(value="user") String string5, @QueryParam(value="group") List<String> list) {
        try {
            this.identitySupplier.buildIdentityProvider(string5, list);
            return (OrderItemsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                Object object = string2.contains(":") ? string2 : string + ":" + string2;
                ProcessInstance processInstance = (ProcessInstance)this.subprocess_orderItems.instances().findById((String)object).orElseThrow(() -> new ProcessInstanceNotFoundException(string2));
                this.tracing(processInstance);
                HumanTaskTransition humanTaskTransition = new HumanTaskTransition(string4, null, IdentityProvider.get());
                processInstance.transitionWorkItem(string3, (Transition)humanTaskTransition);
                return this.getSubModel_orderItems((ProcessInstance<OrderItemsModel>)processInstance);
            });
        }
        catch (WorkItemNotFoundException workItemNotFoundException) {
            return null;
        }
    }

    protected class ImageStreamingOutput
    implements StreamingOutput {
        private String image;

        public ImageStreamingOutput(String string) {
            this.image = string;
        }

        public void write(OutputStream outputStream) throws IOException, WebApplicationException {
            outputStream.write(this.image.getBytes(StandardCharsets.UTF_8));
        }
    }
}

