/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.service;

import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.uow.UnitOfWork;
import io.automatiko.engine.services.uow.DefaultUnitOfWorkManager;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowThreadContextProvider
implements ThreadContextProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowThreadContextProvider.class);
    public static final String NAME = "Workflow";

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        UnitOfWork capturedUnitOfWork = DefaultUnitOfWorkManager.getUnitOfWork();
        IdentityProvider capturedIdentity = IdentityProvider.isSet() ? IdentityProvider.get() : null;
        return () -> {
            IdentityProvider currentIdentity;
            UnitOfWork currentUnitOfWork = DefaultUnitOfWorkManager.getUnitOfWork();
            Object object = currentIdentity = IdentityProvider.isSet() ? IdentityProvider.get() : null;
            if (currentUnitOfWork != capturedUnitOfWork) {
                DefaultUnitOfWorkManager.setUnitOfWork((UnitOfWork)capturedUnitOfWork);
            }
            if (currentIdentity != capturedIdentity) {
                IdentityProvider.set((IdentityProvider)capturedIdentity);
            }
            return () -> {
                DefaultUnitOfWorkManager.setUnitOfWork((UnitOfWork)currentUnitOfWork);
                IdentityProvider.set((IdentityProvider)currentIdentity);
            };
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return () -> {
            UnitOfWork movedUnitOfWork = DefaultUnitOfWorkManager.getUnitOfWork();
            IdentityProvider movedIdentity = IdentityProvider.isSet() ? IdentityProvider.get() : null;
            return () -> {
                if (movedUnitOfWork != null) {
                    DefaultUnitOfWorkManager.setUnitOfWork((UnitOfWork)movedUnitOfWork);
                    IdentityProvider.set((IdentityProvider)movedIdentity);
                }
            };
        };
    }

    public String getThreadContextType() {
        return NAME;
    }
}

