/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.service.metrics;

import io.automatiko.engine.api.event.process.DefaultProcessEventListener;
import io.automatiko.engine.api.event.process.ProcessCompletedEvent;
import io.automatiko.engine.api.event.process.ProcessNodeInstanceFailedEvent;
import io.automatiko.engine.api.event.process.ProcessStartedEvent;
import io.automatiko.engine.workflow.process.instance.impl.WorkflowProcessInstanceImpl;
import io.quarkus.arc.properties.IfBuildProperty;
import io.smallrye.metrics.MetricRegistries;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;

@IfBuildProperty(name="quarkus.automatiko.metrics.enabled", stringValue="true")
@ApplicationScoped
public class ProcessMetricsEventListener
extends DefaultProcessEventListener {
    @ConfigProperty(name="quarkus.application.name", defaultValue="")
    Optional<String> application;
    @ConfigProperty(name="quarkus.application.version", defaultValue="")
    Optional<String> version;

    public void afterProcessStarted(ProcessStartedEvent event) {
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        Metadata startedPIMetadata = Metadata.builder().withName("automatiko.process.started.count").withDescription("Total count of started process instances").withType(MetricType.COUNTER).build();
        Counter counter = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR).counter(startedPIMetadata, new Tag[]{new Tag("application", this.application.orElse("")), new Tag("version", this.version.orElse("")), new Tag("processId", processInstance.getProcessId()), new Tag("processVersion", processInstance.getProcess().getVersion() == null ? "unknown" : processInstance.getProcess().getVersion()), new Tag("businessKey", processInstance.getCorrelationKey() == null ? "" : processInstance.getCorrelationKey())});
        counter.inc();
        Metadata currentlyActivePIMetadata = Metadata.builder().withName("automatiko.process.current.active.count").withDescription("Currently Active Process Instances").withType(MetricType.CONCURRENT_GAUGE).build();
        ConcurrentGauge currentlyActive = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR).concurrentGauge(currentlyActivePIMetadata, new Tag[]{new Tag("application", this.application.orElse("")), new Tag("version", this.version.orElse("")), new Tag("processId", processInstance.getProcessId()), new Tag("processVersion", processInstance.getProcess().getVersion() == null ? "unknown" : processInstance.getProcess().getVersion()), new Tag("businessKey", processInstance.getCorrelationKey() == null ? "" : processInstance.getCorrelationKey())});
        currentlyActive.inc();
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        Counter counter;
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        if (processInstance.getState() == 2) {
            Metadata completedPIMetadata = Metadata.builder().withName("automatiko.process.completed.count").withDescription("Displays total count of completed process instances").withType(MetricType.COUNTER).build();
            counter = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR).counter(completedPIMetadata, new Tag[]{new Tag("application", this.application.orElse("")), new Tag("version", this.version.orElse("")), new Tag("processId", processInstance.getProcessId()), new Tag("processVersion", processInstance.getProcess().getVersion() == null ? "unknown" : processInstance.getProcess().getVersion()), new Tag("businessKey", processInstance.getCorrelationKey() == null ? "" : processInstance.getCorrelationKey())});
        } else {
            Metadata abortedPIMetadata = Metadata.builder().withName("automatiko.process.aborted.count").withDescription("Displays total count of aborted process instances").withType(MetricType.COUNTER).build();
            counter = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR).counter(abortedPIMetadata, new Tag[]{new Tag("application", this.application.orElse("")), new Tag("version", this.version.orElse("")), new Tag("processId", processInstance.getProcessId()), new Tag("processVersion", processInstance.getProcess().getVersion() == null ? "unknown" : processInstance.getProcess().getVersion()), new Tag("businessKey", processInstance.getCorrelationKey() == null ? "" : processInstance.getCorrelationKey())});
        }
        counter.inc();
        if (processInstance.getStartDate() != null) {
            Metadata processInstanceDurationMetadata = Metadata.builder().withName("automatiko.process.instances.duration").withDescription("Displays duration of process instances - from start to completion").withType(MetricType.SIMPLE_TIMER).withUnit(TimeUnit.MILLISECONDS.name()).build();
            SimpleTimer instanceDuration = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR).simpleTimer(processInstanceDurationMetadata, new Tag[]{new Tag("application", this.application.orElse("")), new Tag("version", this.version.orElse("")), new Tag("processId", processInstance.getProcessId()), new Tag("processVersion", processInstance.getProcess().getVersion() == null ? "unknown" : processInstance.getProcess().getVersion()), new Tag("businessKey", processInstance.getCorrelationKey() == null ? "" : processInstance.getCorrelationKey())});
            long duration = ProcessMetricsEventListener.millisToSeconds(processInstance.getEndDate().getTime() - processInstance.getStartDate().getTime());
            instanceDuration.update(Duration.ofMillis(duration));
        }
        Metadata currentlyActivePIMetadata = Metadata.builder().withName("automatiko.process.current.active.count").withDescription("Currently Active Process Instances").withType(MetricType.CONCURRENT_GAUGE).build();
        ConcurrentGauge currentlyActive = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR).concurrentGauge(currentlyActivePIMetadata, new Tag[]{new Tag("application", this.application.orElse("")), new Tag("version", this.version.orElse("")), new Tag("processId", processInstance.getProcessId()), new Tag("processVersion", processInstance.getProcess().getVersion() == null ? "unknown" : processInstance.getProcess().getVersion()), new Tag("businessKey", processInstance.getCorrelationKey() == null ? "" : processInstance.getCorrelationKey())});
        currentlyActive.dec();
    }

    public void afterNodeInstanceFailed(ProcessNodeInstanceFailedEvent event) {
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        Metadata erroredtMetadata = Metadata.builder().withName("automatiko.process.errored.count").withDescription("Displays total count of process instances that failed during execution - failure of given node").withType(MetricType.COUNTER).build();
        Counter counter = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR).counter(erroredtMetadata, new Tag[]{new Tag("application", this.application.orElse("")), new Tag("version", this.version.orElse("")), new Tag("processId", processInstance.getProcessId()), new Tag("processVersion", processInstance.getProcess().getVersion() == null ? "unknown" : processInstance.getProcess().getVersion()), new Tag("businessKey", processInstance.getCorrelationKey() == null ? "" : processInstance.getCorrelationKey()), new Tag("nodeName", event.getNodeInstance().getNodeName())});
        counter.inc();
    }

    protected static long millisToSeconds(long millis) {
        return millis / 1000L;
    }
}

