/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.service.tracing;

import io.automatiko.engine.api.runtime.process.ProcessInstance;
import io.automatiko.engine.api.runtime.process.WorkflowProcessInstance;
import io.opentracing.Tracer;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class TracingAdds {
    @Inject
    Instance<Tracer> tracer;

    public void addTags(io.automatiko.engine.api.workflow.ProcessInstance<?> instance) {
        if (this.tracer.isResolvable()) {
            Collection tags;
            Tracer tracerInstance = (Tracer)this.tracer.get();
            tracerInstance.activeSpan().setTag("workflow.instance.id", instance.id());
            tracerInstance.activeSpan().setTag("workflow.root.instance.id", instance.rootProcessInstanceId() == null ? instance.id() : instance.rootProcessInstanceId());
            if (instance.businessKey() != null) {
                tracerInstance.activeSpan().setTag("workflow.business.key", instance.businessKey());
            }
            if (!(tags = instance.tags().values()).isEmpty()) {
                tracerInstance.activeSpan().setTag("workflow.instance.tags", tags.stream().collect(Collectors.joining(",")));
            }
        }
    }

    public void addTags(ProcessInstance instance) {
        if (this.tracer.isResolvable()) {
            Collection tags;
            Tracer tracerInstance = (Tracer)this.tracer.get();
            tracerInstance.activeSpan().setTag("workflow.instance.id", instance.getId());
            tracerInstance.activeSpan().setTag("workflow.root.instance.id", instance.getRootProcessInstanceId() == null ? instance.getId() : instance.getRootProcessInstanceId());
            if (instance.getCorrelationKey() != null) {
                tracerInstance.activeSpan().setTag("workflow.business.key", instance.getCorrelationKey());
            }
            if (!(tags = ((WorkflowProcessInstance)instance).getTags()).isEmpty()) {
                tracerInstance.activeSpan().setTag("workflow.instance.tags", tags.stream().map(t -> t.getValue()).collect(Collectors.joining(",")));
            }
        }
    }
}

