/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.definition.process.Process;
import io.automatiko.engine.api.io.Resource;
import io.automatiko.engine.api.workflow.ProcessConfig;
import io.automatiko.engine.workflow.bpmn2.BpmnProcess;
import io.automatiko.engine.workflow.bpmn2.BpmnProcessReaderException;
import io.automatiko.engine.workflow.bpmn2.xml.BPMNDISemanticModule;
import io.automatiko.engine.workflow.bpmn2.xml.BPMNExtensionsSemanticModule;
import io.automatiko.engine.workflow.bpmn2.xml.BPMNSemanticModule;
import io.automatiko.engine.workflow.compiler.xml.SemanticModule;
import io.automatiko.engine.workflow.compiler.xml.SemanticModules;
import io.automatiko.engine.workflow.compiler.xml.XmlProcessReader;
import io.automatiko.engine.workflow.process.core.WorkflowProcess;
import io.automatiko.engine.workflow.process.core.node.SubProcessNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BpmnProcessCompiler {
    private final SemanticModules bpmnSemanticModules = new SemanticModules();

    public BpmnProcessCompiler(SemanticModule ... modules) {
        if (modules.length == 0) {
            this.bpmnSemanticModules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
            this.bpmnSemanticModules.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
            this.bpmnSemanticModules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        } else {
            for (SemanticModule module : modules) {
                this.bpmnSemanticModules.addSemanticModule(module);
            }
        }
    }

    protected SemanticModules getSemanticModules() {
        return this.bpmnSemanticModules;
    }

    public List<BpmnProcess> from(ProcessConfig config, Resource ... resources) {
        try {
            ArrayList processes = new ArrayList();
            for (Resource resource : resources) {
                XmlProcessReader xmlReader = new XmlProcessReader(this.getSemanticModules(), Thread.currentThread().getContextClassLoader());
                this.configureProcessReader(xmlReader, config);
                processes.addAll(xmlReader.read(resource.getReader()));
            }
            List<BpmnProcess> bpmnProcesses = processes.stream().map(p -> this.create((Process)p, config)).filter(p -> p != null).collect(Collectors.toList());
            bpmnProcesses.forEach(p -> {
                for (Node node : ((WorkflowProcess)p.process()).getNodesRecursively()) {
                    this.processNode(node, bpmnProcesses);
                }
            });
            return bpmnProcesses;
        }
        catch (Exception e) {
            throw new BpmnProcessReaderException(e);
        }
    }

    public List<Process> parse(Resource ... resources) {
        return this.parse((ProcessConfig)null, resources);
    }

    public List<Process> parse(ProcessConfig config, Resource ... resources) {
        try {
            ArrayList<Process> processes = new ArrayList<Process>();
            XmlProcessReader xmlReader = new XmlProcessReader(this.getSemanticModules(), Thread.currentThread().getContextClassLoader());
            this.configureProcessReader(xmlReader, config);
            for (Resource resource : resources) {
                processes.addAll(xmlReader.read(resource.getReader()));
            }
            return processes;
        }
        catch (Exception e) {
            throw new BpmnProcessReaderException(e);
        }
    }

    protected void configureProcessReader(XmlProcessReader xmlReader, ProcessConfig config) {
    }

    protected BpmnProcess create(Process process, ProcessConfig config) {
        return config == null ? new BpmnProcess(process) : new BpmnProcess(process, config);
    }

    protected void processNode(Node node, List<BpmnProcess> bpmnProcesses) {
        if (node instanceof SubProcessNode) {
            ((SubProcessNode)node).internalSubProcess(bpmnProcesses);
        }
    }
}

