/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2;

import io.automatiko.engine.api.Model;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.Processes;
import io.automatiko.engine.workflow.bpmn2.BpmnProcess;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BpmnProcesses
implements Processes {
    private Map<String, BpmnProcess> processes = new HashMap<String, BpmnProcess>();

    public BpmnProcesses(List<BpmnProcess> processList) {
        if (processList != null) {
            for (BpmnProcess process : processList) {
                this.processes.put(process.id(), process);
            }
        }
    }

    public Process<? extends Model> processById(String id) {
        return (Process)this.processes.get(id);
    }

    public Collection<String> processIds() {
        return this.processes.keySet();
    }

    public Collection<BpmnProcess> processes() {
        return this.processes.values();
    }

    public void activate() {
        this.processes.values().forEach(p -> p.activate());
    }

    public void deactivate() {
        this.processes.values().forEach(p -> p.deactivate());
    }
}

