/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.definition.process.NodeContainer;
import io.automatiko.engine.api.runtime.process.DataTransformer;
import io.automatiko.engine.workflow.base.core.event.EventTransformer;
import io.automatiko.engine.workflow.base.core.event.EventTransformerImpl;
import io.automatiko.engine.workflow.base.core.event.EventTypeFilter;
import io.automatiko.engine.workflow.base.core.event.NonAcceptingEventTypeFilter;
import io.automatiko.engine.workflow.base.core.impl.DataTransformerRegistry;
import io.automatiko.engine.workflow.base.core.timer.DateTimeUtils;
import io.automatiko.engine.workflow.bpmn2.core.Error;
import io.automatiko.engine.workflow.bpmn2.core.Escalation;
import io.automatiko.engine.workflow.bpmn2.core.ItemDefinition;
import io.automatiko.engine.workflow.bpmn2.core.Message;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractNodeHandler;
import io.automatiko.engine.workflow.bpmn2.xml.ProcessHandler;
import io.automatiko.engine.workflow.bpmn2.xml.XmlBPMNProcessDumper;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.compiler.xml.XmlDumper;
import io.automatiko.engine.workflow.process.core.node.BoundaryEventNode;
import io.automatiko.engine.workflow.process.core.node.EventNode;
import io.automatiko.engine.workflow.process.core.node.Transformation;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BoundaryEventHandler
extends AbstractNodeHandler {
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();

    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        return new BoundaryEventNode();
    }

    public Class generateNodeFor() {
        return BoundaryEventNode.class;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        io.automatiko.engine.workflow.process.core.Node node = (io.automatiko.engine.workflow.process.core.Node)parser.getCurrent();
        String attachedTo = element.getAttribute("attachedToRef");
        Attr cancelActivityAttr = element.getAttributeNode("cancelActivity");
        boolean cancelActivity = true;
        if (cancelActivityAttr != null) {
            cancelActivity = Boolean.parseBoolean(cancelActivityAttr.getValue());
        }
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("escalationEventDefinition".equals(nodeName)) {
                this.handleEscalationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                node.setMetaData("EventType", (Object)"escalation");
                break;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                this.handleErrorNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                node.setMetaData("EventType", (Object)"error");
                break;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                this.handleTimerNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                node.setMetaData("EventType", (Object)"timer");
                break;
            }
            if ("compensateEventDefinition".equals(nodeName)) {
                this.handleCompensationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                node.setMetaData("EventType", (Object)"compensation");
                break;
            }
            if ("signalEventDefinition".equals(nodeName)) {
                this.handleSignalNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                node.setMetaData("EventType", (Object)"signal");
                break;
            }
            if ("conditionalEventDefinition".equals(nodeName)) {
                this.handleConditionNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                node.setMetaData("EventType", (Object)"condition");
                break;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            this.handleMessageNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
            node.setMetaData("EventType", (Object)"message");
            break;
        }
        node.setMetaData("DataOutputs", new LinkedHashMap(this.dataOutputTypes));
        io.automatiko.engine.workflow.process.core.NodeContainer nodeContainer = (io.automatiko.engine.workflow.process.core.NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected void handleEscalationNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                this.populateDataOutputs(xmlNode, outputName, parser);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode, parser);
                continue;
            }
            if (!"escalationEventDefinition".equals(nodeName)) continue;
            String escalationRef = ((Element)xmlNode).getAttribute("escalationRef");
            if (escalationRef != null && escalationRef.trim().length() > 0) {
                Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Escalations");
                if (escalations == null) {
                    throw new IllegalArgumentException("No escalations found");
                }
                Escalation escalation = (Escalation)escalations.get(escalationRef);
                if (escalation == null) {
                    throw new IllegalArgumentException("Could not find escalation " + escalationRef);
                }
                ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
                EventTypeFilter eventFilter = new EventTypeFilter();
                String type = escalation.getEscalationCode();
                eventFilter.setType("Escalation-" + attachedTo + "-" + type);
                eventFilters.add(eventFilter);
                eventNode.setEventFilters(eventFilters);
                eventNode.setMetaData("EscalationEvent", (Object)type);
                continue;
            }
            throw new UnsupportedOperationException("General escalation is not yet supported.");
        }
    }

    protected void handleErrorNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            Map itemDefs;
            String structureRef;
            String errorRef;
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                this.populateDataOutputs(xmlNode, outputName, parser);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode, parser);
                continue;
            }
            if (!"errorEventDefinition".equals(nodeName) || (errorRef = ((Element)xmlNode).getAttribute("errorRef")) == null || errorRef.trim().length() <= 0) continue;
            List errors = (List)((ProcessBuildData)parser.getData()).getMetaData("Errors");
            if (errors == null) {
                throw new IllegalArgumentException("No errors found");
            }
            Error error = null;
            for (Error listError : errors) {
                if (!errorRef.equals(listError.getId())) continue;
                error = listError;
            }
            if (error == null) {
                throw new IllegalArgumentException("Could not find error " + errorRef);
            }
            String type = error.getErrorCode();
            boolean hasErrorCode = true;
            if (type == null) {
                type = error.getId();
                hasErrorCode = false;
            }
            if ((structureRef = error.getStructureRef()) != null && (itemDefs = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions")).containsKey(structureRef)) {
                structureRef = ((ItemDefinition)itemDefs.get(structureRef)).getStructureRef();
            }
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Error-" + attachedTo + "-" + type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("ErrorEvent", (Object)type);
            eventNode.setMetaData("HasErrorEvent", (Object)hasErrorCode);
            eventNode.setMetaData("ErrorStructureRef", (Object)structureRef);
            if (error.getMetaData().get("retry") == null) continue;
            eventNode.setMetaData("ErrorRetry", (Object)Long.valueOf(DateTimeUtils.parseDuration((String)((String)error.getMetaData().get("retry")))).intValue());
            if (error.getMetaData().get("retryLimit") != null) {
                eventNode.setMetaData("ErrorRetryLimit", (Object)Integer.parseInt((String)error.getMetaData().get("retryLimit")));
            }
            if (error.getMetaData().get("retryIncrement") != null) {
                eventNode.setMetaData("ErrorRetryIncrement", (Object)Long.valueOf(DateTimeUtils.parseDuration((String)((String)error.getMetaData().get("retryIncrement")))).intValue());
            }
            if (error.getMetaData().get("retryMultiplier") == null) continue;
            eventNode.setMetaData("ErrorRetryIncrementMultiplier", (Object)Float.valueOf(Float.parseFloat((String)error.getMetaData().get("retryMultiplier"))));
        }
    }

    protected void handleTimerNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            EventTypeFilter eventFilter;
            ArrayList<EventTypeFilter> eventFilters;
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            String timeDuration = null;
            String timeCycle = null;
            String timeDate = null;
            String language = "";
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String subNodeName = subNode.getNodeName();
                if ("timeDuration".equals(subNodeName)) {
                    timeDuration = subNode.getTextContent();
                    break;
                }
                if ("timeCycle".equals(subNodeName)) {
                    timeCycle = subNode.getTextContent();
                    language = ((Element)subNode).getAttribute("language");
                    break;
                }
                if ("timeDate".equals(subNodeName)) {
                    timeDate = subNode.getTextContent();
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            if (timeDuration != null && timeDuration.trim().length() > 0) {
                eventFilters = new ArrayList<EventTypeFilter>();
                eventFilter = new EventTypeFilter();
                eventFilter.setType("Timer-" + attachedTo + "-" + timeDuration + "-" + eventNode.getId());
                eventFilters.add(eventFilter);
                eventNode.setEventFilters(eventFilters);
                eventNode.setMetaData("TimeDuration", (Object)timeDuration);
                continue;
            }
            if (timeCycle != null && timeCycle.trim().length() > 0) {
                eventFilters = new ArrayList();
                eventFilter = new EventTypeFilter();
                eventFilter.setType("Timer-" + attachedTo + "-" + timeCycle + "-" + eventNode.getId());
                eventFilters.add(eventFilter);
                eventNode.setEventFilters(eventFilters);
                eventNode.setMetaData("TimeCycle", (Object)timeCycle);
                eventNode.setMetaData("Language", (Object)language);
                continue;
            }
            if (timeDate == null || timeDate.trim().length() <= 0) continue;
            eventFilters = new ArrayList();
            eventFilter = new EventTypeFilter();
            eventFilter.setType("Timer-" + attachedTo + "-" + timeDate + "-" + eventNode.getId());
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("TimeDate", (Object)timeDate);
        }
    }

    protected void handleCompensationNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        BoundaryEventNode eventNode = (BoundaryEventNode)parser.getCurrent();
        super.handleNode(node, element, uri, localName, parser);
        NodeList childs = element.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            String activityRef;
            Element el;
            if (!(childs.item(i) instanceof Element) || !"compensateEventDefinition".equalsIgnoreCase((el = (Element)childs.item(i)).getNodeName()) || (activityRef = el.getAttribute("activityRef")) == null || activityRef.length() <= 0) continue;
            logger.warn("activityRef value [" + activityRef + "] on Boundary Event '" + eventNode.getMetaData("UniqueId") + "' ignored per the BPMN2 specification.");
        }
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setAttachedToNodeId(attachedTo);
        io.automatiko.engine.workflow.process.core.NodeContainer parentContainer = (io.automatiko.engine.workflow.process.core.NodeContainer)parser.getParent();
        NonAcceptingEventTypeFilter eventFilter = new NonAcceptingEventTypeFilter();
        eventFilter.setType("Compensation");
        ArrayList<NonAcceptingEventTypeFilter> eventFilters = new ArrayList<NonAcceptingEventTypeFilter>();
        eventNode.setEventFilters(eventFilters);
        eventFilters.add(eventFilter);
        ProcessHandler.addCompensationScope((ExecutableProcess)parser.getParent(ExecutableProcess.class), (Node)eventNode, (NodeContainer)parentContainer, attachedTo);
    }

    protected void handleSignalNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String type;
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                this.populateDataOutputs(xmlNode, outputName, parser);
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode, parser);
                continue;
            }
            if (!"signalEventDefinition".equals(nodeName) || (type = ((Element)xmlNode).getAttribute("signalRef")) == null || type.trim().length() <= 0) continue;
            type = this.checkSignalAndConvertToRealSignalNam(parser, type);
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType(type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setScope("external");
            eventNode.setMetaData("SignalName", (Object)type);
        }
    }

    protected void handleConditionNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        block0: for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                this.populateDataOutputs(xmlNode, outputName, parser);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode, parser);
                continue;
            }
            if (!"conditionalEventDefinition".equals(nodeName)) continue;
            for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                String subnodeName = subNode.getNodeName();
                if (!"condition".equals(subnodeName)) continue;
                eventNode.setMetaData("Condition", (Object)xmlNode.getTextContent());
                ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
                EventTypeFilter eventFilter = new EventTypeFilter();
                eventFilter.setType("Condition-" + attachedTo);
                eventFilters.add(eventFilter);
                eventNode.setScope("external");
                eventNode.setEventFilters(eventFilters);
                continue block0;
            }
        }
    }

    protected void handleMessageNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                this.populateDataOutputs(xmlNode, outputName, parser);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode, parser);
                continue;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new IllegalArgumentException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new IllegalArgumentException("Could not find message " + messageRef);
            }
            eventNode.setMetaData("MessageType", (Object)message.getType());
            eventNode.setMetaData("TriggerType", (Object)"ConsumeMessage");
            eventNode.setMetaData("TriggerRef", (Object)message.getName());
            eventNode.setMetaData("TriggerCorrelation", (Object)message.getCorrelation());
            eventNode.setMetaData("TriggerCorrelationExpr", (Object)message.getCorrelationExpression());
            eventNode.setMetaData("connector", message.getMetaData().getOrDefault("connector", eventNode.getMetaData("connector")));
            eventNode.setMetaData("topic", message.getMetaData().getOrDefault("topic", eventNode.getMetaData("topic")));
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Message-" + message.getName());
            eventFilters.add(eventFilter);
            eventNode.setScope("external");
            eventNode.setEventFilters(eventFilters);
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, EventNode eventNode, ExtensibleXmlParser parser) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String from = subNode.getTextContent();
        String to = null;
        Transformation transformation = null;
        if ((subNode = subNode.getNextSibling()) != null && "targetRef".equals(subNode.getNodeName())) {
            to = subNode.getTextContent();
            eventNode.setVariableName(to);
            subNode = subNode.getNextSibling();
        } else if (subNode != null && "transformation".equals(subNode.getNodeName())) {
            String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
            String expression = subNode.getTextContent();
            DataTransformer transformer = this.transformerRegistry.find(lang);
            if (transformer == null) {
                throw new IllegalArgumentException("No transformer registered for language " + lang);
            }
            transformation = new Transformation(lang, expression, (String)this.dataOutputs.get(from));
            eventNode.setMetaData("Transformation", (Object)transformation);
            eventNode.setEventTransformer((EventTransformer)new EventTransformerImpl(transformation));
        } else if (subNode != null && "assignment".equals(subNode.getNodeName())) {
            while (subNode != null) {
                org.w3c.dom.Node ssubNode = subNode.getFirstChild();
                to = ssubNode.getNextSibling().getTextContent();
                subNode = subNode.getNextSibling();
                eventNode.setVariableName(to);
            }
        }
        eventNode.setVariableName(this.findVariable(to, parser));
    }

    protected void populateDataOutputs(org.w3c.dom.Node xmlNode, String outputName, ExtensibleXmlParser parser) {
        Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        String itemSubjectRef = ((Element)xmlNode).getAttribute("itemSubjectRef");
        if (itemSubjectRef == null || itemSubjectRef.isEmpty()) {
            String dataType = ((Element)xmlNode).getAttribute("dtype");
            if (dataType == null || dataType.isEmpty()) {
                dataType = "java.lang.String";
            }
            this.dataOutputTypes.put(outputName, dataType);
        } else if (itemDefinitions.get(itemSubjectRef) != null) {
            this.dataOutputTypes.put(outputName, ((ItemDefinition)itemDefinitions.get(itemSubjectRef)).getStructureRef());
        } else {
            this.dataOutputTypes.put(outputName, "java.lang.Object");
        }
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        EventNode eventNode = (EventNode)node;
        String attachedTo = (String)eventNode.getMetaData("AttachedTo");
        if (attachedTo != null) {
            String type = ((EventTypeFilter)eventNode.getEventFilters().get(0)).getType();
            if (type.startsWith("Escalation-")) {
                type = type.substring(attachedTo.length() + 12);
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (io.automatiko.engine.workflow.process.core.Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <escalationEventDefinition escalationRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" />" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Error-")) {
                type = type.substring(attachedTo.length() + 7);
                this.writeNode("boundaryEvent", (io.automatiko.engine.workflow.process.core.Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                this.writeVariableName(eventNode, xmlDump);
                String errorId = this.getErrorIdForErrorCode(type, (io.automatiko.engine.workflow.process.core.Node)eventNode);
                xmlDump.append("      <errorEventDefinition errorRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(errorId) + "\" ");
                xmlDump.append("/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Timer-")) {
                type = type.substring(attachedTo.length() + 7);
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (io.automatiko.engine.workflow.process.core.Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                String duration = (String)eventNode.getMetaData("TimeDuration");
                String cycle = (String)eventNode.getMetaData("TimeCycle");
                String date = (String)eventNode.getMetaData("TimeDate");
                if (duration != null && cycle != null) {
                    String lang = (String)eventNode.getMetaData("Language");
                    Object language = "";
                    if (lang != null && !lang.isEmpty()) {
                        language = "language=\"" + lang + "\" ";
                    }
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)duration) + "</timeDuration>" + EOL + "        <timeCycle xsi:type=\"tFormalExpression\" " + (String)language + ">" + XmlDumper.replaceIllegalChars((String)cycle) + "</timeCycle>" + EOL + "      </timerEventDefinition>" + EOL);
                } else if (duration != null) {
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)duration) + "</timeDuration>" + EOL + "      </timerEventDefinition>" + EOL);
                } else if (date != null) {
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeDate xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)date) + "</timeDate>" + EOL + "      </timerEventDefinition>" + EOL);
                } else {
                    String lang = (String)eventNode.getMetaData("Language");
                    Object language = "";
                    if (lang != null && !lang.isEmpty()) {
                        language = "language=\"" + lang + "\" ";
                    }
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeCycle xsi:type=\"tFormalExpression\" " + (String)language + ">" + XmlDumper.replaceIllegalChars((String)cycle) + "</timeCycle>" + EOL + "      </timerEventDefinition>" + EOL);
                }
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.equals("Compensation")) {
                this.writeNode("boundaryEvent", (io.automatiko.engine.workflow.process.core.Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <compensateEventDefinition/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (node.getMetaData().get("SignalName") != null) {
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (io.automatiko.engine.workflow.process.core.Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <signalEventDefinition signalRef=\"" + type + "\"/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (node.getMetaData().get("Condition") != null) {
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (io.automatiko.engine.workflow.process.core.Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <conditionalEventDefinition>" + EOL);
                xmlDump.append("        <condition xsi:type=\"tFormalExpression\" language=\"https://automatiko.io/rule\">" + eventNode.getMetaData("Condition") + "</condition>" + EOL);
                xmlDump.append("      </conditionalEventDefinition>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Message-")) {
                type = type.substring(8);
                this.writeNode("boundaryEvent", (io.automatiko.engine.workflow.process.core.Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <messageEventDefinition messageRef=\"" + type + "\"/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            }
        }
    }
}

