/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.definition.process.Process;
import io.automatiko.engine.api.expression.ExpressionEvaluator;
import io.automatiko.engine.api.runtime.process.ProcessContext;
import io.automatiko.engine.api.workflow.datatype.DataType;
import io.automatiko.engine.workflow.base.core.ContextContainer;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.BooleanDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.FloatDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.IntegerDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.ObjectDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.StringDataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.UndefinedDataType;
import io.automatiko.engine.workflow.base.instance.impl.Action;
import io.automatiko.engine.workflow.bpmn2.core.Definitions;
import io.automatiko.engine.workflow.bpmn2.core.Interface;
import io.automatiko.engine.workflow.bpmn2.core.ItemDefinition;
import io.automatiko.engine.workflow.compiler.util.ClassUtils;
import io.automatiko.engine.workflow.compiler.xml.BaseAbstractHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.Handler;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.ProcessAction;
import io.automatiko.engine.workflow.process.core.WorkflowProcess;
import io.automatiko.engine.workflow.process.core.impl.ConsequenceAction;
import io.automatiko.engine.workflow.process.core.node.ActionNode;
import io.automatiko.engine.workflow.process.core.node.ForEachNode;
import io.automatiko.engine.workflow.process.core.node.WorkItemNode;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import io.automatiko.engine.workflow.process.instance.NodeInstance;
import io.automatiko.engine.workflow.process.instance.impl.NodeInstanceResolverFactory;
import io.automatiko.engine.workflow.process.instance.node.ActionNodeInstance;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DefinitionsHandler
extends BaseAbstractHandler
implements Handler {
    public DefinitionsHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(null);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        return new Definitions();
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Definitions definitions = (Definitions)parser.getCurrent();
        String namespace = element.getAttribute("targetNamespace");
        List processes = ((ProcessBuildData)parser.getData()).getProcesses();
        Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        List interfaces = (List)((ProcessBuildData)parser.getData()).getMetaData("Interfaces");
        for (Process process : processes) {
            ExecutableProcess ruleFlowProcess = (ExecutableProcess)process;
            ruleFlowProcess.setMetaData("TargetNamespace", (Object)namespace);
            this.postProcessItemDefinitions((NodeContainer)ruleFlowProcess, itemDefinitions, parser.getClassLoader());
            this.postProcessInterfaces((NodeContainer)ruleFlowProcess, interfaces);
            this.postProcessNodes((NodeContainer)ruleFlowProcess, Collections.emptyList(), parser);
        }
        definitions.setTargetNamespace(namespace);
        return definitions;
    }

    public Class<?> generateNodeFor() {
        return Definitions.class;
    }

    private void postProcessInterfaces(NodeContainer nodeContainer, List<Interface> interfaces) {
        for (Node node : nodeContainer.getNodes()) {
            Interface i;
            if (node instanceof NodeContainer) {
                this.postProcessInterfaces((NodeContainer)node, interfaces);
            }
            if (!(node instanceof WorkItemNode) || !"Service Task".equals(((WorkItemNode)node).getMetaData("Type"))) continue;
            WorkItemNode workItemNode = (WorkItemNode)node;
            if (interfaces == null) {
                throw new IllegalArgumentException("No interfaces found");
            }
            String operationRef = (String)workItemNode.getMetaData("OperationRef");
            String implementation = (String)workItemNode.getMetaData("Implementation");
            Interface.Operation operation = null;
            Iterator<Interface> iterator = interfaces.iterator();
            while (iterator.hasNext() && (operation = (i = iterator.next()).getOperation(operationRef)) == null) {
            }
            if (operation == null) {
                throw new IllegalArgumentException("Could not find operation " + operationRef);
            }
            if (workItemNode.getWork().getParameter("Interface") == null) {
                workItemNode.getWork().setParameter("Interface", (Object)operation.getInterface().getName());
            }
            if (workItemNode.getWork().getParameter("Operation") == null) {
                workItemNode.getWork().setParameter("Operation", (Object)operation.getName());
            }
            if (workItemNode.getWork().getParameter("ParameterType") == null && operation.getMessage() != null) {
                workItemNode.getWork().setParameter("ParameterType", (Object)operation.getMessage().getType());
            }
            if (implementation == null) continue;
            workItemNode.getWork().setParameter("interfaceImplementationRef", (Object)operation.getInterface().getImplementationRef());
            workItemNode.getWork().setParameter("operationImplementationRef", (Object)operation.getImplementationRef());
            workItemNode.getWork().setParameter("implementation", (Object)implementation);
        }
    }

    private void postProcessItemDefinitions(NodeContainer nodeContainer, Map<String, ItemDefinition> itemDefinitions, ClassLoader cl) {
        if (nodeContainer instanceof ContextContainer) {
            this.setVariablesDataType((ContextContainer)nodeContainer, itemDefinitions, cl);
        }
        if (nodeContainer instanceof ForEachNode) {
            this.setVariablesDataType((ContextContainer)((ForEachNode)nodeContainer).getCompositeNode(), itemDefinitions, cl);
        }
        for (Node node : nodeContainer.getNodes()) {
            if (node instanceof NodeContainer) {
                this.postProcessItemDefinitions((NodeContainer)node, itemDefinitions, cl);
            }
            if (!(node instanceof ContextContainer)) continue;
            this.setVariablesDataType((ContextContainer)node, itemDefinitions, cl);
        }
    }

    private void setVariablesDataType(ContextContainer container, Map<String, ItemDefinition> itemDefinitions, ClassLoader cl) {
        VariableScope variableScope = (VariableScope)container.getDefaultContext("VariableScope");
        if (variableScope != null) {
            for (Variable variable : variableScope.getVariables()) {
                this.setVariableDataType(variable, itemDefinitions, cl);
            }
        }
    }

    private void setVariableDataType(Variable variable, Map<String, ItemDefinition> itemDefinitions, ClassLoader cl) {
        String itemSubjectRef = (String)variable.getMetaData("ItemSubjectRef");
        if (UndefinedDataType.getInstance().equals(variable.getType()) && itemDefinitions != null && itemSubjectRef != null) {
            Object dataType = new ObjectDataType();
            ItemDefinition itemDefinition = itemDefinitions.get(itemSubjectRef);
            if (itemDefinition != null) {
                String structureRef = itemDefinition.getStructureRef();
                dataType = "java.lang.Boolean".equals(structureRef) || "Boolean".equals(structureRef) ? new BooleanDataType() : ("java.lang.Integer".equals(structureRef) || "Integer".equals(structureRef) ? new IntegerDataType() : ("java.lang.Float".equals(structureRef) || "Float".equals(structureRef) ? new FloatDataType() : ("java.lang.String".equals(structureRef) || "String".equals(structureRef) ? new StringDataType() : ("java.lang.Object".equals(structureRef) || "Object".equals(structureRef) ? new ObjectDataType(Object.class, structureRef) : new ObjectDataType(ClassUtils.constructClass((String)structureRef, (ClassLoader)cl), structureRef)))));
            }
            variable.setType((DataType)dataType);
        }
    }

    protected void postProcessNodes(NodeContainer nodeContainer, List<Variable> parentVariables, ExtensibleXmlParser parser) throws SAXException {
        block8: for (Node node : nodeContainer.getNodes()) {
            ActionNode actionNode;
            ProcessAction action;
            LinkedList<Variable> variables = new LinkedList<Variable>(parentVariables);
            VariableScope variableScope = (VariableScope)((ContextContainer)nodeContainer).getDefaultContext("VariableScope");
            if (variableScope != null) {
                variables.addAll(variableScope.getVariables());
            }
            if (node instanceof NodeContainer) {
                this.postProcessNodes((NodeContainer)node, variables, parser);
                continue;
            }
            if (!(node instanceof ActionNode) || !((action = (actionNode = (ActionNode)node).getAction()) instanceof ConsequenceAction)) continue;
            ConsequenceAction consequenceAction = (ConsequenceAction)action;
            switch (consequenceAction.getDialect()) {
                case "java": {
                    if (actionNode.getAction().getMetaData("Action") != null) continue block8;
                    actionNode.getAction().setMetaData("Action", (Object)new MvelAction(actionNode));
                    continue block8;
                }
                case "mvel": {
                    if (actionNode.getAction().getMetaData("Action") != null) continue block8;
                    actionNode.getAction().setMetaData("Action", (Object)new MvelAction(actionNode));
                    continue block8;
                }
            }
        }
    }

    private static class MvelAction
    implements Action {
        private ActionNode actionNode;

        public MvelAction(ActionNode actionNode) {
            this.actionNode = actionNode;
        }

        public void execute(ProcessContext context) throws Exception {
            String expression = ((ConsequenceAction)this.actionNode.getAction()).getConsequence();
            NodeInstanceResolverFactory resolverFactory = new NodeInstanceResolverFactory((NodeInstance)context.getNodeInstance());
            resolverFactory.addExtraParameters(Collections.singletonMap("kcontext", context));
            ExpressionEvaluator evaluator = (ExpressionEvaluator)((WorkflowProcess)context.getProcessInstance().getProcess()).getDefaultContext("ExpressionEvaluator");
            Object result = evaluator.evaluate(expression, (Object)resolverFactory);
            ((ActionNodeInstance)context.getNodeInstance()).setOutputVariable(result);
        }
    }
}

