/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.WorkflowProcess;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.bpmn2.core.Association;
import io.automatiko.engine.workflow.bpmn2.core.Lane;
import io.automatiko.engine.workflow.bpmn2.core.SequenceFlow;
import io.automatiko.engine.workflow.compiler.xml.BaseAbstractHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.Handler;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LaneHandler
extends BaseAbstractHandler
implements Handler {
    public static final String LANES = "BPMN.Lanes";

    public LaneHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(ExecutableProcess.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(Lane.class);
            this.validPeers.add(Variable.class);
            this.validPeers.add(io.automatiko.engine.workflow.process.core.Node.class);
            this.validPeers.add(SequenceFlow.class);
            this.validPeers.add(Lane.class);
            this.validPeers.add(Association.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        WorkflowProcess process = (WorkflowProcess)parser.getParent();
        ArrayList<Lane> lanes = (ArrayList<Lane>)((ExecutableProcess)process).getMetaData(LANES);
        if (lanes == null) {
            lanes = new ArrayList<Lane>();
            ((ExecutableProcess)process).setMetaData(LANES, lanes);
        }
        Lane lane = new Lane(id);
        lane.setName(name);
        lanes.add(lane);
        return lane;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Lane lane = (Lane)parser.getCurrent();
        for (Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"flowNodeRef".equals(nodeName)) continue;
            String flowElementRef = xmlNode.getTextContent();
            lane.addFlowElement(flowElementRef);
        }
        return lane;
    }

    public Class<?> generateNodeFor() {
        return Lane.class;
    }
}

