/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Connection;
import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.definition.process.NodeContainer;
import io.automatiko.engine.api.definition.process.Process;
import io.automatiko.engine.api.definition.process.WorkflowProcess;
import io.automatiko.engine.workflow.base.core.Context;
import io.automatiko.engine.workflow.base.core.ContextContainer;
import io.automatiko.engine.workflow.base.core.FunctionTagDefinition;
import io.automatiko.engine.workflow.base.core.StaticTagDefinition;
import io.automatiko.engine.workflow.base.core.context.exception.ActionExceptionHandler;
import io.automatiko.engine.workflow.base.core.context.exception.CompensationHandler;
import io.automatiko.engine.workflow.base.core.context.exception.CompensationScope;
import io.automatiko.engine.workflow.base.core.context.exception.ExceptionHandler;
import io.automatiko.engine.workflow.base.core.context.exception.ExceptionScope;
import io.automatiko.engine.workflow.base.core.context.swimlane.Swimlane;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.base.core.event.EventFilter;
import io.automatiko.engine.workflow.base.core.event.EventTypeFilter;
import io.automatiko.engine.workflow.base.core.timer.Timer;
import io.automatiko.engine.workflow.base.instance.impl.Action;
import io.automatiko.engine.workflow.base.instance.impl.actions.CancelNodeInstanceAction;
import io.automatiko.engine.workflow.base.instance.impl.actions.ProcessInstanceCompensationAction;
import io.automatiko.engine.workflow.base.instance.impl.actions.SignalProcessInstanceAction;
import io.automatiko.engine.workflow.bpmn2.core.Association;
import io.automatiko.engine.workflow.bpmn2.core.DataStore;
import io.automatiko.engine.workflow.bpmn2.core.Definitions;
import io.automatiko.engine.workflow.bpmn2.core.Error;
import io.automatiko.engine.workflow.bpmn2.core.Escalation;
import io.automatiko.engine.workflow.bpmn2.core.Interface;
import io.automatiko.engine.workflow.bpmn2.core.IntermediateLink;
import io.automatiko.engine.workflow.bpmn2.core.ItemDefinition;
import io.automatiko.engine.workflow.bpmn2.core.Lane;
import io.automatiko.engine.workflow.bpmn2.core.Message;
import io.automatiko.engine.workflow.bpmn2.core.Resource;
import io.automatiko.engine.workflow.bpmn2.core.SequenceFlow;
import io.automatiko.engine.workflow.bpmn2.core.Signal;
import io.automatiko.engine.workflow.bpmn2.xml.XmlBPMNProcessDumper;
import io.automatiko.engine.workflow.compiler.xml.BaseAbstractHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.Handler;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.process.core.Constraint;
import io.automatiko.engine.workflow.process.core.ProcessAction;
import io.automatiko.engine.workflow.process.core.impl.ConnectionImpl;
import io.automatiko.engine.workflow.process.core.impl.ConnectionRef;
import io.automatiko.engine.workflow.process.core.impl.ConsequenceAction;
import io.automatiko.engine.workflow.process.core.impl.ConstraintImpl;
import io.automatiko.engine.workflow.process.core.impl.ExtendedNodeImpl;
import io.automatiko.engine.workflow.process.core.impl.NodeImpl;
import io.automatiko.engine.workflow.process.core.node.ActionNode;
import io.automatiko.engine.workflow.process.core.node.BoundaryEventNode;
import io.automatiko.engine.workflow.process.core.node.CompositeContextNode;
import io.automatiko.engine.workflow.process.core.node.CompositeNode;
import io.automatiko.engine.workflow.process.core.node.ConstraintTrigger;
import io.automatiko.engine.workflow.process.core.node.DataAssociation;
import io.automatiko.engine.workflow.process.core.node.EndNode;
import io.automatiko.engine.workflow.process.core.node.EventNode;
import io.automatiko.engine.workflow.process.core.node.EventSubProcessNode;
import io.automatiko.engine.workflow.process.core.node.EventTrigger;
import io.automatiko.engine.workflow.process.core.node.FaultNode;
import io.automatiko.engine.workflow.process.core.node.HumanTaskNode;
import io.automatiko.engine.workflow.process.core.node.RuleSetNode;
import io.automatiko.engine.workflow.process.core.node.Split;
import io.automatiko.engine.workflow.process.core.node.StartNode;
import io.automatiko.engine.workflow.process.core.node.StateBasedNode;
import io.automatiko.engine.workflow.process.core.node.StateNode;
import io.automatiko.engine.workflow.process.core.node.SubProcessNode;
import io.automatiko.engine.workflow.process.core.node.Trigger;
import io.automatiko.engine.workflow.process.core.node.WorkItemNode;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import io.automatiko.engine.workflow.util.PatternConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessHandler
extends BaseAbstractHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(ProcessHandler.class);
    public static final String CONNECTIONS = "BPMN.Connections";
    public static final String LINKS = "BPMN.ThrowLinks";
    public static final String ASSOCIATIONS = "BPMN.Associations";
    public static final String ERRORS = "BPMN.Errors";
    public static final String ESCALATIONS = "BPMN.Escalations";
    static final String PROCESS_INSTANCE_SIGNAL_EVENT = "kcontext.getProcessInstance().signalEvent(\"";
    static final String RUNTIME_SIGNAL_EVENT = "kcontext.getKnowledgeRuntime().signalEvent(\"";
    static final String RUNTIME_MANAGER_SIGNAL_EVENT = "((org.kie.api.runtime.manager.RuntimeManager)kcontext.getKnowledgeRuntime().getEnvironment().get(\"RuntimeManager\")).signalEvent(\"";

    public ProcessHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Definitions.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(ItemDefinition.class);
            this.validPeers.add(Resource.class);
            this.validPeers.add(Message.class);
            this.validPeers.add(Interface.class);
            this.validPeers.add(Escalation.class);
            this.validPeers.add(Error.class);
            this.validPeers.add(Signal.class);
            this.validPeers.add(DataStore.class);
            this.validPeers.add(ExecutableProcess.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        Object itemDefinitions;
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        String visibility = attrs.getValue("processType");
        String executable = attrs.getValue("isExecutable");
        String packageName = attrs.getValue("https://automatiko.io", "packageName");
        String dynamic = attrs.getValue("https://automatiko.io", "adHoc");
        String version = attrs.getValue("https://automatiko.io", "version");
        ExecutableProcess process = new ExecutableProcess();
        process.setAutoComplete(true);
        process.setId(id);
        if (name == null) {
            name = id;
        }
        process.setName(name);
        process.setType("RuleFlow");
        if (packageName == null) {
            packageName = "io.automatiko.processes";
        }
        process.setPackageName(packageName);
        if ("true".equals(dynamic)) {
            process.setDynamic(true);
            process.setAutoComplete(false);
        }
        if (executable != null) {
            process.setExecutable(Boolean.parseBoolean(executable));
        }
        if (version != null) {
            process.setVersion(version);
        }
        if (visibility == null || "".equals(visibility)) {
            visibility = "None";
        }
        process.setVisibility(visibility);
        ((ProcessBuildData)parser.getData()).addProcess((Process)process);
        process.setMetaData("Definitions", parser.getParent());
        Object typedImports = ((ProcessBuildData)parser.getData()).getMetaData("Bpmn2Imports");
        if (typedImports != null) {
            process.setMetaData("Bpmn2Imports", typedImports);
        }
        if ((itemDefinitions = ((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions")) != null) {
            process.setMetaData("ItemDefinitions", itemDefinitions);
        }
        parser.getMetaData().put("idGen", new AtomicInteger(1));
        return process;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        ExecutableProcess process = (ExecutableProcess)parser.getCurrent();
        List throwLinks = (List)process.getMetaData(LINKS);
        ProcessHandler.linkIntermediateLinks((NodeContainer)process, throwLinks);
        List connections = (List)process.getMetaData(CONNECTIONS);
        this.linkConnections((NodeContainer)process, connections);
        this.linkBoundaryEvents((NodeContainer)process);
        List associations = (List)process.getMetaData(ASSOCIATIONS);
        ProcessHandler.linkAssociations((Definitions)process.getMetaData("Definitions"), (NodeContainer)process, associations);
        List lanes = (List)process.getMetaData("BPMN.Lanes");
        this.assignLanes(process, lanes);
        this.postProcessNodes(process, (NodeContainer)process);
        this.processTags((WorkflowProcess)process);
        return process;
    }

    public static void linkIntermediateLinks(NodeContainer process, List<IntermediateLink> links) {
        if (null != links) {
            ArrayList<IntermediateLink> throwLinks = new ArrayList<IntermediateLink>();
            for (IntermediateLink aLinks : links) {
                if (!aLinks.isThrowLink()) continue;
                throwLinks.add(aLinks);
            }
            for (IntermediateLink throwLink : throwLinks) {
                ArrayList<IntermediateLink> linksWithSharedNames = new ArrayList<IntermediateLink>();
                for (IntermediateLink aLink : links) {
                    if (!throwLink.getName().equals(aLink.getName())) continue;
                    linksWithSharedNames.add(aLink);
                }
                if (linksWithSharedNames.size() < 2) {
                    throw new IllegalArgumentException("There should be at least 2 link events to make a connection");
                }
                linksWithSharedNames.remove(throwLink);
                Node t = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(process, throwLink.getUniqueId());
                for (IntermediateLink catchLink : linksWithSharedNames) {
                    Node c = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(process, catchLink.getUniqueId());
                    if (t == null || c == null) continue;
                    ConnectionImpl result = new ConnectionImpl(t, "DEFAULT", c, "DEFAULT");
                    result.setMetaData("linkNodeHidden", (Object)"yes");
                }
                links.remove(throwLink);
                links.removeAll(linksWithSharedNames);
            }
            if (links.size() > 0) {
                throw new IllegalArgumentException(links.size() + " links were not processed");
            }
        }
    }

    private static Object findNodeOrDataStoreByUniqueId(Definitions definitions, NodeContainer nodeContainer, String nodeRef, String errorMsg) {
        List<DataStore> dataStores;
        if (definitions != null && (dataStores = definitions.getDataStores()) != null) {
            for (DataStore dataStore : dataStores) {
                if (!nodeRef.equals(dataStore.getId())) continue;
                return dataStore;
            }
        }
        return ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, nodeRef, errorMsg);
    }

    private static Node findNodeByIdOrUniqueIdInMetadata(NodeContainer nodeContainer, String targetRef) {
        return ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, targetRef, "Could not find target node for connection:" + targetRef);
    }

    private static Node findNodeByIdOrUniqueIdInMetadata(NodeContainer nodeContainer, String nodeRef, String errorMsg) {
        Node node = null;
        for (Node containerNode : nodeContainer.getNodes()) {
            if (!nodeRef.equals(containerNode.getMetaData().get("UniqueId"))) continue;
            node = containerNode;
            break;
        }
        if (node == null) {
            throw new IllegalArgumentException(errorMsg);
        }
        return node;
    }

    public Class<?> generateNodeFor() {
        return ExecutableProcess.class;
    }

    public void linkConnections(NodeContainer nodeContainer, List<SequenceFlow> connections) {
        if (connections != null) {
            for (SequenceFlow connection : connections) {
                Constraint constraint;
                String sourceRef = connection.getSourceRef();
                Node source = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, sourceRef, "Could not find source node for connection:" + sourceRef);
                if (source instanceof EventNode) {
                    for (EventFilter eventFilter : ((EventNode)source).getEventFilters()) {
                        if (!(eventFilter instanceof EventTypeFilter) || !"Compensation".equals(((EventTypeFilter)eventFilter).getType())) continue;
                        throw new IllegalArgumentException("A Compensation Boundary Event can only be *associated* with a compensation activity via an Association, not via a Sequence Flow element.");
                    }
                }
                String targetRef = connection.getTargetRef();
                Node target = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, targetRef, "Could not find target node for connection:" + targetRef);
                ConnectionImpl result = new ConnectionImpl(source, "DEFAULT", target, "DEFAULT");
                result.setMetaData("bendpoints", (Object)connection.getBendpoints());
                result.setMetaData("UniqueId", (Object)connection.getId());
                if ("true".equals(System.getProperty("jbpm.enable.multi.con"))) {
                    NodeImpl nodeImpl = (NodeImpl)source;
                    constraint = ProcessHandler.buildConstraint(connection, nodeImpl);
                    if (constraint == null) continue;
                    nodeImpl.addConstraint(new ConnectionRef(connection.getId(), target.getId(), "DEFAULT"), constraint);
                    continue;
                }
                if (!(source instanceof Split)) continue;
                Split split = (Split)source;
                constraint = ProcessHandler.buildConstraint(connection, (NodeImpl)split);
                split.addConstraint(new ConnectionRef(connection.getId(), target.getId(), "DEFAULT"), constraint);
            }
        }
    }

    public void linkBoundaryEvents(NodeContainer nodeContainer) {
        for (Node node : nodeContainer.getNodes()) {
            String attachedTo;
            if (!(node instanceof EventNode) || (attachedTo = (String)node.getMetaData().get("AttachedTo")) == null) continue;
            for (EventFilter filter : ((EventNode)node).getEventFilters()) {
                String type = ((EventTypeFilter)filter).getType();
                Node attachedNode = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, attachedTo, "Could not find node to attach to: " + attachedTo);
                if (!(attachedNode instanceof StateBasedNode) && !type.equals("Compensation")) {
                    throw new IllegalArgumentException("Boundary events are supported only on StateBasedNode, found node: " + attachedNode.getClass().getName() + " [" + attachedNode.getMetaData().get("UniqueId") + "]");
                }
                if (type.startsWith("Escalation")) {
                    this.linkBoundaryEscalationEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (type.startsWith("Error-")) {
                    this.linkBoundaryErrorEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (type.startsWith("Timer-")) {
                    this.linkBoundaryTimerEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (type.equals("Compensation")) {
                    this.linkBoundaryCompensationEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (node.getMetaData().get("SignalName") != null || type.startsWith("Message-")) {
                    this.linkBoundarySignalEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (!type.startsWith("Condition-")) continue;
                this.linkBoundaryConditionEvent(nodeContainer, node, attachedTo, attachedNode);
            }
        }
    }

    protected void linkBoundaryEscalationEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        String escalationCode = (String)node.getMetaData().get("EscalationEvent");
        String escalationStructureRef = (String)node.getMetaData().get("EscalationStructureRef");
        ContextContainer compositeNode = (ContextContainer)attachedNode;
        ExceptionScope exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
        if (exceptionScope == null) {
            exceptionScope = new ExceptionScope();
            compositeNode.addContext((Context)exceptionScope);
            compositeNode.setDefaultContext((Context)exceptionScope);
        }
        String variable = ((EventNode)node).getVariableName();
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        ConsequenceAction action = ProcessHandler.createJavaAction((Action)new SignalProcessInstanceAction("Escalation-" + attachedTo + "-" + escalationCode, variable, "processInstance"));
        exceptionHandler.setAction((ProcessAction)action);
        exceptionHandler.setFaultVariable(variable);
        exceptionScope.setExceptionHandler(escalationCode, (ExceptionHandler)exceptionHandler);
        if (escalationStructureRef != null) {
            exceptionScope.setExceptionHandler(escalationStructureRef, (ExceptionHandler)exceptionHandler);
        }
        if (cancelActivity) {
            ArrayList<ConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<ConsequenceAction>();
            }
            ConsequenceAction cancelAction = new ConsequenceAction("java", "");
            cancelAction.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
            actions.add(cancelAction);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    protected void linkBoundaryErrorEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        ArrayList<ConsequenceAction> actions;
        ContextContainer compositeNode = (ContextContainer)attachedNode;
        ExceptionScope exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
        if (exceptionScope == null) {
            exceptionScope = new ExceptionScope();
            compositeNode.addContext((Context)exceptionScope);
            compositeNode.setDefaultContext((Context)exceptionScope);
        }
        String errorCode = (String)node.getMetaData().get("ErrorEvent");
        boolean hasErrorCode = (Boolean)node.getMetaData().get("HasErrorEvent");
        String errorStructureRef = (String)node.getMetaData().get("ErrorStructureRef");
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        String variable = ((EventNode)node).getVariableName();
        ConsequenceAction action = ProcessHandler.createJavaAction((Action)new SignalProcessInstanceAction("Error-" + attachedTo + "-" + errorCode, variable, "processInstance"));
        exceptionHandler.setAction((ProcessAction)action);
        exceptionHandler.setFaultVariable(variable);
        if (hasErrorCode) {
            for (String error : errorCode.split(",")) {
                exceptionScope.setExceptionHandler(error, (ExceptionHandler)exceptionHandler);
            }
        } else {
            exceptionScope.setExceptionHandler(null, (ExceptionHandler)exceptionHandler);
        }
        exceptionHandler.setRetryAfter((Integer)node.getMetaData().get("ErrorRetry"));
        exceptionHandler.setRetryLimit((Integer)node.getMetaData().get("ErrorRetryLimit"));
        exceptionHandler.setRetryIncrement((Integer)node.getMetaData().get("ErrorRetryIncrement"));
        if (node.getMetaData().get("ErrorRetryIncrementMultiplier") != null) {
            exceptionHandler.setRetryIncrementMultiplier(Float.valueOf(((Number)node.getMetaData().get("ErrorRetryIncrementMultiplier")).floatValue()));
        }
        if (errorStructureRef != null) {
            exceptionScope.setExceptionHandler(errorStructureRef, (ExceptionHandler)exceptionHandler);
        }
        if ((actions = ((EventNode)node).getActions("onExit")) == null) {
            actions = new ArrayList<ConsequenceAction>();
        }
        ConsequenceAction cancelAction = new ConsequenceAction("java", null);
        cancelAction.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
        actions.add(cancelAction);
        ((EventNode)node).setActions("onExit", actions);
    }

    protected void linkBoundaryTimerEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        StateBasedNode compositeNode = (StateBasedNode)attachedNode;
        String timeDuration = (String)node.getMetaData().get("TimeDuration");
        String timeCycle = (String)node.getMetaData().get("TimeCycle");
        String timeDate = (String)node.getMetaData().get("TimeDate");
        Timer timer = new Timer();
        if (timeDuration != null) {
            timer.setDelay(timeDuration);
            timer.setTimeType(1);
            ConsequenceAction consequenceAction = ProcessHandler.createJavaAction((Action)new SignalProcessInstanceAction("Timer-" + attachedTo + "-" + timeDuration + "-" + node.getId(), kcontext -> kcontext.getNodeInstance().getId(), "processInstance"));
            compositeNode.addTimer(timer, (ProcessAction)consequenceAction);
        } else if (timeCycle != null) {
            int index = timeCycle.indexOf("###");
            if (index != -1) {
                String period = timeCycle.substring(index + 3);
                timeCycle = timeCycle.substring(0, index);
                timer.setPeriod(period);
            }
            timer.setDelay(timeCycle);
            timer.setTimeType(2);
            String finalTimeCycle = timeCycle;
            ConsequenceAction action = ProcessHandler.createJavaAction((Action)new SignalProcessInstanceAction("Timer-" + attachedTo + "-" + finalTimeCycle + (String)(timer.getPeriod() == null ? "" : "###" + timer.getPeriod()) + "-" + node.getId(), kcontext -> kcontext.getNodeInstance().getId(), "processInstance"));
            compositeNode.addTimer(timer, (ProcessAction)action);
        } else if (timeDate != null) {
            timer.setDate(timeDate);
            timer.setTimeType(3);
            ConsequenceAction action = ProcessHandler.createJavaAction((Action)new SignalProcessInstanceAction("Timer-" + attachedTo + "-" + timeDate + "-" + node.getId(), kcontext -> kcontext.getNodeInstance().getId(), "processInstance"));
            compositeNode.addTimer(timer, (ProcessAction)action);
        }
        if (cancelActivity) {
            ArrayList<ConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<ConsequenceAction>();
            }
            ConsequenceAction action = ProcessHandler.createJavaAction((Action)new CancelNodeInstanceAction(attachedTo));
            actions.add(action);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    protected void linkBoundaryCompensationEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        String activityRef = (String)node.getMetaData().get("ActivityRef");
        if (activityRef != null) {
            logger.warn("Attribute activityRef={} will be IGNORED since this is a Boundary Compensation Event.", (Object)activityRef);
        }
    }

    protected void linkBoundarySignalEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        if (cancelActivity) {
            ArrayList<ConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<ConsequenceAction>();
            }
            ConsequenceAction action = ProcessHandler.createJavaAction((Action)new CancelNodeInstanceAction(attachedTo));
            actions.add(action);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    protected void linkBoundaryConditionEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        String processId = ((ExecutableProcess)nodeContainer).getId();
        String eventType = "RuleFlowStateEvent-" + processId + "-" + ((EventNode)node).getUniqueId() + "-" + attachedTo;
        ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).setType(eventType);
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        if (cancelActivity) {
            ArrayList<ConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<ConsequenceAction>();
            }
            ConsequenceAction action = ProcessHandler.createJavaAction((Action)new CancelNodeInstanceAction(attachedTo));
            actions.add(action);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    public static void linkAssociations(Definitions definitions, NodeContainer nodeContainer, List<Association> associations) {
        if (associations != null) {
            for (Association association : associations) {
                String sourceRef = association.getSourceRef();
                Object source = null;
                try {
                    source = ProcessHandler.findNodeOrDataStoreByUniqueId(definitions, nodeContainer, sourceRef, "Could not find source [" + sourceRef + "] for association " + association.getId() + "]");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                String targetRef = association.getTargetRef();
                Object target = null;
                try {
                    target = ProcessHandler.findNodeOrDataStoreByUniqueId(definitions, nodeContainer, targetRef, "Could not find target [" + targetRef + "] for association [" + association.getId() + "]");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (source == null || target == null || target instanceof DataStore || source instanceof DataStore || !(source instanceof EventNode)) continue;
                EventNode sourceNode = (EventNode)source;
                Node targetNode = (Node)target;
                ProcessHandler.checkBoundaryEventCompensationHandler(association, (Node)sourceNode, targetNode);
                NodeImpl targetNodeImpl = (NodeImpl)target;
                String isForCompensation = "isForCompensation";
                Object compensationObject = targetNodeImpl.getMetaData(isForCompensation);
                if (compensationObject == null) {
                    targetNodeImpl.setMetaData(isForCompensation, (Object)true);
                    logger.warn("Setting {} attribute to true for node {}", (Object)isForCompensation, (Object)targetRef);
                } else if (!Boolean.parseBoolean(compensationObject.toString())) {
                    throw new IllegalArgumentException(isForCompensation + " attribute [" + compensationObject + "] should be true for Compensation Activity [" + targetRef + "]");
                }
                NodeContainer sourceParent = sourceNode.getParentContainer();
                NodeContainer targetParent = targetNode.getParentContainer();
                if (!sourceParent.equals(targetParent)) {
                    throw new IllegalArgumentException("Compensation Associations may not cross (sub-)process boundaries,");
                }
                ConnectionImpl connection = new ConnectionImpl((Node)sourceNode, "DEFAULT", targetNode, "DEFAULT");
                connection.setMetaData("UniqueId", (Object)association.getId());
                connection.setMetaData("hidden", (Object)true);
                connection.setMetaData("association", (Object)true);
            }
        }
    }

    private static void checkBoundaryEventCompensationHandler(Association association, Node source, Node target) {
        Object nodeTypeObj;
        if (!(source instanceof BoundaryEventNode)) {
            throw new IllegalArgumentException("(Compensation) activities may only be associated with Boundary Event Nodes (not with" + source.getClass().getSimpleName() + " nodes [node " + (String)source.getMetaData().get("UniqueId") + "].");
        }
        BoundaryEventNode eventNode = (BoundaryEventNode)source;
        List eventFilters = eventNode.getEventFilters();
        boolean compensationCheckPassed = false;
        if (eventFilters != null) {
            for (EventFilter filter : eventFilters) {
                Object type;
                if (!(filter instanceof EventTypeFilter) || (type = ((EventTypeFilter)filter).getType()) == null || !((String)type).equals("Compensation")) continue;
                compensationCheckPassed = true;
            }
        }
        if (!compensationCheckPassed) {
            throw new IllegalArgumentException("An Event [" + (String)eventNode.getMetaData("UniqueId") + "] linked from an association [" + association.getId() + "] must be a (Boundary) Compensation Event.");
        }
        String attachedToId = eventNode.getAttachedToNodeId();
        Node attachedToNode = null;
        for (Node node : eventNode.getParentContainer().getNodes()) {
            if (!attachedToId.equals(node.getMetaData().get("UniqueId"))) continue;
            attachedToNode = node;
            break;
        }
        if (attachedToNode == null) {
            throw new IllegalArgumentException("Boundary Event [" + (String)eventNode.getMetaData("UniqueId") + "] is not attached to a node [" + attachedToId + "] that can be found.");
        }
        if (!(attachedToNode instanceof RuleSetNode || attachedToNode instanceof WorkItemNode || attachedToNode instanceof ActionNode || attachedToNode instanceof HumanTaskNode || attachedToNode instanceof CompositeNode || attachedToNode instanceof SubProcessNode)) {
            throw new IllegalArgumentException("Compensation Boundary Event [" + (String)eventNode.getMetaData("UniqueId") + "] must be attached to a task or sub-process.");
        }
        compensationCheckPassed = false;
        if (target instanceof WorkItemNode || target instanceof HumanTaskNode || target instanceof CompositeContextNode || target instanceof SubProcessNode) {
            compensationCheckPassed = true;
        } else if (target instanceof ActionNode && (nodeTypeObj = ((ActionNode)target).getMetaData("NodeType")) != null && nodeTypeObj.equals("ScriptTask")) {
            compensationCheckPassed = true;
        }
        if (!compensationCheckPassed) {
            throw new IllegalArgumentException("An Activity [" + (String)((NodeImpl)target).getMetaData("UniqueId") + "] associated with a Boundary Compensation Event must be a Task or a (non-Event) Sub-Process");
        }
        compensationCheckPassed = true;
        NodeImpl targetNode = (NodeImpl)target;
        Map connectionsMap = targetNode.getOutgoingConnections();
        ConnectionImpl outgoingConnection = null;
        block2: for (String connectionType : connectionsMap.keySet()) {
            List connections = (List)connectionsMap.get(connectionType);
            if (connections == null || connections.isEmpty()) continue;
            for (Connection connection : connections) {
                Object hiddenObj = connection.getMetaData().get("hidden");
                if (hiddenObj != null && ((Boolean)hiddenObj).booleanValue()) continue;
                outgoingConnection = (ConnectionImpl)connection;
                compensationCheckPassed = false;
                continue block2;
            }
        }
        if (!compensationCheckPassed) {
            throw new IllegalArgumentException("A Compensation Activity [" + (String)targetNode.getMetaData("UniqueId") + "] may not have any outgoing connection [" + (String)outgoingConnection.getMetaData("UniqueId") + "]");
        }
    }

    private void assignLanes(ExecutableProcess process, List<Lane> lanes) {
        ArrayList<String> laneNames = new ArrayList<String>();
        HashMap<String, String> laneMapping = new HashMap<String, String>();
        if (lanes != null) {
            for (Lane lane : lanes) {
                String name = lane.getName();
                if (name == null) continue;
                Swimlane swimlane = new Swimlane();
                swimlane.setName(name);
                process.getSwimlaneContext().addSwimlane(swimlane);
                laneNames.add(name);
                for (String flowElementRef : lane.getFlowElements()) {
                    laneMapping.put(flowElementRef, name);
                }
            }
        }
        this.assignLanes((NodeContainer)process, laneMapping);
    }

    private void postProcessNodes(ExecutableProcess process, NodeContainer container) {
        ArrayList<String> eventSubProcessHandlers = new ArrayList<String>();
        for (Node node : container.getNodes()) {
            EventNode eventNode;
            if (node instanceof StartNode) {
                List associations = ((StartNode)node).getOutAssociations();
                if (associations == null) continue;
                for (DataAssociation da : associations) {
                    VariableScope scope = (VariableScope)process.getDefaultContext("VariableScope");
                    Variable variable = scope.findVariable(da.getTarget());
                    if (variable == null) continue;
                    da.setTarget(variable.getName());
                }
                continue;
            }
            if (node instanceof StateNode) {
                StateNode stateNode = (StateNode)node;
                String condition = (String)stateNode.getMetaData("Condition");
                stateNode.setCondition(context -> (Boolean)MVEL.executeExpression((Object)condition, (Map)context.getProcessInstance().getVariables()));
                continue;
            }
            if (node instanceof NodeContainer) {
                if (node instanceof EventSubProcessNode) {
                    Node[] nodes;
                    EventSubProcessNode eventSubProcessNode = (EventSubProcessNode)node;
                    for (Node subNode : nodes = eventSubProcessNode.getNodes()) {
                        List triggers;
                        if (subNode == null || !(subNode instanceof StartNode) || (triggers = ((StartNode)subNode).getTriggers()) == null) continue;
                        for (Trigger trigger : triggers) {
                            ConstraintTrigger constraintTrigger;
                            if (trigger instanceof EventTrigger) {
                                List filters = ((EventTrigger)trigger).getEventFilters();
                                for (EventFilter filter : filters) {
                                    if (!(filter instanceof EventTypeFilter)) continue;
                                    eventSubProcessNode.addEvent((EventTypeFilter)filter);
                                    String type = ((EventTypeFilter)filter).getType();
                                    if (type.startsWith("Error-") || type.startsWith("Escalation")) {
                                        String faultCode = (String)subNode.getMetaData().get("FaultCode");
                                        String replaceRegExp = "Error-|Escalation-";
                                        String signalType = type;
                                        ExceptionScope exceptionScope = (ExceptionScope)((ContextContainer)eventSubProcessNode.getParentContainer()).getDefaultContext("ExceptionScope");
                                        if (exceptionScope == null) {
                                            exceptionScope = new ExceptionScope();
                                            ((ContextContainer)eventSubProcessNode.getParentContainer()).addContext((Context)exceptionScope);
                                            ((ContextContainer)eventSubProcessNode.getParentContainer()).setDefaultContext((Context)exceptionScope);
                                        }
                                        String faultVariable = null;
                                        if (trigger.getInAssociations() != null && !trigger.getInAssociations().isEmpty()) {
                                            faultVariable = this.findVariable((String)((DataAssociation)trigger.getInAssociations().get(0)).getSources().get(0), process.getVariableScope());
                                        }
                                        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
                                        ConsequenceAction action = new ConsequenceAction("java", "");
                                        action.setMetaData("Action", (Object)new SignalProcessInstanceAction(signalType, faultVariable, "processInstance"));
                                        exceptionHandler.setAction((ProcessAction)action);
                                        exceptionHandler.setFaultVariable(faultVariable);
                                        exceptionHandler.setRetryAfter((Integer)subNode.getMetaData().get("ErrorRetry"));
                                        exceptionHandler.setRetryIncrement((Integer)subNode.getMetaData().get("ErrorRetryIncrement"));
                                        if (subNode.getMetaData().get("ErrorRetryIncrementMultiplier") != null) {
                                            exceptionHandler.setRetryIncrementMultiplier(Float.valueOf(((Number)subNode.getMetaData().get("ErrorRetryIncrementMultiplier")).floatValue()));
                                        }
                                        exceptionHandler.setRetryLimit((Integer)subNode.getMetaData().get("ErrorRetryLimit"));
                                        if (faultCode != null) {
                                            String trimmedType = type.replaceFirst(replaceRegExp, "");
                                            for (String error : trimmedType.split(",")) {
                                                exceptionScope.setExceptionHandler(error, (ExceptionHandler)exceptionHandler);
                                                eventSubProcessHandlers.add(error);
                                            }
                                            continue;
                                        }
                                        exceptionScope.setExceptionHandler(faultCode, (ExceptionHandler)exceptionHandler);
                                        continue;
                                    }
                                    if (!type.equals("Compensation")) continue;
                                    NodeContainer subProcess = eventSubProcessNode.getParentContainer();
                                    Object isForCompensationObj = eventSubProcessNode.getMetaData("isForCompensation");
                                    if (isForCompensationObj == null) {
                                        eventSubProcessNode.setMetaData("isForCompensation", (Object)true);
                                        logger.warn("Overriding empty or false value of \"isForCompensation\" attribute on Event Sub-Process [" + eventSubProcessNode.getMetaData("UniqueId") + "] and setting it to true.");
                                    }
                                    if (subProcess instanceof ExecutableProcess) {
                                        throw new IllegalArgumentException("Compensation Event Sub-Processes at the process level are not supported.");
                                    }
                                    NodeContainer parentSubProcess = ((Node)subProcess).getParentContainer();
                                    String compensationHandlerId = (String)((CompositeNode)subProcess).getMetaData("UniqueId");
                                    ProcessHandler.addCompensationScope(process, (Node)eventSubProcessNode, parentSubProcess, compensationHandlerId);
                                }
                                continue;
                            }
                            if (!(trigger instanceof ConstraintTrigger) || (constraintTrigger = (ConstraintTrigger)trigger).getConstraint() == null) continue;
                            String processId = ((ExecutableProcess)container).getId();
                            String type = "RuleFlowStateEventSubProcess-Event-" + processId + "-" + eventSubProcessNode.getUniqueId();
                            EventTypeFilter eventTypeFilter = new EventTypeFilter();
                            eventTypeFilter.setType(type);
                            eventSubProcessNode.addEvent(eventTypeFilter);
                            eventSubProcessNode.addEvent("variableChanged");
                            ((StartNode)subNode).setCondition(context -> (Boolean)MVEL.executeExpression((Object)constraintTrigger.getConstraint(), (Map)context.getProcessInstance().getVariables()));
                        }
                    }
                }
                this.postProcessNodes(process, (NodeContainer)node);
                continue;
            }
            if (node instanceof EndNode) {
                this.handleIntermediateOrEndThrowCompensationEvent((ExtendedNodeImpl)((EndNode)node));
                continue;
            }
            if (node instanceof ActionNode) {
                this.handleIntermediateOrEndThrowCompensationEvent((ExtendedNodeImpl)((ActionNode)node));
                continue;
            }
            if (!(node instanceof EventNode) || (eventNode = (EventNode)node) instanceof BoundaryEventNode || eventNode.getDefaultIncomingConnections().size() != 0) continue;
            throw new IllegalArgumentException("Event node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection");
        }
        for (Node node : container.getNodes()) {
            FaultNode faultNode;
            if (!(node instanceof FaultNode) || !eventSubProcessHandlers.contains((faultNode = (FaultNode)node).getFaultName())) continue;
            faultNode.setTerminateParent(false);
        }
    }

    private void assignLanes(NodeContainer nodeContainer, Map<String, String> laneMapping) {
        for (Node node : nodeContainer.getNodes()) {
            String lane = null;
            String uniqueId = (String)node.getMetaData().get("UniqueId");
            lane = uniqueId != null ? laneMapping.get(uniqueId) : laneMapping.get(XmlBPMNProcessDumper.getUniqueNodeId(node));
            if (lane != null) {
                ((NodeImpl)node).setMetaData("Lane", (Object)lane);
                if (node instanceof HumanTaskNode) {
                    ((HumanTaskNode)node).setSwimlane(lane);
                }
            }
            if (!(node instanceof NodeContainer)) continue;
            this.assignLanes((NodeContainer)node, laneMapping);
        }
    }

    private static Constraint buildConstraint(SequenceFlow connection, NodeImpl node) {
        if (connection.getExpression() == null) {
            return null;
        }
        ConstraintImpl constraint = new ConstraintImpl();
        String defaultConnection = (String)node.getMetaData("Default");
        if (defaultConnection != null && defaultConnection.equals(connection.getId())) {
            constraint.setDefault(true);
        }
        if (connection.getName() != null) {
            constraint.setName(connection.getName());
        } else {
            constraint.setName("");
        }
        if (connection.getType() != null) {
            constraint.setType(connection.getType());
        } else {
            constraint.setType("code");
        }
        if (connection.getLanguage() != null) {
            constraint.setDialect(connection.getLanguage());
        }
        if (connection.getExpression() != null) {
            constraint.setConstraint(connection.getExpression());
        }
        constraint.setPriority(connection.getPriority());
        return constraint;
    }

    protected static void addCompensationScope(ExecutableProcess process, Node node, NodeContainer parentContainer, String compensationHandlerId) {
        process.getMetaData().put("Compensation", true);
        assert (parentContainer instanceof ContextContainer) : "Expected parent node to be a CompositeContextNode, not a " + parentContainer.getClass().getSimpleName();
        ContextContainer contextContainer = (ContextContainer)parentContainer;
        CompensationScope scope = null;
        boolean addScope = false;
        if (contextContainer.getContexts("CompensationScope") == null) {
            addScope = true;
        } else {
            scope = (CompensationScope)contextContainer.getContexts("CompensationScope").get(0);
            if (scope == null) {
                addScope = true;
            }
        }
        if (addScope) {
            scope = new CompensationScope();
            contextContainer.addContext((Context)scope);
            contextContainer.setDefaultContext((Context)scope);
            scope.setContextContainer(contextContainer);
        }
        CompensationHandler handler = new CompensationHandler();
        handler.setNode(node);
        if (scope.getExceptionHandler(compensationHandlerId) != null) {
            throw new IllegalArgumentException("More than one compensation handler per node (" + compensationHandlerId + ") is not supported!");
        }
        scope.setExceptionHandler(compensationHandlerId, (ExceptionHandler)handler);
    }

    protected void handleIntermediateOrEndThrowCompensationEvent(ExtendedNodeImpl throwEventNode) {
        if (throwEventNode.getMetaData("compensation-activityRef") != null) {
            String activityRef = (String)throwEventNode.getMetaData().remove("compensation-activityRef");
            NodeContainer nodeParent = throwEventNode.getParentContainer();
            if (nodeParent instanceof EventSubProcessNode) {
                boolean compensationEventSubProcess = false;
                List startTriggers = ((EventSubProcessNode)nodeParent).findStartNode().getTriggers();
                block0: for (Trigger trigger : startTriggers) {
                    if (!(trigger instanceof EventTrigger)) continue;
                    for (EventFilter filter : ((EventTrigger)trigger).getEventFilters()) {
                        if (!((EventTypeFilter)filter).getType().equals("Compensation")) continue;
                        compensationEventSubProcess = true;
                        break block0;
                    }
                }
                if (compensationEventSubProcess) {
                    nodeParent = ((NodeImpl)nodeParent).getParentContainer();
                }
            }
            String parentId = nodeParent instanceof ExecutableProcess ? ((ExecutableProcess)nodeParent).getId() : (String)((NodeImpl)nodeParent).getMetaData("UniqueId");
            Object compensationEvent = activityRef.length() == 0 ? "implicit:" + parentId : activityRef;
            throwEventNode.setMetaData("CompensationEvent", compensationEvent);
            ConsequenceAction compensationAction = new ConsequenceAction("java", "");
            compensationAction.setMetaData("Action", (Object)new ProcessInstanceCompensationAction((String)compensationEvent));
            if (throwEventNode instanceof ActionNode) {
                ((ActionNode)throwEventNode).setAction((ProcessAction)compensationAction);
            } else if (throwEventNode instanceof EndNode) {
                ArrayList<ConsequenceAction> actions = new ArrayList<ConsequenceAction>();
                actions.add(compensationAction);
                ((EndNode)throwEventNode).setActions("onEntry", actions);
            }
            throwEventNode.setMetaData("TriggerType", (Object)"Compensation");
        }
    }

    protected String findVariable(String variableName, VariableScope variableScope) {
        if (variableName == null) {
            return null;
        }
        return variableScope.getVariables().stream().filter(v -> v.matchByIdOrName(variableName)).map(v -> v.getName()).findFirst().orElse(variableName);
    }

    public static ConsequenceAction createJavaAction(Action action) {
        ConsequenceAction consequenceAction = new ConsequenceAction("java", "");
        consequenceAction.setMetaData("Action", (Object)action);
        return consequenceAction;
    }

    protected void processTags(WorkflowProcess process) {
        String tags = (String)process.getMetaData().get("tags");
        ArrayList<Object> tagDefinitions = new ArrayList<Object>();
        if (tags != null) {
            String[] tagList = tags.split(",");
            int counter = 0;
            for (String tag : tagList) {
                boolean isExpression = PatternConstants.PARAMETER_MATCHER.matcher(tag).matches();
                if (isExpression) {
                    tagDefinitions.add(new FunctionTagDefinition(String.valueOf(++counter), tag, (exp, vars) -> {
                        HashMap<String, Object> replacements = new HashMap<String, Object>();
                        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher((CharSequence)exp);
                        while (matcher.find()) {
                            String paramName = matcher.group(1);
                            Object value = MVEL.executeExpression((Object)MVEL.compileExpression((String)paramName), (Map)vars.getVariables());
                            replacements.put(paramName, value);
                        }
                        for (Map.Entry replacement : replacements.entrySet()) {
                            exp = exp.replace("#{" + (String)replacement.getKey() + "}", replacement.getValue().toString());
                        }
                        return exp;
                    }));
                    continue;
                }
                tagDefinitions.add(new StaticTagDefinition(String.valueOf(++counter), tag));
            }
        }
        ((io.automatiko.engine.workflow.base.core.Process)process).setTagDefinitions(tagDefinitions);
    }
}

