/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2;

import io.automatiko.engine.api.Model;
import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.definition.process.NodeContainer;
import io.automatiko.engine.api.definition.process.Process;
import io.automatiko.engine.api.io.Resource;
import io.automatiko.engine.api.runtime.process.EventListener;
import io.automatiko.engine.api.runtime.process.WorkflowProcessInstance;
import io.automatiko.engine.api.workflow.ProcessConfig;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.workflow.AbstractProcess;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.bpmn2.BpmnProcessCompiler;
import io.automatiko.engine.workflow.bpmn2.BpmnProcessInstance;
import io.automatiko.engine.workflow.bpmn2.BpmnVariables;
import io.automatiko.engine.workflow.compiler.xml.SemanticModule;
import io.automatiko.engine.workflow.process.core.WorkflowProcess;
import io.automatiko.engine.workflow.process.core.node.SubProcessNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class BpmnProcess
extends AbstractProcess<BpmnVariables> {
    private static BpmnProcessCompiler COMPILER = new BpmnProcessCompiler(new SemanticModule[0]);

    public BpmnProcess(Process p) {
        this.process = p;
    }

    public BpmnProcess(Process p, ProcessConfig config) {
        super(config);
        this.process = p;
    }

    public ProcessInstance<BpmnVariables> createInstance(Model m) {
        BpmnVariables variables = this.createModel();
        variables.fromMap(m.toMap());
        return new BpmnProcessInstance((AbstractProcess<BpmnVariables>)this, variables, this.createProcessRuntime());
    }

    public ProcessInstance<BpmnVariables> createInstance() {
        return new BpmnProcessInstance((AbstractProcess<BpmnVariables>)this, this.createModel(), this.createProcessRuntime());
    }

    public ProcessInstance<BpmnVariables> createInstance(String businessKey, BpmnVariables variables) {
        BpmnVariables variablesModel = this.createModel();
        variablesModel.fromMap(variables.toMap());
        return new BpmnProcessInstance((AbstractProcess<BpmnVariables>)this, variablesModel, businessKey, this.createProcessRuntime());
    }

    public ProcessInstance<BpmnVariables> createInstance(BpmnVariables variables) {
        BpmnVariables variablesModel = this.createModel();
        variablesModel.fromMap(variables.toMap());
        return new BpmnProcessInstance((AbstractProcess<BpmnVariables>)this, variablesModel, this.createProcessRuntime());
    }

    public ProcessInstance<BpmnVariables> createInstance(WorkflowProcessInstance wpi, BpmnVariables model) {
        return new BpmnProcessInstance((AbstractProcess<BpmnVariables>)this, model, this.createProcessRuntime(), wpi);
    }

    public ProcessInstance<BpmnVariables> createReadOnlyInstance(WorkflowProcessInstance wpi, BpmnVariables model) {
        return new BpmnProcessInstance((AbstractProcess<BpmnVariables>)this, model, wpi);
    }

    public Process process() {
        return this.process;
    }

    public BpmnVariables createModel() {
        VariableScope variableScope = (VariableScope)((WorkflowProcess)this.process()).getDefaultContext("VariableScope");
        return new BpmnVariables(variableScope.getVariables(), new HashMap<String, Object>());
    }

    protected void registerListeners() {
        super.registerListeners();
        ArrayList<SubProcessNode> subprocessNodes = new ArrayList<SubProcessNode>();
        this.collectSubprocessNodes(subprocessNodes, (NodeContainer)this.process());
        for (SubProcessNode sp : subprocessNodes) {
            this.services.getSignalManager().addEventListener(sp.getProcessId(), (EventListener)this.completionEventListener);
        }
    }

    protected void collectSubprocessNodes(Collection<SubProcessNode> items, NodeContainer container) {
        for (Node node : container.getNodes()) {
            if (node instanceof SubProcessNode) {
                items.add((SubProcessNode)node);
                continue;
            }
            if (!(node instanceof NodeContainer)) continue;
            this.collectSubprocessNodes(items, (NodeContainer)node);
        }
    }

    public static void overrideCompiler(BpmnProcessCompiler compiler) {
        COMPILER = Objects.requireNonNull(compiler);
    }

    public static List<BpmnProcess> from(Resource ... resource) {
        return BpmnProcess.from(null, resource);
    }

    public static List<BpmnProcess> from(ProcessConfig config, Resource ... resources) {
        return COMPILER.from(config, resources);
    }

    public Process buildProcess() {
        return null;
    }
}

