/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Connection;
import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.workflow.bpmn2.core.Association;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractNodeHandler;
import io.automatiko.engine.workflow.bpmn2.xml.XmlBPMNProcessDumper;
import io.automatiko.engine.workflow.process.core.node.CompositeNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCompositeNodeHandler
extends AbstractNodeHandler {
    protected void visitConnectionsAndAssociations(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        List<Connection> connections = this.getSubConnections((CompositeNode)node);
        xmlDump.append("    <!-- connections -->" + EOL);
        for (Connection connection : connections) {
            XmlBPMNProcessDumper.INSTANCE.visitConnection(connection, xmlDump, metaDataType);
        }
        List associations = (List)node.getMetaData().get("BPMN.Associations");
        if (associations != null) {
            for (Association association : associations) {
                XmlBPMNProcessDumper.INSTANCE.visitAssociation(association, xmlDump);
            }
        }
    }

    protected List<Connection> getSubConnections(CompositeNode compositeNode) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (Node subNode : compositeNode.getNodes()) {
            if (subNode instanceof CompositeNode.CompositeNodeEnd) continue;
            for (Connection connection : subNode.getIncomingConnections("DEFAULT")) {
                if (connection.getFrom() instanceof CompositeNode.CompositeNodeStart) continue;
                connections.add(connection);
            }
        }
        return connections;
    }
}

