/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.runtime.process.DataTransformer;
import io.automatiko.engine.workflow.base.core.impl.DataTransformerRegistry;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractNodeHandler;
import io.automatiko.engine.workflow.bpmn2.xml.XmlBPMNProcessDumper;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.compiler.xml.XmlDumper;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.impl.ExtendedNodeImpl;
import io.automatiko.engine.workflow.process.core.node.Assignment;
import io.automatiko.engine.workflow.process.core.node.DataAssociation;
import io.automatiko.engine.workflow.process.core.node.ForEachNode;
import io.automatiko.engine.workflow.process.core.node.RuleSetNode;
import io.automatiko.engine.workflow.process.core.node.Transformation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BusinessRuleTaskHandler
extends AbstractNodeHandler {
    private static final String NAMESPACE_PROP = "namespace";
    private static final String MODEL_PROP = "model";
    private static final String DECISION_PROP = "decision";
    private static final String DECISION_SERVICE_PROP = "decisionService";
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();

    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        return new RuleSetNode();
    }

    public Class generateNodeFor() {
        return RuleSetNode.class;
    }

    @Override
    protected void handleNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        String language = element.getAttribute("implementation");
        if (language == null || language.equalsIgnoreCase("##unspecified") || language.isEmpty()) {
            language = "http://www.jboss.org/drools/dmn";
        }
        ruleSetNode.setLanguage(language);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs, this.dataInputTypes, this.dataOutputTypes);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, ruleSetNode, this.dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, ruleSetNode, this.dataOutputs);
        }
        if (language.equals("http://www.jboss.org/drools/dmn")) {
            String namespace = (String)ruleSetNode.removeParameter(NAMESPACE_PROP);
            String model = (String)ruleSetNode.removeParameter(MODEL_PROP);
            String decision = (String)ruleSetNode.removeParameter(DECISION_PROP);
            String decisionService = (String)ruleSetNode.removeParameter(DECISION_SERVICE_PROP);
            ruleSetNode.setRuleType((RuleSetNode.RuleType)RuleSetNode.RuleType.decision((String)namespace, (String)model, (String)(decisionService != null ? decisionService : decision), (decisionService != null ? 1 : 0) != 0));
        }
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onExit");
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        this.writeNode("businessRuleTask", (io.automatiko.engine.workflow.process.core.Node)ruleSetNode, xmlDump, metaDataType);
        RuleSetNode.RuleType ruleType = ruleSetNode.getRuleType();
        if (ruleType != null) {
            xmlDump.append("g:ruleFlowGroup=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(ruleType.getName()) + "\" " + EOL);
        }
        xmlDump.append(" implementation=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(ruleSetNode.getLanguage()) + "\" >" + EOL);
        this.writeExtensionElements((io.automatiko.engine.workflow.process.core.Node)ruleSetNode, xmlDump);
        this.writeIO(ruleSetNode, xmlDump);
        this.endNode("businessRuleTask", xmlDump);
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, RuleSetNode ruleSetNode, Map<String, String> dataInputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            ArrayList<String> sources = new ArrayList<String>();
            sources.add(subNode.getTextContent());
            subNode = subNode.getNextSibling();
            while ("sourceRef".equals(subNode.getNodeName())) {
                sources.add(subNode.getTextContent());
                subNode = subNode.getNextSibling();
            }
            String target = subNode.getTextContent();
            Transformation transformation = null;
            if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
                String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
                String expression = subNode.getTextContent();
                DataTransformer transformer = this.transformerRegistry.find(lang);
                if (transformer == null) {
                    throw new IllegalArgumentException("No transformer registered for language " + lang);
                }
                transformation = new Transformation(lang, expression);
                subNode = subNode.getNextSibling();
            }
            LinkedList<Assignment> assignments = new LinkedList<Assignment>();
            while (subNode != null) {
                String expressionLang = ((Element)subNode).getAttribute("expressionLanguage");
                if (expressionLang == null || expressionLang.trim().isEmpty()) {
                    expressionLang = "XPath";
                }
                org.w3c.dom.Node ssubNode = subNode.getFirstChild();
                String from = ssubNode.getTextContent();
                String to = ssubNode.getNextSibling().getTextContent();
                assignments.add(new Assignment(expressionLang, from, to));
                subNode = subNode.getNextSibling();
            }
            ruleSetNode.addInAssociation(new DataAssociation(sources, dataInputs.get(target), assignments, transformation));
        } else {
            String to = subNode.getTextContent();
            if ((subNode = subNode.getNextSibling()) != null) {
                String text;
                org.w3c.dom.Node subSubNode = subNode.getFirstChild();
                NodeList nl = subSubNode.getChildNodes();
                if (nl.getLength() > 1) {
                    ruleSetNode.setParameter(dataInputs.get(to), (Object)subSubNode.getTextContent());
                    return;
                }
                if (nl.getLength() == 0) {
                    return;
                }
                Object result = null;
                org.w3c.dom.Node from = nl.item(0);
                result = from instanceof Text ? ((text = ((Text)from).getTextContent()).startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text) : nl.item(0);
                ruleSetNode.setParameter(dataInputs.get(to), result);
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, RuleSetNode ruleSetNode, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(subNode.getTextContent());
        subNode = subNode.getNextSibling();
        while ("sourceRef".equals(subNode.getNodeName())) {
            sources.add(subNode.getTextContent());
            subNode = subNode.getNextSibling();
        }
        String target = subNode.getTextContent();
        Transformation transformation = null;
        if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
            String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
            String expression = subNode.getTextContent();
            DataTransformer transformer = this.transformerRegistry.find(lang);
            if (transformer == null) {
                throw new IllegalArgumentException("No transformer registered for language " + lang);
            }
            transformation = new Transformation(lang, expression);
            subNode = subNode.getNextSibling();
        }
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        while (subNode != null) {
            String expressionLang = ((Element)subNode).getAttribute("expressionLanguage");
            if (expressionLang == null || expressionLang.trim().isEmpty()) {
                expressionLang = "XPath";
            }
            org.w3c.dom.Node ssubNode = subNode.getFirstChild();
            String from = ssubNode.getTextContent();
            String to = ssubNode.getNextSibling().getTextContent();
            assignments.add(new Assignment(expressionLang, from, to));
            subNode = subNode.getNextSibling();
        }
        ruleSetNode.addOutAssociation(new DataAssociation(sources.stream().map(source -> (String)dataOutputs.get(source)).collect(Collectors.toList()), target, assignments, transformation));
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        io.automatiko.engine.workflow.process.core.Node node = (io.automatiko.engine.workflow.process.core.Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        int uniqueIdGen = 1;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            ForEachNode forEachNode = new ForEachNode();
            forEachNode.setId(node.getId());
            String uniqueId = (String)node.getMetaData().get("UniqueId");
            forEachNode.setMetaData("UniqueId", (Object)uniqueId);
            node.setMetaData("UniqueId", (Object)(uniqueId + ":" + uniqueIdGen++));
            forEachNode.addNode((Node)node);
            forEachNode.linkIncomingConnections("DEFAULT", node.getId(), "DEFAULT");
            forEachNode.linkOutgoingConnections(node.getId(), "DEFAULT", "DEFAULT");
            forEachNode.setSequential(Boolean.parseBoolean(((Element)xmlNode).getAttribute("isSequential")));
            io.automatiko.engine.workflow.process.core.Node orignalNode = node;
            node = forEachNode;
            this.handleForEachNode(node, element, uri, localName, parser);
            if (!(orignalNode instanceof RuleSetNode)) break;
            this.adjustNodeConfiguration(orignalNode, forEachNode);
            break;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected void adjustNodeConfiguration(io.automatiko.engine.workflow.process.core.Node orignalNode, ForEachNode forEachNode) {
        List inputs = ((RuleSetNode)orignalNode).adjustInMapping(forEachNode.getCollectionExpression());
        List outputs = ((RuleSetNode)orignalNode).adjustOutMapping(forEachNode.getOutputCollectionExpression());
        if (inputs != null) {
            forEachNode.addInAssociation(inputs);
        }
        if (outputs != null) {
            forEachNode.addOutAssociation(outputs);
        }
    }

    protected void handleForEachNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) {
        ForEachNode forEachNode = (ForEachNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, this.inputAssociation);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, this.outputAssociation);
                continue;
            }
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            this.readMultiInstanceLoopCharacteristics(xmlNode, forEachNode, parser);
        }
    }

    protected void writeIO(RuleSetNode ruleSetNode, StringBuilder xmlDump) {
        xmlDump.append("      <ioSpecification>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Output\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        xmlDump.append("        <inputSet>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        xmlDump.append("        </inputSet>" + EOL);
        xmlDump.append("        <outputSet>" + EOL);
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</dataOutputRefs>" + EOL);
        }
        xmlDump.append("        </outputSet>" + EOL);
        xmlDump.append("      </ioSpecification>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL + "        <assignment>" + EOL + "          <from xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)entry.getValue().toString()) + "</from>" + EOL + "          <to xsi:type=\"tFormalExpression\">" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</to>" + EOL + "        </assignment>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</sourceRef>" + EOL + "        <targetRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
    }
}

