/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.workflow.datatype.DataType;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.ObjectDataType;
import io.automatiko.engine.workflow.bpmn2.core.DataStore;
import io.automatiko.engine.workflow.bpmn2.core.Definitions;
import io.automatiko.engine.workflow.bpmn2.core.Error;
import io.automatiko.engine.workflow.bpmn2.core.Escalation;
import io.automatiko.engine.workflow.bpmn2.core.Interface;
import io.automatiko.engine.workflow.bpmn2.core.ItemDefinition;
import io.automatiko.engine.workflow.bpmn2.core.Message;
import io.automatiko.engine.workflow.bpmn2.core.Resource;
import io.automatiko.engine.workflow.bpmn2.core.Signal;
import io.automatiko.engine.workflow.compiler.util.ClassUtils;
import io.automatiko.engine.workflow.compiler.xml.BaseAbstractHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.Handler;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataStoreHandler
extends BaseAbstractHandler
implements Handler {
    public DataStoreHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Definitions.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(ItemDefinition.class);
            this.validPeers.add(Resource.class);
            this.validPeers.add(Message.class);
            this.validPeers.add(Interface.class);
            this.validPeers.add(Escalation.class);
            this.validPeers.add(Error.class);
            this.validPeers.add(Signal.class);
            this.validPeers.add(DataStore.class);
            this.validPeers.add(ExecutableProcess.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        ItemDefinition itemDefinition;
        parser.startElementBuilder(localName, attrs);
        DataStore store = new DataStore();
        store.setId(attrs.getValue("id"));
        store.setName(attrs.getValue("name"));
        String itemSubjectRef = attrs.getValue("itemSubjectRef");
        store.setItemSubjectRef(itemSubjectRef);
        Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        String localItemSubjectRef = itemSubjectRef.substring(itemSubjectRef.indexOf(":") + 1);
        ObjectDataType dataType = new ObjectDataType();
        if (itemDefinitions != null && (itemDefinition = (ItemDefinition)itemDefinitions.get(localItemSubjectRef)) != null) {
            dataType = new ObjectDataType(ClassUtils.constructClass((String)itemDefinition.getStructureRef(), (ClassLoader)parser.getClassLoader()), itemDefinition.getStructureRef());
        }
        store.setType((DataType)dataType);
        Definitions parent = (Definitions)parser.getParent();
        List<DataStore> dataStores = parent.getDataStores();
        if (dataStores == null) {
            dataStores = new ArrayList<DataStore>();
            parent.setDataStores(dataStores);
        }
        dataStores.add(store);
        return store;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        return parser.getCurrent();
    }

    public Class<?> generateNodeFor() {
        return DataStore.class;
    }
}

