/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.workflow.base.instance.impl.Action;
import io.automatiko.engine.workflow.base.instance.impl.actions.HandleMessageAction;
import io.automatiko.engine.workflow.base.instance.impl.actions.SignalProcessInstanceAction;
import io.automatiko.engine.workflow.bpmn2.core.Error;
import io.automatiko.engine.workflow.bpmn2.core.Escalation;
import io.automatiko.engine.workflow.bpmn2.core.Message;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractNodeHandler;
import io.automatiko.engine.workflow.bpmn2.xml.ProcessHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.impl.ConsequenceAction;
import io.automatiko.engine.workflow.process.core.node.EndNode;
import io.automatiko.engine.workflow.process.core.node.FaultNode;
import io.automatiko.engine.workflow.process.core.node.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EndEventHandler
extends AbstractNodeHandler {
    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        EndNode node = new EndNode();
        node.setTerminate(false);
        return node;
    }

    public Class generateNodeFor() {
        return EndNode.class;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        io.automatiko.engine.workflow.process.core.Node node = (io.automatiko.engine.workflow.process.core.Node)parser.getCurrent();
        super.handleNode(node, element, uri, localName, parser);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("terminateEventDefinition".equals(nodeName)) {
                this.handleTerminateNode(node, element, uri, localName, parser);
                break;
            }
            if ("signalEventDefinition".equals(nodeName)) {
                this.handleSignalNode(node, element, uri, localName, parser);
                continue;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                this.handleMessageNode(node, element, uri, localName, parser);
                continue;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                FaultNode faultNode = new FaultNode();
                faultNode.setId(node.getId());
                faultNode.setName(node.getName());
                faultNode.setTerminateParent(true);
                faultNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = faultNode;
                super.handleNode(node, element, uri, localName, parser);
                this.handleErrorNode(node, element, uri, localName, parser);
                break;
            }
            if ("escalationEventDefinition".equals(nodeName)) {
                FaultNode faultNode = new FaultNode();
                faultNode.setId(node.getId());
                faultNode.setName(node.getName());
                faultNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = faultNode;
                super.handleNode(node, element, uri, localName, parser);
                this.handleEscalationNode(node, element, uri, localName, parser);
                break;
            }
            if (!"compensateEventDefinition".equals(nodeName)) continue;
            this.handleThrowCompensationEventNode(node, element, uri, localName, parser);
            break;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    public void handleTerminateNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ((EndNode)node).setTerminate(true);
        EndNode endNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"terminateEventDefinition".equals(nodeName)) continue;
            String scope = ((Element)xmlNode).getAttribute("scope");
            if ("process".equalsIgnoreCase(scope)) {
                endNode.setScope(1);
                continue;
            }
            endNode.setScope(0);
        }
    }

    public void handleSignalNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        EndNode endNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String inputName = ((Element)xmlNode).getAttribute("name");
                this.dataInputs.put(id, inputName);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readEndDataInputAssociation(xmlNode, endNode);
                continue;
            }
            if (!"signalEventDefinition".equals(nodeName)) continue;
            Object signalName = ((Element)xmlNode).getAttribute("signalRef");
            String variable = (String)endNode.getMetaData("MappingVariable");
            signalName = this.checkSignalAndConvertToRealSignalNam(parser, (String)signalName);
            endNode.setMetaData("EventType", (Object)"signal");
            endNode.setMetaData("Ref", signalName);
            endNode.setMetaData("Variable", (Object)variable);
            if (this.dataInputs.containsValue("async")) {
                signalName = "ASYNC-" + (String)signalName;
            }
            ConsequenceAction action = ProcessHandler.createJavaAction((Action)new SignalProcessInstanceAction((String)signalName, variable, (String)endNode.getMetaData("customScope"), (Transformation)endNode.getMetaData().get("Transformation")));
            ArrayList<ConsequenceAction> actions = new ArrayList<ConsequenceAction>();
            actions.add(action);
            endNode.setActions("onEntry", actions);
        }
    }

    public void handleMessageNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        EndNode endNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readEndDataInputAssociation(xmlNode, endNode);
                continue;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new IllegalArgumentException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new IllegalArgumentException("Could not find message " + messageRef);
            }
            String variable = (String)endNode.getMetaData("MappingVariable");
            endNode.setMetaData("MessageType", (Object)message.getType());
            endNode.setMetaData("TriggerType", (Object)"ProduceMessage");
            endNode.setMetaData("TriggerRef", (Object)message.getName());
            endNode.setMetaData("topicExpression", message.getMetaData().get("topicExpression"));
            endNode.setMetaData("connector", message.getMetaData().getOrDefault("connector", endNode.getMetaData("connector")));
            endNode.setMetaData("topic", message.getMetaData().getOrDefault("topic", endNode.getMetaData("topic")));
            ArrayList<ConsequenceAction> actions = new ArrayList<ConsequenceAction>();
            ConsequenceAction action = ProcessHandler.createJavaAction((Action)new HandleMessageAction(message.getType(), variable));
            actions.add(action);
            endNode.setActions("onEntry", actions);
        }
    }

    protected void readEndDataInputAssociation(org.w3c.dom.Node xmlNode, EndNode endNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String eventVariable = subNode.getTextContent();
            if (eventVariable != null && eventVariable.trim().length() > 0) {
                if (this.dataInputs.containsKey(eventVariable)) {
                    eventVariable = (String)this.dataInputs.get(eventVariable);
                }
                endNode.setMetaData("MappingVariable", (Object)eventVariable);
            }
        } else if ((subNode = subNode.getNextSibling()) != null) {
            String text;
            org.w3c.dom.Node subSubNode = subNode.getFirstChild();
            NodeList nl = subSubNode.getChildNodes();
            if (nl.getLength() > 1) {
                endNode.setMetaData("MappingVariable", (Object)subSubNode.getTextContent());
                return;
            }
            if (nl.getLength() == 0) {
                return;
            }
            Object result = null;
            org.w3c.dom.Node from = nl.item(0);
            result = from instanceof Text ? ((text = ((Text)from).getTextContent()).startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text) : nl.item(0);
            endNode.setMetaData("MappingVariable", (Object)("\"" + result + "\""));
        }
    }

    public void handleErrorNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        FaultNode faultNode = (FaultNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String errorRef;
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readFaultDataInputAssociation(xmlNode, faultNode);
                continue;
            }
            if (!"errorEventDefinition".equals(nodeName) || (errorRef = ((Element)xmlNode).getAttribute("errorRef")) == null || errorRef.trim().length() <= 0) continue;
            List errors = (List)((ProcessBuildData)parser.getData()).getMetaData("Errors");
            if (errors == null) {
                throw new IllegalArgumentException("No errors found");
            }
            Error error = null;
            for (Error listError : errors) {
                if (!errorRef.equals(listError.getId())) continue;
                error = listError;
                break;
            }
            if (error == null) {
                throw new IllegalArgumentException("Could not find error " + errorRef);
            }
            faultNode.setFaultName(error.getErrorCode());
            faultNode.setTerminateParent(true);
        }
    }

    public void handleEscalationNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        FaultNode faultNode = (FaultNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readFaultDataInputAssociation(xmlNode, faultNode);
                continue;
            }
            if (!"escalationEventDefinition".equals(nodeName)) continue;
            String escalationRef = ((Element)xmlNode).getAttribute("escalationRef");
            if (escalationRef != null && escalationRef.trim().length() > 0) {
                Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Escalations");
                if (escalations == null) {
                    throw new IllegalArgumentException("No escalations found");
                }
                Escalation escalation = (Escalation)escalations.get(escalationRef);
                if (escalation == null) {
                    throw new IllegalArgumentException("Could not find escalation " + escalationRef);
                }
                faultNode.setFaultName(escalation.getEscalationCode());
                continue;
            }
            throw new IllegalArgumentException("End events throwing an escalation must throw *specific* escalations (and not general ones).");
        }
    }

    protected void readFaultDataInputAssociation(org.w3c.dom.Node xmlNode, FaultNode faultNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String faultVariable = subNode.getTextContent();
        faultNode.setFaultVariable(faultVariable);
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

