/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.runtime.process.DataTransformer;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.base.core.impl.DataTransformerRegistry;
import io.automatiko.engine.workflow.base.instance.impl.Action;
import io.automatiko.engine.workflow.base.instance.impl.actions.HandleEscalationAction;
import io.automatiko.engine.workflow.base.instance.impl.actions.HandleMessageAction;
import io.automatiko.engine.workflow.base.instance.impl.actions.SignalProcessInstanceAction;
import io.automatiko.engine.workflow.bpmn2.core.Escalation;
import io.automatiko.engine.workflow.bpmn2.core.IntermediateLink;
import io.automatiko.engine.workflow.bpmn2.core.Message;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractNodeHandler;
import io.automatiko.engine.workflow.bpmn2.xml.ProcessHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.ProcessAction;
import io.automatiko.engine.workflow.process.core.impl.ConsequenceAction;
import io.automatiko.engine.workflow.process.core.node.ActionNode;
import io.automatiko.engine.workflow.process.core.node.CompositeNode;
import io.automatiko.engine.workflow.process.core.node.ThrowLinkNode;
import io.automatiko.engine.workflow.process.core.node.Transformation;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IntermediateThrowEventHandler
extends AbstractNodeHandler {
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();
    public static final String LINK_NAME = "linkName";
    public static final String LINK_SOURCE = "source";
    public static final String LINK_TARGET = "target";
    private static final String MAPPING_VARIABLE_KEY = "MappingVariable";
    private static final String TRANSFORMATION_KEY = "Transformation";

    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        return new ActionNode();
    }

    public Class generateNodeFor() {
        return io.automatiko.engine.workflow.process.core.Node.class;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        ActionNode node = (ActionNode)parser.getCurrent();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("signalEventDefinition".equals(nodeName)) {
                this.handleSignalNode((io.automatiko.engine.workflow.process.core.Node)node, element, uri, localName, parser);
                break;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                this.handleMessageNode((io.automatiko.engine.workflow.process.core.Node)node, element, uri, localName, parser);
                break;
            }
            if ("escalationEventDefinition".equals(nodeName)) {
                this.handleEscalationNode((io.automatiko.engine.workflow.process.core.Node)node, element, uri, localName, parser);
                break;
            }
            if ("compensateEventDefinition".equals(nodeName)) {
                this.handleThrowCompensationEventNode((io.automatiko.engine.workflow.process.core.Node)node, element, uri, localName, parser);
                break;
            }
            if (!"linkEventDefinition".equals(nodeName)) continue;
            ThrowLinkNode linkNode = new ThrowLinkNode();
            linkNode.setId(node.getId());
            this.handleLinkNode(element, (io.automatiko.engine.workflow.process.core.Node)linkNode, xmlNode, parser);
            NodeContainer nodeContainer = (NodeContainer)parser.getParent();
            nodeContainer.addNode((Node)linkNode);
            ((ProcessBuildData)parser.getData()).addNode((io.automatiko.engine.workflow.process.core.Node)node);
            return linkNode;
        }
        if (node.getAction() == null) {
            node.setAction((ProcessAction)new ConsequenceAction("mvel", ""));
            node.setMetaData("NodeType", (Object)"IntermediateThrowEvent-None");
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        return node;
    }

    protected void handleLinkNode(Element element, io.automatiko.engine.workflow.process.core.Node node, org.w3c.dom.Node xmlLinkNode, ExtensibleXmlParser parser) {
        List<IntermediateLink> links;
        node.setName(element.getAttribute("name"));
        NamedNodeMap linkAttr = xmlLinkNode.getAttributes();
        String name = linkAttr.getNamedItem("name").getNodeValue();
        String id = element.getAttribute("id");
        node.setMetaData("UniqueId", (Object)id);
        node.setMetaData(LINK_NAME, (Object)name);
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        IntermediateLink aLink = new IntermediateLink();
        aLink.setName(name);
        aLink.setUniqueId(id);
        for (org.w3c.dom.Node xmlNode = xmlLinkNode.getFirstChild(); null != xmlNode; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (LINK_TARGET.equals(nodeName)) {
                String target = xmlNode.getTextContent();
                node.setMetaData(LINK_TARGET, (Object)target);
            }
            if (!LINK_SOURCE.equals(nodeName)) continue;
            String source = xmlNode.getTextContent();
            ArrayList<String> sources = (ArrayList<String>)node.getMetaData().get(LINK_SOURCE);
            if (null == sources) {
                sources = new ArrayList<String>();
            }
            aLink.addSource(source);
            sources.add(source);
            node.setMetaData(LINK_SOURCE, sources);
        }
        aLink.configureThrow();
        if (nodeContainer instanceof ExecutableProcess) {
            ExecutableProcess process = (ExecutableProcess)nodeContainer;
            links = (ArrayList<IntermediateLink>)process.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList<IntermediateLink>();
            }
            links.add(aLink);
            process.setMetaData("BPMN.ThrowLinks", links);
        } else if (nodeContainer instanceof CompositeNode) {
            CompositeNode subprocess = (CompositeNode)nodeContainer;
            links = (List)subprocess.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList();
            }
            links.add(aLink);
            subprocess.setMetaData("BPMN.ThrowLinks", links);
        }
    }

    public void handleSignalNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode = (ActionNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String inputName = ((Element)xmlNode).getAttribute("name");
                this.dataInputs.put(id, inputName);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, actionNode, parser);
                continue;
            }
            if (!"signalEventDefinition".equals(nodeName)) continue;
            Object signalName = ((Element)xmlNode).getAttribute("signalRef");
            String variable = this.findVariable((String)actionNode.getMetaData(MAPPING_VARIABLE_KEY), parser);
            signalName = this.checkSignalAndConvertToRealSignalNam(parser, (String)signalName);
            actionNode.setMetaData("EventType", (Object)"signal");
            actionNode.setMetaData("Ref", signalName);
            actionNode.setMetaData("Variable", (Object)variable);
            actionNode.setMetaData("TriggerType", (Object)"Signal");
            if (this.dataInputs.containsValue("async")) {
                signalName = "ASYNC-" + (String)signalName;
            }
            ConsequenceAction action = ProcessHandler.createJavaAction((Action)new SignalProcessInstanceAction((String)signalName, variable, (String)actionNode.getMetaData("customScope"), (Transformation)actionNode.getMetaData().get(TRANSFORMATION_KEY)));
            actionNode.setAction((ProcessAction)action);
        }
    }

    public void handleMessageNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode = (ActionNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String inputName = ((Element)xmlNode).getAttribute("name");
                this.dataInputs.put(id, inputName);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, actionNode, parser);
                continue;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new IllegalArgumentException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new IllegalArgumentException("Could not find message " + messageRef);
            }
            String variable = (String)actionNode.getMetaData(MAPPING_VARIABLE_KEY);
            Variable v = (Variable)((ProcessBuildData)parser.getData()).getMetaData("Variable");
            if (v != null) {
                variable = (String)v.getMetaData(variable);
            }
            actionNode.setMetaData("MessageType", (Object)message.getType());
            actionNode.setMetaData("TriggerType", (Object)"ProduceMessage");
            actionNode.setMetaData("TriggerRef", (Object)message.getName());
            actionNode.setMetaData("topicExpression", message.getMetaData().get("topicExpression"));
            actionNode.setMetaData("connector", message.getMetaData().getOrDefault("connector", actionNode.getMetaData("connector")));
            actionNode.setMetaData("topic", message.getMetaData().getOrDefault("topic", actionNode.getMetaData("topic")));
            ConsequenceAction action = ProcessHandler.createJavaAction((Action)new HandleMessageAction(message.getType(), variable, (Transformation)actionNode.getMetaData().get(TRANSFORMATION_KEY)));
            actionNode.setAction((ProcessAction)action);
        }
    }

    public void handleEscalationNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode = (ActionNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, actionNode, parser);
                continue;
            }
            if (!"escalationEventDefinition".equals(nodeName)) continue;
            String escalationRef = ((Element)xmlNode).getAttribute("escalationRef");
            if (escalationRef != null && escalationRef.trim().length() > 0) {
                Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Escalations");
                if (escalations == null) {
                    throw new IllegalArgumentException("No escalations found");
                }
                Escalation escalation = (Escalation)escalations.get(escalationRef);
                if (escalation == null) {
                    throw new IllegalArgumentException("Could not find escalation " + escalationRef);
                }
                String faultName = escalation.getEscalationCode();
                String variable = (String)actionNode.getMetaData(MAPPING_VARIABLE_KEY);
                ConsequenceAction action = ProcessHandler.createJavaAction((Action)new HandleEscalationAction(faultName, variable));
                actionNode.setAction((ProcessAction)action);
                actionNode.setMetaData("TriggerType", (Object)"Escalation");
                continue;
            }
            throw new IllegalArgumentException("General escalation is not yet supported");
        }
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, ActionNode actionNode, ExtensibleXmlParser parser) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String eventVariable = subNode.getTextContent();
            subNode = subNode.getNextSibling();
            String target = subNode.getTextContent();
            Transformation transformation = null;
            if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
                String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
                String expression = subNode.getTextContent();
                DataTransformer transformer = this.transformerRegistry.find(lang);
                if (transformer == null) {
                    throw new IllegalArgumentException("No transformer registered for language " + lang);
                }
                transformation = new Transformation(lang, expression, (String)this.dataInputs.get(target));
                actionNode.setMetaData(TRANSFORMATION_KEY, (Object)transformation);
            }
            if (eventVariable != null && eventVariable.trim().length() > 0) {
                if (this.dataInputs.containsKey(eventVariable)) {
                    eventVariable = (String)this.dataInputs.get(eventVariable);
                }
                actionNode.setMetaData(MAPPING_VARIABLE_KEY, (Object)this.findVariable(eventVariable, parser));
            }
        } else if ((subNode = subNode.getNextSibling()) != null) {
            String text;
            org.w3c.dom.Node subSubNode = subNode.getFirstChild();
            NodeList nl = subSubNode.getChildNodes();
            if (nl.getLength() > 1) {
                actionNode.setMetaData(MAPPING_VARIABLE_KEY, (Object)subSubNode.getTextContent());
                return;
            }
            if (nl.getLength() == 0) {
                return;
            }
            Object result = null;
            org.w3c.dom.Node from = nl.item(0);
            result = from instanceof Text ? ((text = ((Text)from).getTextContent()).startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text) : nl.item(0);
            actionNode.setMetaData(MAPPING_VARIABLE_KEY, (Object)("\"" + this.findVariable(result.toString(), parser) + "\""));
        }
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by action node handler");
    }
}

