/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.workflow.datatype.DataType;
import io.automatiko.engine.workflow.base.core.ValueObject;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.base.core.datatype.impl.type.StringDataType;
import io.automatiko.engine.workflow.bpmn2.core.Error;
import io.automatiko.engine.workflow.bpmn2.core.Lane;
import io.automatiko.engine.workflow.bpmn2.core.Message;
import io.automatiko.engine.workflow.bpmn2.core.SequenceFlow;
import io.automatiko.engine.workflow.compiler.xml.BaseAbstractHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.Handler;
import io.automatiko.engine.workflow.process.core.Node;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import java.util.HashSet;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MetaDataHandler
extends BaseAbstractHandler
implements Handler {
    public MetaDataHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Node.class);
            this.validParents.add(ExecutableProcess.class);
            this.validParents.add(Variable.class);
            this.validParents.add(SequenceFlow.class);
            this.validParents.add(Lane.class);
            this.validParents.add(Message.class);
            this.validParents.add(Error.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        Object parent = parser.getParent();
        String name = attrs.getValue("name");
        this.emptyAttributeCheck(localName, "name", name, parser);
        return new MetaDataWrapper(parent, name);
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        return null;
    }

    public Class generateNodeFor() {
        return MetaDataWrapper.class;
    }

    public class MetaDataWrapper
    implements ValueObject {
        private Object parent;
        private String name;

        public MetaDataWrapper(Object parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public Object getValue() {
            return this.getMetaData().get(this.name);
        }

        public void setValue(Object value) {
            this.getMetaData().put(this.name, value);
        }

        public Map<String, Object> getMetaData() {
            if (this.parent instanceof Node) {
                return ((Node)this.parent).getMetaData();
            }
            if (this.parent instanceof ExecutableProcess) {
                return ((ExecutableProcess)this.parent).getMetaData();
            }
            if (this.parent instanceof Variable) {
                return ((Variable)this.parent).getMetaData();
            }
            if (this.parent instanceof SequenceFlow) {
                return ((SequenceFlow)this.parent).getMetaData();
            }
            if (this.parent instanceof Lane) {
                return ((Lane)this.parent).getMetaData();
            }
            if (this.parent instanceof Message) {
                return ((Message)this.parent).getMetaData();
            }
            if (this.parent instanceof Error) {
                return ((Error)this.parent).getMetaData();
            }
            throw new IllegalArgumentException("Unknown parent " + this.parent);
        }

        public DataType getType() {
            return new StringDataType();
        }

        public void setType(DataType type) {
        }
    }
}

