/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2;

import io.automatiko.engine.api.event.process.DefaultProcessEventListener;
import io.automatiko.engine.api.event.process.ProcessEventListener;
import io.automatiko.engine.api.event.process.ProcessNodeTriggeredEvent;
import io.automatiko.engine.api.event.process.ProcessStartedEvent;
import io.automatiko.engine.api.event.process.ProcessVariableChangedEvent;
import io.automatiko.engine.api.workflow.ProcessConfig;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.base.core.impl.ProcessImpl;
import io.automatiko.engine.workflow.bpmn2.BpmnProcess;
import io.automatiko.engine.workflow.bpmn2.BpmnVariables;
import io.automatiko.engine.workflow.bpmn2.JbpmBpmn2TestCase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActivityTest
extends JbpmBpmn2TestCase {
    @Test
    public void testMinimalProcess() throws Exception {
        BpmnProcess process = this.create("BPMN2-MinimalProcess.bpmn2");
        ProcessInstance instance = process.createInstance(BpmnVariables.create());
        instance.start();
        Assertions.assertEquals((int)2, (int)instance.status());
    }

    @Test
    public void testMinimalProcessImplicit() throws Exception {
        BpmnProcess process = this.create("BPMN2-MinimalProcessImplicit.bpmn2");
        ProcessInstance instance = process.createInstance(BpmnVariables.create());
        instance.start();
        Assertions.assertEquals((int)2, (int)instance.status());
    }

    @Test
    public void testMinimalProcessMetaData() throws Exception {
        final ArrayList list1 = new ArrayList();
        final ArrayList list2 = new ArrayList();
        final ArrayList list3 = new ArrayList();
        final ArrayList list4 = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                String customTag2;
                ActivityTest.this.logger.debug("before node");
                Map metaData = event.getNodeInstance().getNode().getMetaData();
                for (Map.Entry entry : metaData.entrySet()) {
                    ActivityTest.this.logger.debug((String)entry.getKey() + " " + String.valueOf(entry.getValue()));
                }
                String customTag = (String)metaData.get("customTag");
                if (customTag != null) {
                    list1.add(customTag);
                }
                if ((customTag2 = (String)metaData.get("customTag2")) != null) {
                    list2.add(customTag2);
                }
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                ActivityTest.this.logger.debug("after variable");
                VariableScope variableScope = (VariableScope)((ProcessImpl)event.getProcessInstance().getProcess()).resolveContext("VariableScope", (Object)event.getVariableId());
                if (variableScope == null) {
                    return;
                }
                Map metaData = variableScope.findVariable(event.getVariableId()).getMetaData();
                for (Map.Entry entry : metaData.entrySet()) {
                    ActivityTest.this.logger.debug((String)entry.getKey() + " " + String.valueOf(entry.getValue()));
                }
                String customTag = (String)metaData.get("customTagVar");
                if (customTag != null) {
                    list3.add(customTag);
                }
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                ActivityTest.this.logger.debug("after process");
                Map metaData = event.getProcessInstance().getProcess().getMetaData();
                for (Map.Entry entry : metaData.entrySet()) {
                    ActivityTest.this.logger.debug((String)entry.getKey() + " " + String.valueOf(entry.getValue()));
                }
                String customTag = (String)metaData.get("customTagProcess");
                if (customTag != null) {
                    list4.add(customTag);
                }
            }
        };
        ProcessConfig config = this.config(new ProcessEventListener[]{listener});
        BpmnProcess process = this.create(config, "BPMN2-MinimalProcessMetaData.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "krisv");
        ProcessInstance instance = process.createInstance(BpmnVariables.create(params));
        instance.start();
        Assertions.assertEquals((int)2, (int)instance.status());
        Assertions.assertEquals((int)3, (int)list1.size());
        Assertions.assertEquals((int)2, (int)list2.size());
        Assertions.assertEquals((int)1, (int)list3.size());
        Assertions.assertEquals((int)1, (int)list4.size());
    }

    @Test
    public void testScriptTask() throws Exception {
        BpmnProcess process = this.create("BPMN2-ScriptTask.bpmn2");
        ProcessInstance instance = process.createInstance(BpmnVariables.create());
        instance.start();
        Assertions.assertEquals((int)2, (int)instance.status());
    }
}

