/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.definition.process.Process;
import io.automatiko.engine.api.event.process.ProcessEventListener;
import io.automatiko.engine.api.io.Resource;
import io.automatiko.engine.api.runtime.process.NodeInstance;
import io.automatiko.engine.api.runtime.process.NodeInstanceContainer;
import io.automatiko.engine.api.runtime.process.ProcessInstance;
import io.automatiko.engine.api.runtime.process.WorkItemHandler;
import io.automatiko.engine.api.runtime.process.WorkflowProcessInstance;
import io.automatiko.engine.api.uow.UnitOfWorkFactory;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.workflow.ProcessConfig;
import io.automatiko.engine.api.workflow.ProcessEventListenerConfig;
import io.automatiko.engine.api.workflow.VariableInitializer;
import io.automatiko.engine.api.workflow.WorkItemHandlerConfig;
import io.automatiko.engine.services.io.ClassPathResource;
import io.automatiko.engine.services.uow.CollectingUnitOfWorkFactory;
import io.automatiko.engine.services.uow.DefaultUnitOfWorkManager;
import io.automatiko.engine.workflow.DefaultProcessEventListenerConfig;
import io.automatiko.engine.workflow.DefaultWorkItemHandlerConfig;
import io.automatiko.engine.workflow.StaticProcessConfig;
import io.automatiko.engine.workflow.base.instance.InternalProcessRuntime;
import io.automatiko.engine.workflow.base.instance.ProcessRuntimeImpl;
import io.automatiko.engine.workflow.base.instance.context.variable.DefaultVariableInitializer;
import io.automatiko.engine.workflow.bpmn2.BpmnProcess;
import io.automatiko.engine.workflow.bpmn2.BpmnProcessCompiler;
import io.automatiko.engine.workflow.compiler.xml.SemanticModule;
import io.automatiko.engine.workflow.process.instance.impl.WorkflowProcessInstanceImpl;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=3000L, unit=TimeUnit.SECONDS)
public abstract class JbpmBpmn2TestCase {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BpmnProcessCompiler compiler = new BpmnProcessCompiler(new SemanticModule[0]);

    @BeforeEach
    protected void logTestStartAndSetup(TestInfo testInfo) {
        this.logger.info(" >>> {} <<<", (Object)testInfo.getDisplayName());
        System.setProperty("org.jbpm.signals.defaultscope", "default");
    }

    @AfterEach
    protected void logTestEndAndSetup(TestInfo testInfo) {
        this.logger.info("Finished {}", (Object)testInfo.getDisplayName());
        System.clearProperty("org.jbpm.signals.defaultscope");
    }

    protected InternalProcessRuntime createProcessRuntime(String string) {
        List processes = this.compiler.parse(new Resource[]{new ClassPathResource(string)});
        return new ProcessRuntimeImpl(processes.stream().collect(Collectors.toMap(Process::getId, p -> p)));
    }

    protected BpmnProcess create(String path) {
        return this.create(null, path);
    }

    protected BpmnProcess create(ProcessConfig config, String path) {
        List processes = BpmnProcess.from((ProcessConfig)config, (Resource[])new Resource[]{new ClassPathResource(path)});
        return (BpmnProcess)processes.get(0);
    }

    protected ProcessConfig config(WorkItemHandler ... handlers) {
        return this.config(Arrays.asList(handlers), Collections.emptyList());
    }

    protected ProcessConfig config(ProcessEventListener ... listeners) {
        return this.config(Collections.emptyList(), Arrays.asList(listeners));
    }

    protected ProcessConfig config(List<WorkItemHandler> handlers, List<ProcessEventListener> listeners) {
        DefaultWorkItemHandlerConfig handlerConfig = new DefaultWorkItemHandlerConfig();
        handlers.forEach(h -> handlerConfig.register(h.getName(), h));
        DefaultProcessEventListenerConfig listenerConfig = new DefaultProcessEventListenerConfig(new ProcessEventListener[0]);
        listeners.forEach(h -> listenerConfig.register(h));
        StaticProcessConfig config = new StaticProcessConfig((WorkItemHandlerConfig)handlerConfig, (ProcessEventListenerConfig)listenerConfig, (UnitOfWorkManager)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()), null, (VariableInitializer)new DefaultVariableInitializer(), null);
        return config;
    }

    @AfterEach
    public void clear() {
        this.clearHistory();
    }

    public void assertProcessInstanceCompleted(ProcessInstance processInstance) {
        Assertions.assertTrue((boolean)this.assertProcessInstanceState(2, processInstance), (String)"Process instance has not been completed.");
    }

    public void assertProcessInstanceAborted(ProcessInstance processInstance) {
        Assertions.assertTrue((boolean)this.assertProcessInstanceState(3, processInstance), (String)"Process instance has not been aborted.");
    }

    public void assertProcessInstanceActive(ProcessInstance processInstance) {
        Assertions.assertTrue((this.assertProcessInstanceState(1, processInstance) || this.assertProcessInstanceState(0, processInstance) ? 1 : 0) != 0, (String)"Process instance is not active.");
    }

    public void assertProcessInstanceFinished(ProcessInstance processInstance, InternalProcessRuntime processRuntime) {
        Assertions.assertNull((Object)processRuntime.getProcessInstance(processInstance.getId()), (String)"Process instance has not been finished.");
    }

    public void assertNodeActive(String processInstanceId, InternalProcessRuntime processRuntime, String ... name) {
        ArrayList<String> names = new ArrayList<String>();
        for (String n : name) {
            names.add(n);
        }
        ProcessInstance processInstance = processRuntime.getProcessInstance(processInstanceId);
        if (processInstance instanceof WorkflowProcessInstance) {
            this.assertNodeActive((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), names);
        }
        if (!names.isEmpty()) {
            Object s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = (String)s + ", " + (String)names.get(i);
            }
            Assertions.fail((String)("Node(s) not active: " + (String)s));
        }
    }

    private void assertNodeActive(NodeInstanceContainer container, List<String> names) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            String nodeName = nodeInstance.getNodeName();
            if (names.contains(nodeName)) {
                names.remove(nodeName);
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.assertNodeActive((NodeInstanceContainer)nodeInstance, names);
        }
    }

    public void assertNodeTriggered(String processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(processInstanceId, nodeNames);
        if (!names.isEmpty()) {
            Object s = names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = (String)s + ", " + names.get(i);
            }
            Assertions.fail((String)("Node(s) not executed: " + (String)s));
        }
    }

    public void assertNotNodeTriggered(String processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(processInstanceId, nodeNames);
        Assertions.assertTrue((boolean)Arrays.equals(names.toArray(), nodeNames));
    }

    public int getNumberOfNodeTriggered(long processInstanceId, String node) {
        int counter = 0;
        return counter;
    }

    public int getNumberOfProcessInstances(String processId) {
        int counter = 0;
        return counter;
    }

    protected boolean assertProcessInstanceState(int state, ProcessInstance processInstance) {
        return processInstance.getState() == state;
    }

    private List<String> getNotTriggeredNodes(String processInstanceId, String ... nodeNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : nodeNames) {
            names.add(nodeName);
        }
        return names;
    }

    protected List<String> getCompletedNodes(long processInstanceId) {
        ArrayList<String> names = new ArrayList<String>();
        return names;
    }

    protected void clearHistory() {
    }

    public void assertProcessVarExists(ProcessInstance process, String ... processVarNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : processVarNames) {
            names.add(nodeName);
        }
        for (String pvar : instance.getVariables().keySet()) {
            if (!names.contains(pvar)) continue;
            names.remove(pvar);
        }
        if (!names.isEmpty()) {
            Object s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = (String)s + ", " + (String)names.get(i);
            }
            Assertions.fail((String)("Process Variable(s) do not exist: " + (String)s));
        }
    }

    public String getProcessVarValue(ProcessInstance processInstance, String varName) {
        String actualValue = null;
        Object value = ((WorkflowProcessInstanceImpl)processInstance).getVariable(varName);
        if (value != null) {
            actualValue = value.toString();
        }
        return actualValue;
    }

    public void assertProcessVarValue(ProcessInstance processInstance, String varName, Object varValue) {
        String actualValue = this.getProcessVarValue(processInstance, varName);
        Assertions.assertEquals((Object)varValue, (Object)actualValue, (String)("Variable " + varName + " value misatch!"));
    }

    public void assertNodeExists(ProcessInstance process, String ... nodeNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String string : nodeNames) {
            names.add(string);
        }
        for (String string : instance.getNodeContainer().getNodes()) {
            if (!names.contains(string.getName())) continue;
            names.remove(string.getName());
        }
        if (!names.isEmpty()) {
            Object s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = (String)s + ", " + (String)names.get(i);
            }
            Assertions.fail((String)("Node(s) do not exist: " + (String)s));
        }
    }

    public void assertNumOfIncommingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getIncomingConnections().size() == num) break;
            Assertions.fail((String)("Expected incomming connections: " + num + " - found " + node.getIncomingConnections().size()));
        }
    }

    public void assertNumOfOutgoingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getOutgoingConnections().size() == num) break;
            Assertions.fail((String)("Expected outgoing connections: " + num + " - found " + node.getOutgoingConnections().size()));
        }
    }

    public void assertVersionEquals(ProcessInstance process, String version) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getVersion().equals(version)) {
            Assertions.fail((String)("Expected version: " + version + " - found " + instance.getWorkflowProcess().getVersion()));
        }
    }

    public void assertProcessNameEquals(ProcessInstance process, String name) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getName().equals(name)) {
            Assertions.fail((String)("Expected name: " + name + " - found " + instance.getWorkflowProcess().getName()));
        }
    }

    public void assertPackageNameEquals(ProcessInstance process, String packageName) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getPackageName().equals(packageName)) {
            Assertions.fail((String)("Expected package name: " + packageName + " - found " + instance.getWorkflowProcess().getPackageName()));
        }
    }

    public Object eval(Reader reader, Map vars) {
        try {
            return this.eval(this.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    private String toString(Reader reader) throws IOException {
        int charValue;
        StringBuilder sb = new StringBuilder(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public Object eval(String str, Map vars) {
        ParserContext context = new ParserContext();
        context.addPackageImport("org.jbpm.task");
        context.addPackageImport("org.jbpm.task.service");
        context.addPackageImport("org.jbpm.task.query");
        context.addPackageImport("java.util");
        vars.put("now", new Date());
        return MVEL.executeExpression((Object)MVEL.compileExpression((String)str, (ParserContext)context), (Map)vars);
    }

    protected void assertProcessInstanceCompleted(String processInstanceId, InternalProcessRuntime processRuntime) {
        ProcessInstance processInstance = processRuntime.getProcessInstance(processInstanceId);
        Assertions.assertNull((Object)processInstance, (String)"Process instance has not completed.");
    }

    protected void assertProcessInstanceAborted(String processInstanceId, InternalProcessRuntime processRuntime) {
        Assertions.assertNull((Object)processRuntime.getProcessInstance(processInstanceId));
    }

    protected void assertProcessInstanceActive(String processInstanceId, InternalProcessRuntime processRuntime) {
        Assertions.assertNotNull((Object)processRuntime.getProcessInstance(processInstanceId));
    }
}

