/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2;

import io.automatiko.engine.api.event.process.DefaultProcessEventListener;
import io.automatiko.engine.api.event.process.ProcessVariableChangedEvent;
import io.automatiko.engine.api.runtime.process.WorkItem;
import io.automatiko.engine.api.workflow.ProcessConfig;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.VariableViolationException;
import io.automatiko.engine.api.workflow.workitem.Policy;
import io.automatiko.engine.workflow.bpmn2.BpmnProcess;
import io.automatiko.engine.workflow.bpmn2.BpmnVariables;
import io.automatiko.engine.workflow.bpmn2.JbpmBpmn2TestCase;
import io.automatiko.engine.workflow.bpmn2.objects.TestWorkItemHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

public class VariableTagsTest
extends JbpmBpmn2TestCase {
    @Test
    public void testProcessWithMissingRequiredVariable() throws Exception {
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler("Human Task");
        ProcessConfig config = this.config(workItemHandler);
        BpmnProcess process = this.create(config, "variable-tags/approval-with-required-variable-tags.bpmn2");
        org.junit.jupiter.api.Assertions.assertThrows(VariableViolationException.class, () -> process.createInstance(BpmnVariables.create()));
    }

    @Test
    public void testProcessWithRequiredVariable() throws Exception {
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler("Human Task");
        ProcessConfig config = this.config(workItemHandler);
        BpmnProcess process = this.create(config, "variable-tags/approval-with-required-variable-tags.bpmn2");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        ProcessInstance instance = process.createInstance(BpmnVariables.create(parameters));
        instance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)instance.status());
        WorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        instance.completeWorkItem(workItem.getId(), null, new Policy[0]);
        workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        instance.completeWorkItem(workItem.getId(), null, new Policy[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)instance.status());
    }

    @Test
    public void testProcessWithReadonlyVariable() throws Exception {
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler("Human Task");
        ProcessConfig config = this.config(workItemHandler);
        BpmnProcess process = this.create(config, "variable-tags/approval-with-readonly-variable-tags.bpmn2");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        ProcessInstance instance = process.createInstance(BpmnVariables.create(parameters));
        instance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)instance.status());
        WorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertThrows(VariableViolationException.class, () -> instance.completeWorkItem(workItem.getId(), Collections.singletonMap("ActorId", "john"), new Policy[0]));
        instance.abort();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)instance.status());
    }

    @Test
    public void testProcessWithCustomVariableTag() throws Exception {
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler("Human Task");
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                if (event.hasTag("onlyAdmin")) {
                    throw new VariableViolationException(event.getProcessInstance().getId(), event.getVariableId(), "Variable can only be set by admins");
                }
            }
        };
        ProcessConfig config = this.config(Collections.singletonList(workItemHandler), Collections.singletonList(listener));
        BpmnProcess process = this.create(config, "variable-tags/approval-with-custom-variable-tags.bpmn2");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        org.junit.jupiter.api.Assertions.assertThrows(VariableViolationException.class, () -> process.createInstance(BpmnVariables.create((Map)parameters)));
    }

    @Test
    public void testRequiredVariableFiltering() {
        BpmnProcess process = this.create("variable-tags/approval-with-custom-variable-tags.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approver", "john");
        ProcessInstance instance = process.createInstance(BpmnVariables.create(params));
        instance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)instance.status());
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap()).hasSize(1);
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(BpmnVariables.OUTPUTS_ONLY)).hasSize(0);
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(BpmnVariables.INPUTS_ONLY)).hasSize(0);
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(BpmnVariables.INTERNAL_ONLY)).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(v -> v.hasTag("onlyAdmin"))).hasSize(1)).containsEntry((Object)"approver", (Object)"john");
        instance.abort();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)instance.status());
    }
}

