/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.objects;

import io.automatiko.engine.api.runtime.process.HumanTaskWorkItem;
import io.automatiko.engine.api.runtime.process.WorkItem;
import io.automatiko.engine.api.runtime.process.WorkItemHandler;
import io.automatiko.engine.api.runtime.process.WorkItemManager;
import io.automatiko.engine.api.workflow.workitem.Transition;
import io.automatiko.engine.workflow.base.instance.impl.humantask.HumanTaskWorkItemImpl;
import io.automatiko.engine.workflow.base.instance.impl.workitem.DefaultWorkItemManager;
import io.automatiko.engine.workflow.base.instance.impl.workitem.WorkItemImpl;
import java.util.ArrayList;
import java.util.List;

public class TestWorkItemHandler
implements WorkItemHandler {
    private String name;
    private List<WorkItem> workItems = new ArrayList<WorkItem>();

    public TestWorkItemHandler() {
    }

    public TestWorkItemHandler(String name) {
        this.name = name;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.workItems.add(workItem);
        if (workItem instanceof HumanTaskWorkItem) {
            HumanTaskWorkItemImpl humanTaskWorkItem = (HumanTaskWorkItemImpl)workItem;
            humanTaskWorkItem.setPhaseId("active");
            humanTaskWorkItem.setPhaseStatus("Ready");
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public WorkItem getWorkItem() {
        if (this.workItems.size() == 0) {
            return null;
        }
        if (this.workItems.size() == 1) {
            WorkItem result = this.workItems.get(0);
            this.workItems.clear();
            return result;
        }
        throw new IllegalArgumentException("More than one work item active");
    }

    public List<WorkItem> getWorkItems() {
        ArrayList<WorkItem> result = new ArrayList<WorkItem>(this.workItems);
        this.workItems.clear();
        return result;
    }

    public void transitionToPhase(WorkItem workItem, WorkItemManager manager, Transition<?> transition) {
        if (transition.phase().equals("complete")) {
            ((DefaultWorkItemManager)manager).internalCompleteWorkItem((WorkItem)((WorkItemImpl)workItem));
        }
    }

    public String getName() {
        return this.name;
    }
}

