/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.client;

import io.avaje.http.generator.client.KnownResponse;
import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.BeanParamReader;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.MethodParam;
import io.avaje.http.generator.core.MethodReader;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.PathSegments;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.RequestTimeoutPrism;
import io.avaje.http.generator.core.UType;
import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.WebMethod;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

class ClientMethodWriter {
    private static final KnownResponse KNOWN_RESPONSE = new KnownResponse();
    private static final String BODY_HANDLER = "java.net.http.HttpResponse.BodyHandler";
    private static final String COMPLETABLE_FUTURE = "java.util.concurrent.CompletableFuture";
    private static final String HTTP_CALL = "io.avaje.http.client.HttpCall";
    private final MethodReader method;
    private final Append writer;
    private final WebMethod webMethod;
    private final UType returnType;
    private MethodParam bodyHandlerParam;
    private String methodGenericParams = "";
    private final boolean useJsonb;
    private final Optional<RequestTimeoutPrism> timeout;

    ClientMethodWriter(MethodReader method, Append writer, boolean useJsonb) {
        this.method = method;
        this.writer = writer;
        this.webMethod = method.webMethod();
        this.returnType = Util.parseType(method.returnType());
        this.useJsonb = useJsonb;
        this.timeout = method.timeout();
    }

    void addImportTypes(ControllerReader reader) {
        reader.addImportTypes(this.returnType.importTypes());
        for (MethodParam param : this.method.params()) {
            reader.addImportTypes(param.utype().importTypes());
        }
    }

    private void methodStart(Append writer) {
        for (MethodParam param : this.method.params()) {
            this.checkBodyHandler(param);
        }
        writer.append("  // %s %s", new Object[]{this.webMethod, this.method.webMethodPath()}).eol();
        writer.append("  @Override").eol();
        writer.append("  public %s%s %s(", this.methodGenericParams, this.returnType.shortType(), this.method.simpleName());
        int count = 0;
        for (MethodParam param : this.method.params()) {
            if (count++ > 0) {
                writer.append(", ");
            }
            writer.append(param.utype().shortType()).append(" ");
            writer.append(param.name());
        }
        writer.append(") {").eol();
    }

    private void checkBodyHandler(MethodParam param) {
        if (param.rawType().startsWith(BODY_HANDLER)) {
            param.setResponseHandler();
            this.bodyHandlerParam = param;
            this.methodGenericParams = param.utype().genericParams();
        }
    }

    void write() {
        this.methodStart(this.writer);
        this.writer.append("    ");
        if (!this.method.isVoid()) {
            this.writer.append("return ");
        }
        this.writer.append("client.request()").eol();
        PathSegments pathSegments = this.method.pathSegments();
        Set<PathSegments.Segment> segments = pathSegments.segments();
        this.writeHeaders();
        this.writePaths(segments);
        this.writeQueryParams(pathSegments);
        this.writeBeanParams(pathSegments);
        this.writeFormParams(pathSegments);
        this.timeout.ifPresent(this::writeTimeout);
        this.writeBody();
        this.writeEnd();
    }

    private void writeTimeout(RequestTimeoutPrism p) {
        this.writer.append("      .requestTimeout(of(%s, %s))", p.value(), p.chronoUnit()).eol();
    }

    private void writeEnd() {
        WebMethod webMethod = this.method.webMethod();
        this.writer.append("      .%s()", webMethod.name()).eol();
        if (this.returnType == UType.VOID) {
            this.writer.append("      .asVoid();").eol();
        } else {
            String known = KNOWN_RESPONSE.get(this.returnType.full());
            if (known != null) {
                this.writer.append("      %s", known).eol();
            } else if (COMPLETABLE_FUTURE.equals(this.returnType.mainType())) {
                this.writeAsyncResponse();
            } else if (HTTP_CALL.equals(this.returnType.mainType())) {
                this.writeCallResponse();
            } else {
                this.writeSyncResponse();
            }
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeSyncResponse() {
        this.writer.append("      ");
        this.writeResponse(this.returnType);
    }

    private void writeAsyncResponse() {
        this.writer.append("      .async()");
        this.writeResponse(this.returnType.paramRaw());
    }

    private void writeCallResponse() {
        this.writer.append("      .call()");
        this.writeResponse(this.returnType.paramRaw());
    }

    private void writeResponse(UType type) {
        String mainType = type.mainType();
        UType param1 = type.paramRaw();
        if (this.isList(mainType)) {
            this.writer.append(".list(");
            this.writeGeneric(param1);
        } else if (this.isStream(mainType)) {
            this.writer.append(".stream(");
            this.writeGeneric(param1);
        } else if (this.isHttpResponse(mainType)) {
            if (this.bodyHandlerParam == null) {
                UType paramType = type.paramRaw();
                if (paramType.mainType().equals("java.util.List")) {
                    this.writer.append(".asList(");
                    this.writeGeneric(paramType.paramRaw());
                } else if (paramType.mainType().equals("java.util.stream.Stream")) {
                    this.writer.append(".asStream(");
                    this.writeGeneric(paramType.paramRaw());
                } else {
                    this.writer.append(".as(");
                    this.writeGeneric(paramType);
                }
            } else {
                this.writer.append(".handler(%s);", this.bodyHandlerParam.name()).eol();
            }
        } else {
            this.writer.append(".bean(");
            this.writeGeneric(type);
        }
    }

    void writeGeneric(UType type) {
        if (this.useJsonb && type.isGeneric()) {
            String params = type.importTypes().stream().skip(1L).map(Util::shortName).collect(Collectors.joining(".class, "));
            this.writer.append("Types.newParameterizedType(%s.class, %s.class)", Util.shortName(type.mainType()), params);
        } else {
            this.writer.append("%s.class", Util.shortName(type.mainType()));
        }
        this.writer.append(");").eol();
    }

    private void writeQueryParams(PathSegments pathSegments) {
        for (MethodParam param : this.method.params()) {
            ParamType paramType = param.paramType();
            if (paramType != ParamType.QUERYPARAM || pathSegments.segment(param.paramName()) != null) continue;
            if (this.isMap(param)) {
                this.writer.append("      .queryParam(%s)", param.name()).eol();
                continue;
            }
            this.writer.append("      .queryParam(\"%s\", %s)", param.paramName(), param.name()).eol();
        }
    }

    private void writeHeaders() {
        for (MethodParam param : this.method.params()) {
            ParamType paramType = param.paramType();
            if (paramType != ParamType.HEADER) continue;
            if (this.isMap(param)) {
                this.writer.append("      .header(%s)", param.name()).eol();
                continue;
            }
            this.writer.append("      .header(\"%s\", %s)", param.paramName(), param.name()).eol();
        }
    }

    private void writeBeanParams(PathSegments segments) {
        for (MethodParam param : this.method.params()) {
            String varName = param.name();
            ParamType paramType = param.paramType();
            PathSegments.Segment segment = segments.segment(varName);
            if (segment != null || paramType != ParamType.BEANPARAM) continue;
            TypeElement formBeanType = ProcessingContext.typeElement(param.rawType());
            BeanParamReader form = new BeanParamReader(formBeanType, param.name(), param.shortType(), ParamType.QUERYPARAM);
            form.writeFormParams(this.writer);
        }
    }

    private void writeFormParams(PathSegments segments) {
        for (MethodParam param : this.method.params()) {
            String varName = param.name();
            ParamType paramType = param.paramType();
            PathSegments.Segment segment = segments.segment(varName);
            if (segment != null) continue;
            this.writeFormParam(param, paramType);
        }
    }

    private void writeFormParam(MethodParam param, ParamType paramType) {
        if (paramType == ParamType.FORMPARAM) {
            if (this.isMap(param)) {
                this.writer.append("      .formParam(%s)", param.name()).eol();
            } else {
                this.writer.append("      .formParam(\"%s\", %s)", param.paramName(), param.name()).eol();
            }
        } else if (paramType == ParamType.FORM) {
            TypeElement formBeanType = ProcessingContext.typeElement(param.rawType());
            BeanParamReader form = new BeanParamReader(formBeanType, param.name(), param.shortType(), ParamType.FORMPARAM);
            form.writeFormParams(this.writer);
        }
    }

    private void writeBody() {
        for (MethodParam param : this.method.params()) {
            ParamType paramType = param.paramType();
            if (paramType != ParamType.BODY) continue;
            this.writer.append("      .body(%s)", param.name()).eol();
        }
    }

    private void writePaths(Set<PathSegments.Segment> segments) {
        if (!segments.isEmpty()) {
            this.writer.append("      ");
        }
        for (PathSegments.Segment segment : segments) {
            if (segment.isLiteral()) {
                this.writer.append(".path(\"").append(segment.literalSection()).append("\")");
                continue;
            }
            this.writer.append(".path(").append(segment.name()).append(")");
        }
        if (!segments.isEmpty()) {
            this.writer.eol();
        }
    }

    private boolean isMap(MethodParam param) {
        return this.isMap(param.utype().mainType());
    }

    private boolean isMap(String type0) {
        return type0.equals("java.util.Map");
    }

    private boolean isList(String type0) {
        return type0.equals("java.util.List");
    }

    private boolean isStream(String type0) {
        return type0.equals("java.util.stream.Stream");
    }

    private boolean isHttpResponse(String type0) {
        return type0.equals("java.net.http.HttpResponse");
    }
}

