/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.ControllerPrism;
import io.avaje.http.generator.core.HiddenPrism;
import io.avaje.http.generator.core.JavaxValidPrism;
import io.avaje.http.generator.core.MethodReader;
import io.avaje.http.generator.core.OpenAPIResponsePrism;
import io.avaje.http.generator.core.OpenAPIResponsesPrism;
import io.avaje.http.generator.core.PathPrism;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.ProducesPrism;
import io.avaje.http.generator.core.RequestScopeTypes;
import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.ValidPrism;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class ControllerReader {
    private final TypeElement beanType;
    private final List<Element> interfaces;
    private final List<ExecutableElement> interfaceMethods;
    private final List<String> roles;
    private final List<MethodReader> methods = new ArrayList<MethodReader>();
    private final Set<String> staticImportTypes = new TreeSet<String>();
    private final Set<String> importTypes = new TreeSet<String>();
    private final List<OpenAPIResponsePrism> apiResponses;
    private final String producesPrism;
    private final boolean hasValid;
    private boolean methodHasValid;
    private boolean requestScope;
    private boolean docHidden;

    public ControllerReader(TypeElement beanType) {
        this.beanType = beanType;
        this.interfaces = this.initInterfaces();
        this.interfaceMethods = this.initInterfaceMethods();
        this.roles = this.buildRoles();
        if (ProcessingContext.isOpenApiAvailable()) {
            this.docHidden = this.initDocHidden();
        }
        this.hasValid = this.initHasValid();
        this.producesPrism = this.initProduces();
        this.apiResponses = this.buildApiResponses();
    }

    private List<OpenAPIResponsePrism> buildApiResponses() {
        ArrayList<OpenAPIResponsePrism> responses = new ArrayList<OpenAPIResponsePrism>();
        this.buildApiResponsesFor(this.beanType, responses);
        for (Element anInterface : this.interfaces) {
            this.buildApiResponsesFor(anInterface, responses);
        }
        return responses;
    }

    private void buildApiResponsesFor(Element element, ArrayList<OpenAPIResponsePrism> responses) {
        OpenAPIResponsesPrism.getOptionalOn(element).stream().map(OpenAPIResponsesPrism::value).flatMap(Collection::stream).forEach(responses::add);
        responses.addAll(OpenAPIResponsePrism.getAllInstancesOn(element));
    }

    private ArrayList<String> buildRoles() {
        ArrayList<String> roleList = new ArrayList<String>(Util.findRoles(this.beanType));
        for (Element anInterface : this.interfaces) {
            roleList.addAll(Util.findRoles(anInterface));
        }
        return roleList;
    }

    void addImports(boolean withSingleton) {
        this.importTypes.add("io.avaje.http.api.*");
        this.importTypes.add(this.beanType.getQualifiedName().toString());
        if (this.hasValid || this.methodHasValid) {
            this.importTypes.add("io.avaje.http.api.Validator");
        }
        if (withSingleton) {
            if (ProcessingContext.useComponent()) {
                this.importTypes.add("io.avaje.inject.Component");
            } else {
                this.importTypes.add(ProcessingContext.useJavax() ? "javax.inject.Singleton" : "jakarta.inject.Singleton");
            }
        }
    }

    private List<Element> initInterfaces() {
        ArrayList<Element> interfaces = new ArrayList<Element>();
        for (TypeMirror typeMirror : this.beanType.getInterfaces()) {
            Element ifaceElement = ProcessingContext.asElement(typeMirror);
            ControllerPrism controller = ControllerPrism.getInstanceOn(ifaceElement);
            if ((controller == null || controller.value().isBlank()) && !PathPrism.isPresent(ifaceElement)) continue;
            interfaces.add(ifaceElement);
        }
        return interfaces;
    }

    private List<ExecutableElement> initInterfaceMethods() {
        ArrayList<ExecutableElement> ifaceMethods = new ArrayList<ExecutableElement>();
        for (Element anInterface : this.interfaces) {
            ifaceMethods.addAll(ElementFilter.methodsIn(anInterface.getEnclosedElements()));
        }
        return ifaceMethods;
    }

    private <A> Optional<A> findAnnotation(Function<Element, Optional<A>> func) {
        Optional<A> annotation = func.apply(this.beanType);
        if (annotation.isPresent()) {
            return annotation;
        }
        for (Element anInterface : this.interfaces) {
            annotation = func.apply(anInterface);
            if (!annotation.isPresent()) continue;
            return annotation;
        }
        return Optional.empty();
    }

    <A> Optional<A> findMethodAnnotation(Function<Element, Optional<A>> func, ExecutableElement element) {
        for (ExecutableElement interfaceMethod : this.interfaceMethods) {
            Optional<A> annotation;
            if (!this.matchMethod(interfaceMethod, element) || !(annotation = func.apply(interfaceMethod)).isPresent()) continue;
            return annotation;
        }
        return Optional.empty();
    }

    private boolean matchMethod(ExecutableElement interfaceMethod, ExecutableElement element) {
        return interfaceMethod.toString().equals(element.toString());
    }

    private String initProduces() {
        return this.findAnnotation(ProducesPrism::getOptionalOn).map(ProducesPrism::value).orElse(null);
    }

    private boolean initDocHidden() {
        return this.findAnnotation(HiddenPrism::getOptionalOn).isPresent();
    }

    private boolean initHasValid() {
        return this.findAnnotation(JavaxValidPrism::getOptionalOn).isPresent() || this.findAnnotation(ValidPrism::getOptionalOn).isPresent();
    }

    String produces() {
        return this.producesPrism;
    }

    public TypeElement beanType() {
        return this.beanType;
    }

    public boolean isDocHidden() {
        return this.docHidden;
    }

    public boolean isIncludeValidator() {
        return this.hasValid || this.methodHasValid;
    }

    public boolean hasValid() {
        return this.hasValid;
    }

    boolean isRequestScoped() {
        return this.requestScope;
    }

    public void read(boolean withSingleton) {
        if (!this.roles.isEmpty()) {
            ProcessingContext.platform().controllerRoles(this.roles, this);
        }
        for (Element element : this.beanType.getEnclosedElements()) {
            if (element.getKind() == ElementKind.METHOD) {
                this.readMethod((ExecutableElement)element);
                continue;
            }
            if (element.getKind() != ElementKind.FIELD) continue;
            this.readField(element);
        }
        this.readSuper(this.beanType);
        this.deriveIncludeValidation();
        this.addImports(withSingleton);
    }

    private void deriveIncludeValidation() {
        this.methodHasValid = this.methodHasValid();
    }

    private boolean methodHasValid() {
        for (MethodReader method : this.methods) {
            if (!method.hasValid()) continue;
            return true;
        }
        return false;
    }

    private void readField(Element element) {
        if (!this.requestScope) {
            String rawType = element.asType().toString();
            this.requestScope = RequestScopeTypes.isRequestType(rawType);
        }
    }

    private void readSuper(TypeElement beanType) {
        TypeMirror superclass = beanType.getSuperclass();
        if (superclass.getKind() != TypeKind.NONE) {
            DeclaredType declaredType = (DeclaredType)superclass;
            Element superElement = ProcessingContext.asElement(superclass);
            if (!"java.lang.Object".equals(superElement.toString())) {
                for (Element element : superElement.getEnclosedElements()) {
                    if (element.getKind() == ElementKind.METHOD) {
                        this.readMethod((ExecutableElement)element, declaredType);
                        continue;
                    }
                    if (element.getKind() != ElementKind.FIELD) continue;
                    this.readField(element);
                }
                if (superElement instanceof TypeElement) {
                    this.readSuper((TypeElement)superElement);
                }
            }
        }
    }

    private void readMethod(ExecutableElement element) {
        this.readMethod(element, null);
    }

    private void readMethod(ExecutableElement method, DeclaredType declaredType) {
        MethodReader methodReader;
        ExecutableType actualExecutable = null;
        if (declaredType != null) {
            actualExecutable = (ExecutableType)ProcessingContext.asMemberOf(declaredType, method);
        }
        if ((methodReader = new MethodReader(this, method, actualExecutable)).isWebMethod()) {
            methodReader.read();
            this.methods.add(methodReader);
        }
    }

    public List<String> roles() {
        return this.roles;
    }

    public List<MethodReader> methods() {
        return this.methods;
    }

    public List<OpenAPIResponsePrism> openApiResponses() {
        return this.apiResponses;
    }

    public String path() {
        return this.findAnnotation(ControllerPrism::getOptionalOn).map(ControllerPrism::value).filter(Predicate.not(String::isBlank)).or(() -> this.findAnnotation(PathPrism::getOptionalOn).map(PathPrism::value)).map(Util::trimPath).orElse(null);
    }

    public void addImportType(String rawType) {
        if (rawType.indexOf(46) > 0) {
            this.importTypes.add(rawType);
        }
    }

    public void addImportTypes(Set<String> types) {
        for (String type : types) {
            this.addImportType(type);
        }
    }

    public void addStaticImportType(String rawType) {
        this.staticImportTypes.add(rawType);
    }

    public Set<String> staticImportTypes() {
        return this.staticImportTypes;
    }

    public Set<String> importTypes() {
        return this.importTypes;
    }
}

