/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.MethodParam;
import io.avaje.http.generator.core.MethodReader;
import io.avaje.http.generator.core.PrimitiveUtil;
import io.avaje.http.generator.core.UType;
import io.avaje.http.generator.core.Util;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class JsonBUtil {
    private JsonBUtil() {
    }

    public static boolean detectJsonb() {
        try {
            Class.forName("io.avaje.jsonb.Jsonb");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Map<String, UType> jsonTypes(ControllerReader reader) {
        LinkedHashMap jsonTypes = new LinkedHashMap();
        Consumer<UType> addToMap = uType -> jsonTypes.put(uType.full(), uType);
        reader.methods().stream().filter(MethodReader::isWebMethod).filter(m -> !"byte[]".equals(m.returnType().toString())).filter(m -> m.produces() == null || m.produces().toLowerCase().contains("json")).forEach(methodReader -> {
            JsonBUtil.addJsonBodyType(methodReader, addToMap);
            if (!methodReader.isVoid()) {
                UType uType = UType.parse(methodReader.returnType());
                if (uType.mainType().equals("java.util.concurrent.CompletableFuture")) {
                    uType = uType.paramRaw();
                }
                addToMap.accept(uType);
            }
        });
        return Map.copyOf(jsonTypes);
    }

    private static void addJsonBodyType(MethodReader methodReader, Consumer<UType> addToMap) {
        if (methodReader.bodyType() != null) {
            methodReader.params().stream().filter(MethodParam::isBody).map(MethodParam::utype).forEach(addToMap);
        }
    }

    public static void writeJsonbType(UType type, Append writer) {
        writer.append("    this.%sJsonType = jsonB.type(", type.shortName());
        if (!type.isGeneric()) {
            writer.append("%s.class)", Util.shortName(PrimitiveUtil.wrap(type.full())));
        } else {
            switch (type.mainType()) {
                case "java.util.List": {
                    JsonBUtil.writeType(type.paramRaw(), writer);
                    writer.append(".list()");
                    break;
                }
                case "java.util.Set": {
                    JsonBUtil.writeType(type.paramRaw(), writer);
                    writer.append(".set()");
                    break;
                }
                case "java.util.Map": {
                    JsonBUtil.writeType(type.paramRaw(), writer);
                    writer.append(".map()");
                    break;
                }
                default: {
                    if (type.mainType().contains("java.util")) {
                        throw new UnsupportedOperationException("Only java.util Map, Set and List are supported JsonB Controller Collection Types");
                    }
                    JsonBUtil.writeType(type, writer);
                }
            }
        }
        writer.append(";").eol();
    }

    static void writeType(UType type, Append writer) {
        if (type.isGeneric()) {
            String params = type.importTypes().stream().skip(1L).map(Util::shortName).collect(Collectors.joining(".class, "));
            writer.append("Types.newParameterizedType(%s.class, %s.class))", Util.shortName(type.mainType()), params);
        } else {
            writer.append("%s.class)", Util.shortName(type.mainType()));
        }
    }
}

