/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.openapi.DocContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class ProcessingContext {
    private static PlatformAdapter readAdapter;
    private static Messager messager;
    private static Filer filer;
    private static Elements elements;
    private static Types types;
    private static boolean openApiAvailable;
    private static DocContext docContext;
    private static boolean useComponent;
    private static boolean useJavax;
    private static String diAnnotation;

    public static void init(ProcessingEnvironment env, PlatformAdapter adapter) {
        readAdapter = adapter;
        messager = env.getMessager();
        filer = env.getFiler();
        elements = env.getElementUtils();
        types = env.getTypeUtils();
        openApiAvailable = ProcessingContext.isTypeAvailable("io.swagger.v3.oas.annotations.OpenAPIDefinition");
        docContext = new DocContext(env, openApiAvailable);
        Map<String, String> options = env.getOptions();
        String singletonOverride = options.get("useSingleton");
        useComponent = singletonOverride != null ? !Boolean.parseBoolean(singletonOverride) : ProcessingContext.isTypeAvailable("io.avaje.inject.Component");
        diAnnotation = useComponent ? "@Component" : "@Singleton";
        boolean javax = ProcessingContext.isTypeAvailable("javax.inject.Singleton");
        boolean jakarta = ProcessingContext.isTypeAvailable("jakarta.inject.Singleton");
        String override = env.getOptions().get("useJavax");
        useJavax = override != null || javax && jakarta ? Boolean.parseBoolean(override) : javax;
    }

    private static boolean isTypeAvailable(String canonicalName) {
        return null != ProcessingContext.typeElement(canonicalName);
    }

    public static TypeElement typeElement(String canonicalName) {
        return elements.getTypeElement(canonicalName);
    }

    public static boolean isOpenApiAvailable() {
        return openApiAvailable;
    }

    public static boolean useJavax() {
        return useJavax;
    }

    public static boolean useComponent() {
        return useComponent;
    }

    public static void logError(Element e, String msg, Object ... args) {
        messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public static JavaFileObject createWriter(String cls, Element origin) throws IOException {
        return filer.createSourceFile(cls, origin);
    }

    public static FileObject createMetaInfWriter(String target) throws IOException {
        return filer.createResource(StandardLocation.CLASS_OUTPUT, "", target, new Element[0]);
    }

    public static String docComment(Element param) {
        return elements.getDocComment(param);
    }

    public static DocContext doc() {
        return docContext;
    }

    public static Element asElement(TypeMirror typeMirror) {
        return types.asElement(typeMirror);
    }

    public static TypeMirror asMemberOf(DeclaredType declaredType, Element element) {
        return types.asMemberOf(declaredType, element);
    }

    public static List<ExecutableElement> superMethods(Element element, String methodName) {
        return types.directSupertypes(element.asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> {
            TypeElement superClass = (TypeElement)types.asElement((TypeMirror)superType);
            for (ExecutableElement method : ElementFilter.methodsIn(elements.getAllMembers(superClass))) {
                if (!method.getSimpleName().contentEquals(methodName)) continue;
                return method;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static PlatformAdapter platform() {
        return readAdapter;
    }

    public static String diAnnotation() {
        return diAnnotation;
    }
}

