/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class SecuritySchemePrism {
    private String _type;
    private String _name;
    private String _description;
    private String _paramName;
    private String _in;
    private String _scheme;
    private String _bearerFormat;
    private OAuthFlowsPrism _flows;
    private String _openIdConnectUrl;
    private List<ExtensionPrism> _extensions;
    private String _ref;
    public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.security.SecurityScheme";
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static boolean isPresent(Element element) {
        return SecuritySchemePrism.getInstanceOn(element) != null;
    }

    public static SecuritySchemePrism getInstanceOn(Element element) {
        AnnotationMirror mirror = SecuritySchemePrism.getMirror(PRISM_TYPE, element);
        if (mirror == null) {
            return null;
        }
        return SecuritySchemePrism.getInstance(mirror);
    }

    public static List<SecuritySchemePrism> getAllInstancesOn(Element element) {
        return SecuritySchemePrism.getMirrors(PRISM_TYPE, element).stream().map(SecuritySchemePrism::getInstance).collect(Collectors.toList());
    }

    public static Optional<SecuritySchemePrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = SecuritySchemePrism.getMirror(PRISM_TYPE, element);
        if (mirror == null) {
            return Optional.empty();
        }
        return SecuritySchemePrism.getOptional(mirror);
    }

    public static SecuritySchemePrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new SecuritySchemePrism(mirror);
    }

    public static Optional<SecuritySchemePrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new SecuritySchemePrism(mirror));
    }

    private SecuritySchemePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        VariableElement typeMirror = this.getValue("type", VariableElement.class);
        this.valid = this.valid && typeMirror != null;
        this._type = typeMirror == null ? null : typeMirror.getSimpleName().toString();
        this._name = this.getValue("name", String.class);
        this._description = this.getValue("description", String.class);
        this._paramName = this.getValue("paramName", String.class);
        VariableElement variableElement = this.getValue("in", VariableElement.class);
        this.valid = this.valid && variableElement != null;
        this._in = variableElement == null ? null : variableElement.getSimpleName().toString();
        this._scheme = this.getValue("scheme", String.class);
        this._bearerFormat = this.getValue("bearerFormat", String.class);
        AnnotationMirror flowsMirror = this.getValue("flows", AnnotationMirror.class);
        this.valid = this.valid && flowsMirror != null;
        this._flows = flowsMirror == null ? null : OAuthFlowsPrism.getInstance(flowsMirror);
        this._openIdConnectUrl = this.getValue("openIdConnectUrl", String.class);
        List<AnnotationMirror> extensionsMirrors = this.getArrayValues("extensions", AnnotationMirror.class);
        this._extensions = new ArrayList<ExtensionPrism>(extensionsMirrors.size());
        for (AnnotationMirror extensionsMirror : extensionsMirrors) {
            this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
        }
        this._ref = this.getValue("ref", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String type() {
        return this._type;
    }

    public String name() {
        return this._name;
    }

    public String description() {
        return this._description;
    }

    public String paramName() {
        return this._paramName;
    }

    public String in() {
        return this._in;
    }

    public String scheme() {
        return this._scheme;
    }

    public String bearerFormat() {
        return this._bearerFormat;
    }

    public OAuthFlowsPrism flows() {
        return this._flows;
    }

    public String openIdConnectUrl() {
        return this._openIdConnectUrl;
    }

    public List<ExtensionPrism> extensions() {
        return this._extensions;
    }

    public String ref() {
        return this._ref;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = SecuritySchemePrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = SecuritySchemePrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static List<AnnotationMirror> getMirrors(String fqn, Element target) {
        ArrayList<AnnotationMirror> mirrors = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            mirrors.add(annotationMirror);
        }
        return mirrors;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : SecuritySchemePrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class OAuthFlowsPrism {
        private OAuthFlowPrism _implicit;
        private OAuthFlowPrism _password;
        private OAuthFlowPrism _clientCredentials;
        private OAuthFlowPrism _authorizationCode;
        private List<ExtensionPrism> _extensions;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.security.OAuthFlows";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static OAuthFlowsPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new OAuthFlowsPrism(mirror);
        }

        private static Optional<OAuthFlowsPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new OAuthFlowsPrism(mirror));
        }

        private OAuthFlowsPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            AnnotationMirror implicitMirror = this.getValue("implicit", AnnotationMirror.class);
            this.valid = this.valid && implicitMirror != null;
            this._implicit = implicitMirror == null ? null : OAuthFlowPrism.getInstance(implicitMirror);
            AnnotationMirror annotationMirror = this.getValue("password", AnnotationMirror.class);
            this.valid = this.valid && annotationMirror != null;
            this._password = annotationMirror == null ? null : OAuthFlowPrism.getInstance(annotationMirror);
            AnnotationMirror clientCredentialsMirror = this.getValue("clientCredentials", AnnotationMirror.class);
            this.valid = this.valid && clientCredentialsMirror != null;
            this._clientCredentials = clientCredentialsMirror == null ? null : OAuthFlowPrism.getInstance(clientCredentialsMirror);
            AnnotationMirror authorizationCodeMirror = this.getValue("authorizationCode", AnnotationMirror.class);
            this.valid = this.valid && authorizationCodeMirror != null;
            this._authorizationCode = authorizationCodeMirror == null ? null : OAuthFlowPrism.getInstance(authorizationCodeMirror);
            List<AnnotationMirror> extensionsMirrors = this.getArrayValues("extensions", AnnotationMirror.class);
            this._extensions = new ArrayList<ExtensionPrism>(extensionsMirrors.size());
            for (AnnotationMirror extensionsMirror : extensionsMirrors) {
                this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public OAuthFlowPrism implicit() {
            return this._implicit;
        }

        public OAuthFlowPrism password() {
            return this._password;
        }

        public OAuthFlowPrism clientCredentials() {
            return this._clientCredentials;
        }

        public OAuthFlowPrism authorizationCode() {
            return this._authorizationCode;
        }

        public List<ExtensionPrism> extensions() {
            return this._extensions;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = SecuritySchemePrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = SecuritySchemePrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static class Values {
            private Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue implicit() {
                return this.values.get("implicit");
            }

            public AnnotationValue password() {
                return this.values.get("password");
            }

            public AnnotationValue clientCredentials() {
                return this.values.get("clientCredentials");
            }

            public AnnotationValue authorizationCode() {
                return this.values.get("authorizationCode");
            }

            public AnnotationValue extensions() {
                return this.values.get("extensions");
            }
        }
    }

    public static class ExtensionPrism {
        private String _name;
        private List<ExtensionPropertyPrism> _properties;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.extensions.Extension";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ExtensionPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ExtensionPrism(mirror);
        }

        private static Optional<ExtensionPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ExtensionPrism(mirror));
        }

        private ExtensionPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            List<AnnotationMirror> propertiesMirrors = this.getArrayValues("properties", AnnotationMirror.class);
            this._properties = new ArrayList<ExtensionPropertyPrism>(propertiesMirrors.size());
            for (AnnotationMirror propertiesMirror : propertiesMirrors) {
                this._properties.add(ExtensionPropertyPrism.getInstance(propertiesMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public List<ExtensionPropertyPrism> properties() {
            return this._properties;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = SecuritySchemePrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = SecuritySchemePrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static class Values {
            private Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue properties() {
                return this.values.get("properties");
            }
        }
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue type() {
            return this.values.get("type");
        }

        public AnnotationValue name() {
            return this.values.get("name");
        }

        public AnnotationValue description() {
            return this.values.get("description");
        }

        public AnnotationValue paramName() {
            return this.values.get("paramName");
        }

        public AnnotationValue in() {
            return this.values.get("in");
        }

        public AnnotationValue scheme() {
            return this.values.get("scheme");
        }

        public AnnotationValue bearerFormat() {
            return this.values.get("bearerFormat");
        }

        public AnnotationValue flows() {
            return this.values.get("flows");
        }

        public AnnotationValue openIdConnectUrl() {
            return this.values.get("openIdConnectUrl");
        }

        public AnnotationValue extensions() {
            return this.values.get("extensions");
        }

        public AnnotationValue ref() {
            return this.values.get("ref");
        }
    }

    public static class OAuthScopePrism {
        private String _name;
        private String _description;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.security.OAuthScope";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static OAuthScopePrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new OAuthScopePrism(mirror);
        }

        private static Optional<OAuthScopePrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new OAuthScopePrism(mirror));
        }

        private OAuthScopePrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            this._description = this.getValue("description", String.class);
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public String description() {
            return this._description;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = SecuritySchemePrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = SecuritySchemePrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static class Values {
            private Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue description() {
                return this.values.get("description");
            }
        }
    }

    public static class ExtensionPropertyPrism {
        private String _name;
        private String _value;
        private Boolean _parseValue;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.extensions.ExtensionProperty";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static ExtensionPropertyPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new ExtensionPropertyPrism(mirror);
        }

        private static Optional<ExtensionPropertyPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new ExtensionPropertyPrism(mirror));
        }

        private ExtensionPropertyPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._name = this.getValue("name", String.class);
            this._value = this.getValue("value", String.class);
            this._parseValue = this.getValue("parseValue", Boolean.class);
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String name() {
            return this._name;
        }

        public String value() {
            return this._value;
        }

        public Boolean parseValue() {
            return this._parseValue;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = SecuritySchemePrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = SecuritySchemePrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static class Values {
            private Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue name() {
                return this.values.get("name");
            }

            public AnnotationValue value() {
                return this.values.get("value");
            }

            public AnnotationValue parseValue() {
                return this.values.get("parseValue");
            }
        }
    }

    public static class OAuthFlowPrism {
        private String _authorizationUrl;
        private String _tokenUrl;
        private String _refreshUrl;
        private List<OAuthScopePrism> _scopes;
        private List<ExtensionPrism> _extensions;
        public static final String PRISM_TYPE = "io.swagger.v3.oas.annotations.security.OAuthFlow";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
        private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
        private boolean valid = true;

        private static OAuthFlowPrism getInstance(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return null;
            }
            return new OAuthFlowPrism(mirror);
        }

        private static Optional<OAuthFlowPrism> getOptional(AnnotationMirror mirror) {
            if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
                return Optional.empty();
            }
            return Optional.of(new OAuthFlowPrism(mirror));
        }

        private OAuthFlowPrism(AnnotationMirror mirror) {
            for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
                this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
            }
            this._authorizationUrl = this.getValue("authorizationUrl", String.class);
            this._tokenUrl = this.getValue("tokenUrl", String.class);
            this._refreshUrl = this.getValue("refreshUrl", String.class);
            List<AnnotationMirror> scopesMirrors = this.getArrayValues("scopes", AnnotationMirror.class);
            this._scopes = new ArrayList<OAuthScopePrism>(scopesMirrors.size());
            for (AnnotationMirror scopesMirror : scopesMirrors) {
                this._scopes.add(OAuthScopePrism.getInstance(scopesMirror));
            }
            List<AnnotationMirror> list = this.getArrayValues("extensions", AnnotationMirror.class);
            this._extensions = new ArrayList<ExtensionPrism>(list.size());
            for (AnnotationMirror extensionsMirror : list) {
                this._extensions.add(ExtensionPrism.getInstance(extensionsMirror));
            }
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String authorizationUrl() {
            return this._authorizationUrl;
        }

        public String tokenUrl() {
            return this._tokenUrl;
        }

        public String refreshUrl() {
            return this._refreshUrl;
        }

        public List<OAuthScopePrism> scopes() {
            return this._scopes;
        }

        public List<ExtensionPrism> extensions() {
            return this._extensions;
        }

        private <T> T getValue(String name, Class<T> clazz) {
            T result = SecuritySchemePrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        private <T> List<T> getArrayValues(String name, Class<T> clazz) {
            List<T> result = SecuritySchemePrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static class Values {
            private Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public AnnotationValue authorizationUrl() {
                return this.values.get("authorizationUrl");
            }

            public AnnotationValue tokenUrl() {
                return this.values.get("tokenUrl");
            }

            public AnnotationValue refreshUrl() {
                return this.values.get("refreshUrl");
            }

            public AnnotationValue scopes() {
                return this.values.get("scopes");
            }

            public AnnotationValue extensions() {
                return this.values.get("extensions");
            }
        }
    }
}

