/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.type.TypeMirror;

public interface UType {
    public static final UType VOID = new VoidType();

    public static UType parse(TypeMirror type) {
        return Util.parseType(type);
    }

    public static UType parse(String type) {
        return Util.parse(type);
    }

    public Set<String> importTypes();

    public String shortType();

    public String shortName();

    public String mainType();

    default public String param0() {
        return null;
    }

    default public String param1() {
        return null;
    }

    default public UType paramRaw() {
        return null;
    }

    public String full();

    default public boolean isGeneric() {
        return false;
    }

    default public String genericParams() {
        return "";
    }

    public static class VoidType
    implements UType {
        @Override
        public Set<String> importTypes() {
            return Collections.emptySet();
        }

        @Override
        public String shortType() {
            return "void";
        }

        @Override
        public String shortName() {
            return "void";
        }

        @Override
        public String mainType() {
            return "java.lang.Void";
        }

        @Override
        public String full() {
            return "void";
        }
    }

    public static class Generic
    implements UType {
        final String rawType;
        final UType rawParamType;
        final List<String> allTypes;
        final String shortRawType;
        final String shortName;

        Generic(String rawTypeInput) {
            this.rawType = rawTypeInput.replace(" ", "");
            this.allTypes = Arrays.asList(this.rawType.split("[<|>|,]"));
            this.shortRawType = this.shortRawType(this.rawType, this.allTypes);
            this.shortName = Util.name(this.shortRawType);
            String paramTypeString = this.extractRawParam();
            this.rawParamType = paramTypeString != null ? UType.parse(paramTypeString) : null;
        }

        private String extractRawParam() {
            switch (this.mainType()) {
                case "java.util.Set": 
                case "java.util.List": 
                case "java.util.stream.Stream": 
                case "java.net.http.HttpResponse": 
                case "java.util.concurrent.CompletableFuture": 
                case "io.avaje.http.client.HttpCall": {
                    int first = this.rawType.indexOf("<") + 1;
                    int end = this.rawType.lastIndexOf(">");
                    return this.rawType.substring(first, end);
                }
                case "java.util.Map": {
                    int first = this.rawType.indexOf(",") + 1;
                    int end = this.rawType.lastIndexOf(">");
                    return this.rawType.substring(first, end);
                }
            }
            return null;
        }

        private String shortRawType(String rawType, List<String> allTypes) {
            LinkedHashMap<String, String> typeMap = new LinkedHashMap<String, String>();
            for (String val : allTypes) {
                typeMap.put(val, Util.shortName(val));
            }
            String shortRaw = rawType;
            for (Map.Entry entry : typeMap.entrySet()) {
                shortRaw = shortRaw.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            return shortRaw;
        }

        @Override
        public String full() {
            return this.rawType;
        }

        @Override
        public Set<String> importTypes() {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (String type : this.allTypes) {
                if (type.startsWith("java.lang.") || type.indexOf(46) <= -1) continue;
                if (type.startsWith("java")) {
                    set.add(type.replace("[]", ""));
                    continue;
                }
                set.add(this.innerTypesImport(type).replace("[]", ""));
            }
            return set;
        }

        public String innerTypesImport(String type) {
            String[] parts = type.split("\\.");
            Object result = "";
            boolean foundUpper = false;
            for (int i = 0; i < parts.length; ++i) {
                if (!Character.isUpperCase(parts[i].charAt(0))) {
                    result = (String)result + parts[i] + ".";
                    continue;
                }
                if (foundUpper) break;
                foundUpper = true;
                result = (String)result + parts[i] + (i == parts.length - 1 ? "" : ".");
            }
            if (((String)result).endsWith(".")) {
                result = ((String)result).substring(0, ((String)result).length() - 1);
            }
            return result;
        }

        @Override
        public boolean isGeneric() {
            return true;
        }

        @Override
        public String genericParams() {
            StringJoiner joiner = new StringJoiner(",");
            for (String type : this.allTypes) {
                if (type.indexOf(46) != -1) continue;
                joiner.add(type);
            }
            String commaDelim = joiner.toString();
            return commaDelim.isEmpty() ? "" : "<" + commaDelim + "> ";
        }

        @Override
        public String shortType() {
            return this.shortRawType;
        }

        @Override
        public String shortName() {
            return this.shortName.replace(".", "$");
        }

        @Override
        public String mainType() {
            return this.allTypes.isEmpty() ? null : this.allTypes.get(0);
        }

        @Override
        public String param0() {
            return this.allTypes.size() < 2 ? null : this.allTypes.get(1);
        }

        @Override
        public String param1() {
            return this.allTypes.size() < 3 ? null : this.allTypes.get(2);
        }

        @Override
        public UType paramRaw() {
            return this.rawParamType;
        }
    }

    public static class Basic
    implements UType {
        final String rawType;

        Basic(String rawType) {
            this.rawType = rawType;
        }

        @Override
        public String full() {
            return this.rawType;
        }

        @Override
        public Set<String> importTypes() {
            return this.rawType.startsWith("java.lang.") && this.rawType.indexOf(46) > -1 ? Set.of() : Collections.singleton(this.rawType.replace("[]", ""));
        }

        @Override
        public String shortType() {
            return Util.shortName(this.rawType);
        }

        @Override
        public String shortName() {
            return Util.initLower(this.shortType()).replace(".", "$");
        }

        @Override
        public String mainType() {
            return this.rawType;
        }
    }
}

