/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.UType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public class Util {
    public static UType parse(String rawType) {
        String type = Util.trimAnnotations(rawType);
        int pos = type.indexOf(60);
        if (pos == -1) {
            return new UType.Basic(type);
        }
        return new UType.Generic(type);
    }

    public static String typeDef(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return declaredType.asElement().toString();
        }
        return Util.trimAnnotations(typeMirror.toString());
    }

    public static String trimAnnotations(String type) {
        int pos = type.indexOf("@");
        if (pos == -1) {
            return type;
        }
        return type.substring(0, pos) + type.substring(type.lastIndexOf(32) + 1);
    }

    static String trimPath(String value) {
        return value.length() <= 1 ? value : Util.trimTrailingSlash(value);
    }

    private static String trimTrailingSlash(String value) {
        if (value.endsWith("/")) {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    static String combinePath(String beanPath, String webMethodPath) {
        StringBuilder sb = new StringBuilder();
        if (beanPath != null) {
            sb.append(beanPath);
        }
        if (webMethodPath != null) {
            if (!webMethodPath.isEmpty() && !webMethodPath.startsWith("/")) {
                sb.append("/");
            }
            sb.append(Util.trimTrailingSlash(webMethodPath));
        }
        return sb.toString();
    }

    public static String shortName(String fullType) {
        return Util.shortName(fullType, false);
    }

    public static String shortName(String fullType, boolean role) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        if (fullType.startsWith("java") || role) {
            return fullType.substring(p + 1);
        }
        Object result = "";
        boolean foundClass = false;
        for (String part : fullType.split("\\.")) {
            if (!foundClass && !Character.isUpperCase(part.charAt(0))) continue;
            foundClass = true;
            result = (String)result + (((String)result).isEmpty() ? "" : ".") + part;
        }
        return result;
    }

    public static String name(String name) {
        return Util.initLower(name.replaceAll("([,<>\\[\\]])", ""));
    }

    public static String snakeCase(String name) {
        StringBuilder sb = new StringBuilder(name.length() + 5);
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append("-");
                }
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String initLower(String input) {
        if (input.length() < 2) {
            return input.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(input.length());
        sb.append(Character.toLowerCase(input.charAt(0)));
        for (int i = 1; i < input.length(); ++i) {
            if (!Character.isUpperCase(input.charAt(i))) {
                sb.append(input.substring(i));
                break;
            }
            sb.append(Character.toLowerCase(input.charAt(i)));
        }
        return sb.toString();
    }

    public static String initcapSnake(String input) {
        StringBuilder sb = new StringBuilder(input.length());
        int len = input.length();
        boolean upper = true;
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '-') {
                sb.append(ch);
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(Character.toUpperCase(ch));
                upper = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static List<String> findRoles(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Iterator<? extends AnnotationValue> iterator;
            if (!Util.isRolesAnnotation(annotationMirror.getAnnotationType()) || !(iterator = annotationMirror.getElementValues().values().iterator()).hasNext()) continue;
            AnnotationValue annotationValue = iterator.next();
            return annotationValue.accept(new RoleReader(), annotationValue);
        }
        return Collections.emptyList();
    }

    private static boolean isRolesAnnotation(DeclaredType annotationType) {
        String name = annotationType.asElement().getSimpleName().toString();
        return name.endsWith("Roles") || name.endsWith("PermittedRoles");
    }

    public static String propertyName(String setterMethod) {
        String prop = setterMethod.substring(3);
        return Character.toLowerCase(prop.charAt(0)) + prop.substring(1);
    }

    public static UType parseType(TypeMirror returnType) {
        if (returnType.getKind() == TypeKind.VOID) {
            return UType.VOID;
        }
        return Util.parse(returnType.toString());
    }

    private static class RoleReader
    extends SimpleAnnotationValueVisitor8<List<String>, Object> {
        private final List<String> fullRoles = new ArrayList<String>();

        private RoleReader() {
        }

        @Override
        public List<String> visitArray(List<? extends AnnotationValue> values, Object o) {
            for (AnnotationValue annotationValue : values) {
                annotationValue.accept(this, o);
            }
            return this.fullRoles;
        }

        @Override
        public List<String> visitEnumConstant(VariableElement roleEnum, Object o) {
            this.fullRoles.add(String.valueOf(roleEnum.asType()) + "." + String.valueOf(roleEnum.getSimpleName()));
            return this.fullRoles;
        }
    }
}

