/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.client;

import io.avaje.http.generator.client.ClientPlatformAdapter;
import io.avaje.http.generator.client.ClientWriter;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.ImportPrism;
import io.avaje.http.generator.core.JsonBUtil;
import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.ProcessingContext;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;

@SupportedAnnotationTypes(value={"io.avaje.http.api.Client", "io.avaje.http.api.Client.Import"})
public class ClientProcessor
extends AbstractProcessor {
    private static final String METAINF_SERVICES_PROVIDER = "META-INF/services/io.avaje.http.client.HttpApiProvider";
    private final Set<String> generatedClients = new LinkedHashSet<String>();
    private final boolean useJsonB;

    public ClientProcessor() {
        this.useJsonB = JsonBUtil.detectJsonb();
    }

    public ClientProcessor(boolean useJsonb) {
        this.useJsonB = useJsonb;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnv = processingEnv;
        ProcessingContext.init(processingEnv, new ClientPlatformAdapter(), false);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        PlatformAdapter platform = ProcessingContext.platform();
        if (!(platform instanceof ClientPlatformAdapter)) {
            ProcessingContext.setPlatform(new ClientPlatformAdapter());
        }
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.avaje.http.api.Client"))) {
            this.writeClient(element);
        }
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.avaje.http.api.Client.Import"))) {
            this.writeForImported(element);
        }
        if (round.processingOver()) {
            this.writeServicesFile();
        }
        ProcessingContext.setPlatform(platform);
        return false;
    }

    private void writeServicesFile() {
        try {
            FileObject metaInfWriter = ProcessingContext.createMetaInfWriter(METAINF_SERVICES_PROVIDER);
            Writer writer = metaInfWriter.openWriter();
            for (String generatedClient : this.generatedClients) {
                writer.append(generatedClient).append("$Provider\n");
            }
            writer.close();
        }
        catch (IOException e) {
            ProcessingContext.logError(null, "Error writing services file " + String.valueOf(e), e);
        }
    }

    private void writeForImported(Element importedElement) {
        ImportPrism.getInstanceOn(importedElement).types().stream().map(ProcessingContext::asElement).filter(Objects::nonNull).forEach(this::writeClient);
    }

    private void writeClient(Element controller) {
        if (controller instanceof TypeElement) {
            ControllerReader reader = new ControllerReader((TypeElement)controller);
            reader.read(false);
            try {
                this.generatedClients.add(this.writeClientAdapter(reader));
            }
            catch (Throwable e) {
                e.printStackTrace();
                ProcessingContext.logError(reader.beanType(), "Failed to write client class " + String.valueOf(e), new Object[0]);
            }
        }
    }

    protected String writeClientAdapter(ControllerReader reader) throws IOException {
        return new ClientWriter(reader, this.useJsonB).write();
    }
}

